/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class IntRange {
    @Nullable
    final NumberProvider min;
    @Nullable
    final NumberProvider max;
    private final IntLimiter limiter;
    private final IntChecker predicate;

    public Set<LootContextParam<?>> getReferencedContextParams() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.min != null) {
            builder.addAll(this.min.getReferencedContextParams());
        }
        if (this.max != null) {
            builder.addAll(this.max.getReferencedContextParams());
        }
        return builder.build();
    }

    IntRange(@Nullable NumberProvider pMin, @Nullable NumberProvider pMax) {
        this.min = pMin;
        this.max = pMax;
        if (pMin == null) {
            if (pMax == null) {
                this.limiter = (p_165050_, p_165051_) -> p_165051_;
                this.predicate = (p_165043_, p_165044_) -> true;
            } else {
                this.limiter = (p_165054_, p_165055_) -> Math.min(pMax.getInt(p_165054_), p_165055_);
                this.predicate = (p_165047_, p_165048_) -> p_165048_ <= pMax.getInt(p_165047_);
            }
        } else if (pMax == null) {
            this.limiter = (p_165033_, p_165034_) -> Math.max(pMin.getInt(p_165033_), p_165034_);
            this.predicate = (p_165019_, p_165020_) -> p_165020_ >= pMin.getInt(p_165019_);
        } else {
            this.limiter = (p_165038_, p_165039_) -> Mth.clamp(p_165039_, pMin.getInt(p_165038_), pMax.getInt(p_165038_));
            this.predicate = (p_165024_, p_165025_) -> p_165025_ >= pMin.getInt(p_165024_) && p_165025_ <= pMax.getInt(p_165024_);
        }
    }

    public static IntRange exact(int pExactValue) {
        ConstantValue constantvalue = ConstantValue.exactly(pExactValue);
        return new IntRange(constantvalue, constantvalue);
    }

    public static IntRange range(int pMin, int pMax) {
        return new IntRange(ConstantValue.exactly(pMin), ConstantValue.exactly(pMax));
    }

    public static IntRange lowerBound(int pMin) {
        return new IntRange(ConstantValue.exactly(pMin), null);
    }

    public static IntRange upperBound(int pMax) {
        return new IntRange(null, ConstantValue.exactly(pMax));
    }

    public int clamp(LootContext pLootContext, int pValue) {
        return this.limiter.apply(pLootContext, pValue);
    }

    public boolean test(LootContext pLootContext, int pValue) {
        return this.predicate.test(pLootContext, pValue);
    }

    @FunctionalInterface
    static interface IntChecker {
        public boolean test(LootContext var1, int var2);
    }

    @FunctionalInterface
    static interface IntLimiter {
        public int apply(LootContext var1, int var2);
    }

    public static class Serializer
    implements JsonDeserializer<IntRange>,
    JsonSerializer<IntRange> {
        public IntRange deserialize(JsonElement p_165064_, Type p_165065_, JsonDeserializationContext p_165066_) {
            if (p_165064_.isJsonPrimitive()) {
                return IntRange.exact(p_165064_.getAsInt());
            }
            JsonObject jsonobject = GsonHelper.convertToJsonObject(p_165064_, "value");
            NumberProvider numberprovider = jsonobject.has("min") ? GsonHelper.getAsObject(jsonobject, "min", p_165066_, NumberProvider.class) : null;
            NumberProvider numberprovider1 = jsonobject.has("max") ? GsonHelper.getAsObject(jsonobject, "max", p_165066_, NumberProvider.class) : null;
            return new IntRange(numberprovider, numberprovider1);
        }

        public JsonElement serialize(IntRange p_165068_, Type p_165069_, JsonSerializationContext p_165070_) {
            JsonObject jsonobject = new JsonObject();
            if (Objects.equals(p_165068_.max, p_165068_.min)) {
                return p_165070_.serialize((Object)p_165068_.min);
            }
            if (p_165068_.max != null) {
                jsonobject.add("max", p_165070_.serialize((Object)p_165068_.max));
            }
            if (p_165068_.min != null) {
                jsonobject.add("min", p_165070_.serialize((Object)p_165068_.min));
            }
            return jsonobject;
        }
    }
}

