/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootPool {
    final LootPoolEntryContainer[] entries;
    final LootItemCondition[] conditions;
    private final Predicate<LootContext> compositeCondition;
    final LootItemFunction[] functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;
    final NumberProvider rolls;
    final NumberProvider bonusRolls;

    LootPool(LootPoolEntryContainer[] pEntries, LootItemCondition[] pConditions, LootItemFunction[] pFunctions, NumberProvider pRolls, NumberProvider pBonusRolls) {
        this.entries = pEntries;
        this.conditions = pConditions;
        this.compositeCondition = LootItemConditions.a(pConditions);
        this.functions = pFunctions;
        this.compositeFunction = LootItemFunctions.a(pFunctions);
        this.rolls = pRolls;
        this.bonusRolls = pBonusRolls;
    }

    private void addRandomItem(Consumer<ItemStack> p_79059_, LootContext p_79060_) {
        Random random = p_79060_.getRandom();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        LootPoolEntryContainer[] lootPoolEntryContainerArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            LootPoolEntryContainer lootpoolentrycontainer = lootPoolEntryContainerArray[n2];
            lootpoolentrycontainer.expand(p_79060_, p_79048_ -> {
                int k = p_79048_.getWeight(p_79060_.getLuck());
                if (k > 0) {
                    list.add(p_79048_);
                    mutableint.add(k);
                }
            });
            ++n2;
        }
        int i = list.size();
        if (mutableint.intValue() != 0 && i != 0) {
            if (i == 1) {
                ((LootPoolEntry)list.get(0)).createItemStack(p_79059_, p_79060_);
            } else {
                int j = random.nextInt(mutableint.intValue());
                for (LootPoolEntry lootpoolentry : list) {
                    if ((j -= lootpoolentry.getWeight(p_79060_.getLuck())) >= 0) continue;
                    lootpoolentry.createItemStack(p_79059_, p_79060_);
                    return;
                }
            }
        }
    }

    public void addRandomItems(Consumer<ItemStack> pStackConsumer, LootContext pLootContext) {
        if (this.compositeCondition.test(pLootContext)) {
            Consumer<ItemStack> consumer = LootItemFunction.decorate(this.compositeFunction, pStackConsumer, pLootContext);
            int i = this.rolls.getInt(pLootContext) + Mth.floor(this.bonusRolls.getFloat(pLootContext) * pLootContext.getLuck());
            int j = 0;
            while (j < i) {
                this.addRandomItem(consumer, pLootContext);
                ++j;
            }
        }
    }

    public void validate(ValidationContext pContext) {
        int i = 0;
        while (i < this.conditions.length) {
            this.conditions[i].validate(pContext.forChild(".condition[" + i + "]"));
            ++i;
        }
        int j = 0;
        while (j < this.functions.length) {
            this.functions[j].validate(pContext.forChild(".functions[" + j + "]"));
            ++j;
        }
        int k = 0;
        while (k < this.entries.length) {
            this.entries[k].validate(pContext.forChild(".entries[" + k + "]"));
            ++k;
        }
        this.rolls.validate(pContext.forChild(".rolls"));
        this.bonusRolls.validate(pContext.forChild(".bonusRolls"));
    }

    public static Builder lootPool() {
        return new Builder();
    }

    public static class Builder
    implements FunctionUserBuilder<Builder>,
    ConditionUserBuilder<Builder> {
        private final List<LootPoolEntryContainer> entries = Lists.newArrayList();
        private final List<LootItemCondition> conditions = Lists.newArrayList();
        private final List<LootItemFunction> functions = Lists.newArrayList();
        private NumberProvider rolls = ConstantValue.exactly(1.0f);
        private NumberProvider bonusRolls = ConstantValue.exactly(0.0f);

        public Builder setRolls(NumberProvider pRolls) {
            this.rolls = pRolls;
            return this;
        }

        @Override
        public Builder unwrap() {
            return this;
        }

        public Builder setBonusRolls(NumberProvider pBonusRolls) {
            this.bonusRolls = pBonusRolls;
            return this;
        }

        public Builder add(LootPoolEntryContainer.Builder<?> pEntriesBuilder) {
            this.entries.add(pEntriesBuilder.build());
            return this;
        }

        @Override
        public Builder when(LootItemCondition.Builder pConditionBuilder) {
            this.conditions.add(pConditionBuilder.build());
            return this;
        }

        @Override
        public Builder apply(LootItemFunction.Builder pFunctionBuilder) {
            this.functions.add(pFunctionBuilder.build());
            return this;
        }

        public LootPool build() {
            if (this.rolls == null) {
                throw new IllegalArgumentException("Rolls not set");
            }
            return new LootPool(this.entries.toArray(new LootPoolEntryContainer[0]), this.conditions.toArray(new LootItemCondition[0]), this.functions.toArray(new LootItemFunction[0]), this.rolls, this.bonusRolls);
        }
    }

    public static class Serializer
    implements JsonDeserializer<LootPool>,
    JsonSerializer<LootPool> {
        public LootPool deserialize(JsonElement p_79090_, Type p_79091_, JsonDeserializationContext p_79092_) throws JsonParseException {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(p_79090_, "loot pool");
            LootPoolEntryContainer[] alootpoolentrycontainer = GsonHelper.getAsObject(jsonobject, "entries", p_79092_, LootPoolEntryContainer[].class);
            LootItemCondition[] alootitemcondition = GsonHelper.getAsObject(jsonobject, "conditions", new LootItemCondition[0], p_79092_, LootItemCondition[].class);
            LootItemFunction[] alootitemfunction = GsonHelper.getAsObject(jsonobject, "functions", new LootItemFunction[0], p_79092_, LootItemFunction[].class);
            NumberProvider numberprovider = GsonHelper.getAsObject(jsonobject, "rolls", p_79092_, NumberProvider.class);
            NumberProvider numberprovider1 = GsonHelper.getAsObject(jsonobject, "bonus_rolls", ConstantValue.exactly(0.0f), p_79092_, NumberProvider.class);
            return new LootPool(alootpoolentrycontainer, alootitemcondition, alootitemfunction, numberprovider, numberprovider1);
        }

        public JsonElement serialize(LootPool p_79094_, Type p_79095_, JsonSerializationContext p_79096_) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("rolls", p_79096_.serialize((Object)p_79094_.rolls));
            jsonobject.add("bonus_rolls", p_79096_.serialize((Object)p_79094_.bonusRolls));
            jsonobject.add("entries", p_79096_.serialize((Object)p_79094_.entries));
            if (!ArrayUtils.isEmpty((Object[])p_79094_.conditions)) {
                jsonobject.add("conditions", p_79096_.serialize((Object)p_79094_.conditions));
            }
            if (!ArrayUtils.isEmpty((Object[])p_79094_.functions)) {
                jsonobject.add("functions", p_79096_.serialize((Object)p_79094_.functions));
            }
            return jsonobject;
        }
    }
}

