/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public class PredicateManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = Deserializers.createConditionSerializer().create();
    private Map<ResourceLocation, LootItemCondition> conditions = ImmutableMap.of();

    public PredicateManager() {
        super(GSON, "predicates");
    }

    @Nullable
    public LootItemCondition get(ResourceLocation pId) {
        return this.conditions.get(pId);
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        pObject.forEach((p_79235_, p_79236_) -> {
            try {
                if (p_79236_.isJsonArray()) {
                    LootItemCondition[] alootitemcondition = (LootItemCondition[])GSON.fromJson(p_79236_, LootItemCondition[].class);
                    builder.put(p_79235_, (Object)new CompositePredicate(alootitemcondition));
                } else {
                    LootItemCondition lootitemcondition = (LootItemCondition)GSON.fromJson(p_79236_, LootItemCondition.class);
                    builder.put(p_79235_, (Object)lootitemcondition);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't parse loot table {}", p_79235_, (Object)exception);
            }
        });
        ImmutableMap map = builder.build();
        ValidationContext validationcontext = new ValidationContext(LootContextParamSets.ALL_PARAMS, ((Map)map)::get, p_79255_ -> null);
        map.forEach((p_79239_, p_79240_) -> p_79240_.validate(validationcontext.enterCondition("{" + p_79239_ + "}", (ResourceLocation)p_79239_)));
        validationcontext.getProblems().forEach((p_79246_, p_79247_) -> LOGGER.warn("Found validation problem in {}: {}", p_79246_, p_79247_));
        this.conditions = map;
    }

    public Set<ResourceLocation> getKeys() {
        return Collections.unmodifiableSet(this.conditions.keySet());
    }

    static class CompositePredicate
    implements LootItemCondition {
        private final LootItemCondition[] terms;
        private final Predicate<LootContext> composedPredicate;

        CompositePredicate(LootItemCondition[] pTerms) {
            this.terms = pTerms;
            this.composedPredicate = LootItemConditions.a(pTerms);
        }

        @Override
        public final boolean test(LootContext p_79264_) {
            return this.composedPredicate.test(p_79264_);
        }

        @Override
        public void validate(ValidationContext pContext) {
            LootItemCondition.super.validate(pContext);
            int i = 0;
            while (i < this.terms.length) {
                this.terms[i].validate(pContext.forChild(".term[" + i + "]"));
                ++i;
            }
        }

        @Override
        public LootItemConditionType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

