/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.ArrayUtils;

public class AlternativesEntry
extends CompositeEntryBase {
    AlternativesEntry(LootPoolEntryContainer[] p_79384_, LootItemCondition[] p_79385_) {
        super(p_79384_, p_79385_);
    }

    @Override
    public LootPoolEntryType getType() {
        return LootPoolEntries.ALTERNATIVES;
    }

    @Override
    protected ComposableEntryContainer a(ComposableEntryContainer[] p_79390_) {
        switch (p_79390_.length) {
            case 0: {
                return ALWAYS_FALSE;
            }
            case 1: {
                return p_79390_[0];
            }
            case 2: {
                return p_79390_[0].or(p_79390_[1]);
            }
        }
        return (p_79393_, p_79394_) -> {
            ComposableEntryContainer[] composableEntryContainerArray2 = p_79390_;
            int n = p_79390_.length;
            int n2 = 0;
            while (n2 < n) {
                ComposableEntryContainer composableentrycontainer = composableEntryContainerArray2[n2];
                if (composableentrycontainer.expand(p_79393_, p_79394_)) {
                    return true;
                }
                ++n2;
            }
            return false;
        };
    }

    @Override
    public void validate(ValidationContext pValidationContext) {
        super.validate(pValidationContext);
        int i = 0;
        while (i < this.children.length - 1) {
            if (ArrayUtils.isEmpty((Object[])this.children[i].conditions)) {
                pValidationContext.reportProblem("Unreachable entry!");
            }
            ++i;
        }
    }

    public static Builder a(LootPoolEntryContainer.Builder<?> ... p_79396_) {
        return new Builder(p_79396_);
    }

    public static class Builder
    extends LootPoolEntryContainer.Builder<Builder> {
        private final List<LootPoolEntryContainer> entries = Lists.newArrayList();

        public Builder(LootPoolEntryContainer.Builder<?> ... pChildren) {
            LootPoolEntryContainer.Builder<?>[] builderArray = pChildren;
            int n = pChildren.length;
            int n2 = 0;
            while (n2 < n) {
                LootPoolEntryContainer.Builder<?> builder = builderArray[n2];
                this.entries.add(builder.build());
                ++n2;
            }
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder otherwise(LootPoolEntryContainer.Builder<?> pChildBuilder) {
            this.entries.add(pChildBuilder.build());
            return this;
        }

        @Override
        public LootPoolEntryContainer build() {
            return new AlternativesEntry(this.entries.toArray(new LootPoolEntryContainer[0]), this.getConditions());
        }
    }
}

