/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class CompositeEntryBase
extends LootPoolEntryContainer {
    protected final LootPoolEntryContainer[] children;
    private final ComposableEntryContainer composedChildren;

    protected CompositeEntryBase(LootPoolEntryContainer[] pChildren, LootItemCondition[] pConditions) {
        super(pConditions);
        this.children = pChildren;
        this.composedChildren = this.a(pChildren);
    }

    @Override
    public void validate(ValidationContext pValidationContext) {
        super.validate(pValidationContext);
        if (this.children.length == 0) {
            pValidationContext.reportProblem("Empty children list");
        }
        int i = 0;
        while (i < this.children.length) {
            this.children[i].validate(pValidationContext.forChild(".entry[" + i + "]"));
            ++i;
        }
    }

    protected abstract ComposableEntryContainer a(ComposableEntryContainer[] var1);

    @Override
    public final boolean expand(LootContext pLootContext, Consumer<LootPoolEntry> pEntryConsumer) {
        return !this.canRun(pLootContext) ? false : this.composedChildren.expand(pLootContext, pEntryConsumer);
    }

    public static <T extends CompositeEntryBase> LootPoolEntryContainer.Serializer<T> createSerializer(CompositeEntryConstructor<T> pFactory) {
        return new LootPoolEntryContainer.Serializer<T>(){

            @Override
            public void serializeCustom(JsonObject p_79449_, T p_79450_, JsonSerializationContext p_79451_) {
                p_79449_.add("children", p_79451_.serialize((Object)((CompositeEntryBase)p_79450_).children));
            }

            @Override
            public final T b(JsonObject p_79445_, JsonDeserializationContext p_79446_, LootItemCondition[] p_79447_) {
                LootPoolEntryContainer[] alootpoolentrycontainer = GsonHelper.getAsObject(p_79445_, "children", p_79446_, LootPoolEntryContainer[].class);
                return pFactory.create(alootpoolentrycontainer, p_79447_);
            }
        };
    }

    @FunctionalInterface
    public static interface CompositeEntryConstructor<T extends CompositeEntryBase> {
        public T create(LootPoolEntryContainer[] var1, LootItemCondition[] var2);
    }
}

