/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.EntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.SequentialEntry;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.apache.commons.lang3.ArrayUtils;

public abstract class LootPoolEntryContainer
implements ComposableEntryContainer {
    protected final LootItemCondition[] conditions;
    private final Predicate<LootContext> compositeCondition;

    protected LootPoolEntryContainer(LootItemCondition[] pConditions) {
        this.conditions = pConditions;
        this.compositeCondition = LootItemConditions.a(pConditions);
    }

    public void validate(ValidationContext pValidationContext) {
        int i = 0;
        while (i < this.conditions.length) {
            this.conditions[i].validate(pValidationContext.forChild(".condition[" + i + "]"));
            ++i;
        }
    }

    protected final boolean canRun(LootContext pLootContext) {
        return this.compositeCondition.test(pLootContext);
    }

    public abstract LootPoolEntryType getType();

    public static abstract class Builder<T extends Builder<T>>
    implements ConditionUserBuilder<T> {
        private final List<LootItemCondition> conditions = Lists.newArrayList();

        protected abstract T getThis();

        @Override
        public T when(LootItemCondition.Builder pConditionBuilder) {
            this.conditions.add(pConditionBuilder.build());
            return this.getThis();
        }

        @Override
        public final T unwrap() {
            return this.getThis();
        }

        protected LootItemCondition[] getConditions() {
            return this.conditions.toArray(new LootItemCondition[0]);
        }

        public AlternativesEntry.Builder otherwise(Builder<?> pChildBuilder) {
            return new AlternativesEntry.Builder(this, pChildBuilder);
        }

        public EntryGroup.Builder append(Builder<?> pChildBuilder) {
            return new EntryGroup.Builder(this, pChildBuilder);
        }

        public SequentialEntry.Builder then(Builder<?> pChildBuilder) {
            return new SequentialEntry.Builder(this, pChildBuilder);
        }

        public abstract LootPoolEntryContainer build();
    }

    public static abstract class Serializer<T extends LootPoolEntryContainer>
    implements net.minecraft.world.level.storage.loot.Serializer<T> {
        @Override
        public final void serialize(JsonObject pJson, T pValue, JsonSerializationContext pSerializationContext) {
            if (!ArrayUtils.isEmpty((Object[])((LootPoolEntryContainer)pValue).conditions)) {
                pJson.add("conditions", pSerializationContext.serialize((Object)((LootPoolEntryContainer)pValue).conditions));
            }
            this.serializeCustom(pJson, pValue, pSerializationContext);
        }

        @Override
        public final T deserialize(JsonObject pJson, JsonDeserializationContext pSerializationContext) {
            LootItemCondition[] alootitemcondition = GsonHelper.getAsObject(pJson, "conditions", new LootItemCondition[0], pSerializationContext, LootItemCondition[].class);
            return this.b(pJson, pSerializationContext, alootitemcondition);
        }

        public abstract void serializeCustom(JsonObject var1, T var2, JsonSerializationContext var3);

        public abstract T b(JsonObject var1, JsonDeserializationContext var2, LootItemCondition[] var3);
    }
}

