/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.ArrayUtils;

public abstract class LootPoolSingletonContainer
extends LootPoolEntryContainer {
    public static final int DEFAULT_WEIGHT = 1;
    public static final int DEFAULT_QUALITY = 0;
    protected final int weight;
    protected final int quality;
    protected final LootItemFunction[] functions;
    final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;
    private final LootPoolEntry entry = new EntryBase(this){

        @Override
        public void createItemStack(Consumer<ItemStack> p_79700_, LootContext p_79701_) {
            this.createItemStack(LootItemFunction.decorate(compositeFunction, p_79700_, p_79701_), p_79701_);
        }
    };

    protected LootPoolSingletonContainer(int pWeight, int pQuality, LootItemCondition[] pConditions, LootItemFunction[] pFunctions) {
        super(pConditions);
        this.weight = pWeight;
        this.quality = pQuality;
        this.functions = pFunctions;
        this.compositeFunction = LootItemFunctions.a(pFunctions);
    }

    @Override
    public void validate(ValidationContext pValidationContext) {
        super.validate(pValidationContext);
        int i = 0;
        while (i < this.functions.length) {
            this.functions[i].validate(pValidationContext.forChild(".functions[" + i + "]"));
            ++i;
        }
    }

    protected abstract void createItemStack(Consumer<ItemStack> var1, LootContext var2);

    @Override
    public boolean expand(LootContext pLootContext, Consumer<LootPoolEntry> pEntryConsumer) {
        if (this.canRun(pLootContext)) {
            pEntryConsumer.accept(this.entry);
            return true;
        }
        return false;
    }

    public static Builder<?> simpleBuilder(EntryConstructor pEntryBuilder) {
        return new DummyBuilder(pEntryBuilder);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends LootPoolEntryContainer.Builder<T>
    implements FunctionUserBuilder<T> {
        protected int weight = 1;
        protected int quality = 0;
        private final List<LootItemFunction> functions = Lists.newArrayList();

        @Override
        public T apply(LootItemFunction.Builder pFunctionBuilder) {
            this.functions.add(pFunctionBuilder.build());
            return (T)((Builder)this.getThis());
        }

        protected LootItemFunction[] getFunctions() {
            return this.functions.toArray(new LootItemFunction[0]);
        }

        public T setWeight(int pWeight) {
            this.weight = pWeight;
            return (T)((Builder)this.getThis());
        }

        public T setQuality(int pQuality) {
            this.quality = pQuality;
            return (T)((Builder)this.getThis());
        }
    }

    static class DummyBuilder
    extends Builder<DummyBuilder> {
        private final EntryConstructor constructor;

        public DummyBuilder(EntryConstructor p_79717_) {
            this.constructor = p_79717_;
        }

        @Override
        protected DummyBuilder getThis() {
            return this;
        }

        @Override
        public LootPoolEntryContainer build() {
            return this.constructor.build(this.weight, this.quality, this.getConditions(), this.getFunctions());
        }
    }

    protected abstract class EntryBase
    implements LootPoolEntry {
        protected EntryBase() {
        }

        @Override
        public int getWeight(float pLuck) {
            return Math.max(Mth.floor((float)LootPoolSingletonContainer.this.weight + (float)LootPoolSingletonContainer.this.quality * pLuck), 0);
        }
    }

    @FunctionalInterface
    protected static interface EntryConstructor {
        public LootPoolSingletonContainer build(int var1, int var2, LootItemCondition[] var3, LootItemFunction[] var4);
    }

    public static abstract class Serializer<T extends LootPoolSingletonContainer>
    extends LootPoolEntryContainer.Serializer<T> {
        @Override
        public void serializeCustom(JsonObject pObject, T pContext, JsonSerializationContext pConditions) {
            if (((LootPoolSingletonContainer)pContext).weight != 1) {
                pObject.addProperty("weight", (Number)((LootPoolSingletonContainer)pContext).weight);
            }
            if (((LootPoolSingletonContainer)pContext).quality != 0) {
                pObject.addProperty("quality", (Number)((LootPoolSingletonContainer)pContext).quality);
            }
            if (!ArrayUtils.isEmpty((Object[])((LootPoolSingletonContainer)pContext).functions)) {
                pObject.add("functions", pConditions.serialize((Object)((LootPoolSingletonContainer)pContext).functions));
            }
        }

        @Override
        public final T b(JsonObject p_79733_, JsonDeserializationContext p_79734_, LootItemCondition[] p_79735_) {
            int i = GsonHelper.getAsInt(p_79733_, "weight", 1);
            int j = GsonHelper.getAsInt(p_79733_, "quality", 0);
            LootItemFunction[] alootitemfunction = GsonHelper.getAsObject(p_79733_, "functions", new LootItemFunction[0], p_79734_, LootItemFunction[].class);
            return this.b(p_79733_, p_79734_, i, j, p_79735_, alootitemfunction);
        }

        protected abstract T b(JsonObject var1, JsonDeserializationContext var2, int var3, int var4, LootItemCondition[] var5, LootItemFunction[] var6);
    }
}

