/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ApplyBonusCount
extends LootItemConditionalFunction {
    static final Map<ResourceLocation, FormulaDeserializer> FORMULAS = Maps.newHashMap();
    final Enchantment enchantment;
    final Formula formula;

    static {
        FORMULAS.put(BinomialWithBonusCount.TYPE, BinomialWithBonusCount::deserialize);
        FORMULAS.put(OreDrops.TYPE, OreDrops::deserialize);
        FORMULAS.put(UniformBonusCount.TYPE, UniformBonusCount::deserialize);
    }

    ApplyBonusCount(LootItemCondition[] pConditions, Enchantment pEnchantment, Formula pFormula) {
        super(pConditions);
        this.enchantment = pEnchantment;
        this.formula = pFormula;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.APPLY_BONUS;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParams.TOOL);
    }

    @Override
    public ItemStack run(ItemStack pStack, LootContext pContext) {
        ItemStack itemstack = pContext.getParamOrNull(LootContextParams.TOOL);
        if (itemstack != null) {
            int i = EnchantmentHelper.getItemEnchantmentLevel(this.enchantment, itemstack);
            int j = this.formula.calculateNewCount(pContext.getRandom(), pStack.getCount(), i);
            pStack.setCount(j);
        }
        return pStack;
    }

    public static LootItemConditionalFunction.Builder<?> addBonusBinomialDistributionCount(Enchantment pEnchantment, float pProbability, int pExtraRounds) {
        return ApplyBonusCount.simpleBuilder(p_79928_ -> new ApplyBonusCount((LootItemCondition[])p_79928_, pEnchantment, new BinomialWithBonusCount(pExtraRounds, pProbability)));
    }

    public static LootItemConditionalFunction.Builder<?> addOreBonusCount(Enchantment p_79916_) {
        return ApplyBonusCount.simpleBuilder(p_79943_ -> new ApplyBonusCount((LootItemCondition[])p_79943_, p_79916_, new OreDrops()));
    }

    public static LootItemConditionalFunction.Builder<?> addUniformBonusCount(Enchantment pEnchantment) {
        return ApplyBonusCount.simpleBuilder(p_79935_ -> new ApplyBonusCount((LootItemCondition[])p_79935_, pEnchantment, new UniformBonusCount(1)));
    }

    public static LootItemConditionalFunction.Builder<?> addUniformBonusCount(Enchantment pEnchantment, int pBonusMultiplier) {
        return ApplyBonusCount.simpleBuilder(p_79932_ -> new ApplyBonusCount((LootItemCondition[])p_79932_, pEnchantment, new UniformBonusCount(pBonusMultiplier)));
    }

    static final class BinomialWithBonusCount
    implements Formula {
        public static final ResourceLocation TYPE = new ResourceLocation("binomial_with_bonus_count");
        private final int extraRounds;
        private final float probability;

        public BinomialWithBonusCount(int pExtraRounds, float pProbability) {
            this.extraRounds = pExtraRounds;
            this.probability = pProbability;
        }

        @Override
        public int calculateNewCount(Random pRandom, int pOriginalCount, int pEnchantmentLevel) {
            int i = 0;
            while (i < pEnchantmentLevel + this.extraRounds) {
                if (pRandom.nextFloat() < this.probability) {
                    ++pOriginalCount;
                }
                ++i;
            }
            return pOriginalCount;
        }

        @Override
        public void serializeParams(JsonObject pJson, JsonSerializationContext pSerializationContext) {
            pJson.addProperty("extra", (Number)this.extraRounds);
            pJson.addProperty("probability", (Number)Float.valueOf(this.probability));
        }

        public static Formula deserialize(JsonObject pJson, JsonDeserializationContext pDeserializationContext) {
            int i = GsonHelper.getAsInt(pJson, "extra");
            float f = GsonHelper.getAsFloat(pJson, "probability");
            return new BinomialWithBonusCount(i, f);
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }
    }

    static interface Formula {
        public int calculateNewCount(Random var1, int var2, int var3);

        public void serializeParams(JsonObject var1, JsonSerializationContext var2);

        public ResourceLocation getType();
    }

    static interface FormulaDeserializer {
        public Formula deserialize(JsonObject var1, JsonDeserializationContext var2);
    }

    static final class OreDrops
    implements Formula {
        public static final ResourceLocation TYPE = new ResourceLocation("ore_drops");

        OreDrops() {
        }

        @Override
        public int calculateNewCount(Random pRandom, int pOriginalCount, int pEnchantmentLevel) {
            if (pEnchantmentLevel > 0) {
                int i = pRandom.nextInt(pEnchantmentLevel + 2) - 1;
                if (i < 0) {
                    i = 0;
                }
                return pOriginalCount * (i + 1);
            }
            return pOriginalCount;
        }

        @Override
        public void serializeParams(JsonObject pJson, JsonSerializationContext pSerializationContext) {
        }

        public static Formula deserialize(JsonObject pJson, JsonDeserializationContext pDeserializationContext) {
            return new OreDrops();
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<ApplyBonusCount> {
        @Override
        public void serialize(JsonObject pJson, ApplyBonusCount pValue, JsonSerializationContext pSerializationContext) {
            super.serialize(pJson, pValue, pSerializationContext);
            pJson.addProperty("enchantment", Registry.ENCHANTMENT.getKey(pValue.enchantment).toString());
            pJson.addProperty("formula", pValue.formula.getType().toString());
            JsonObject jsonobject = new JsonObject();
            pValue.formula.serializeParams(jsonobject, pSerializationContext);
            if (jsonobject.size() > 0) {
                pJson.add("parameters", (JsonElement)jsonobject);
            }
        }

        @Override
        public ApplyBonusCount b(JsonObject p_79991_, JsonDeserializationContext p_79992_, LootItemCondition[] p_79993_) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(p_79991_, "enchantment"));
            Enchantment enchantment = Registry.ENCHANTMENT.getOptional(resourcelocation).orElseThrow(() -> new JsonParseException("Invalid enchantment id: " + resourcelocation));
            ResourceLocation resourcelocation1 = new ResourceLocation(GsonHelper.getAsString(p_79991_, "formula"));
            FormulaDeserializer applybonuscount$formuladeserializer = FORMULAS.get(resourcelocation1);
            if (applybonuscount$formuladeserializer == null) {
                throw new JsonParseException("Invalid formula id: " + resourcelocation1);
            }
            Formula applybonuscount$formula = p_79991_.has("parameters") ? applybonuscount$formuladeserializer.deserialize(GsonHelper.getAsJsonObject(p_79991_, "parameters"), p_79992_) : applybonuscount$formuladeserializer.deserialize(new JsonObject(), p_79992_);
            return new ApplyBonusCount(p_79993_, enchantment, applybonuscount$formula);
        }
    }

    static final class UniformBonusCount
    implements Formula {
        public static final ResourceLocation TYPE = new ResourceLocation("uniform_bonus_count");
        private final int bonusMultiplier;

        public UniformBonusCount(int pBonusMultiplier) {
            this.bonusMultiplier = pBonusMultiplier;
        }

        @Override
        public int calculateNewCount(Random pRandom, int pOriginalCount, int pEnchantmentLevel) {
            return pOriginalCount + pRandom.nextInt(this.bonusMultiplier * pEnchantmentLevel + 1);
        }

        @Override
        public void serializeParams(JsonObject pJson, JsonSerializationContext pSerializationContext) {
            pJson.addProperty("bonusMultiplier", (Number)this.bonusMultiplier);
        }

        public static Formula deserialize(JsonObject pJson, JsonDeserializationContext pDeserializationContext) {
            int i = GsonHelper.getAsInt(pJson, "bonusMultiplier");
            return new UniformBonusCount(i);
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }
    }
}

