/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ApplyExplosionDecay
extends LootItemConditionalFunction {
    ApplyExplosionDecay(LootItemCondition[] p_80029_) {
        super(p_80029_);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.EXPLOSION_DECAY;
    }

    @Override
    public ItemStack run(ItemStack pStack, LootContext pContext) {
        Float f = pContext.getParamOrNull(LootContextParams.EXPLOSION_RADIUS);
        if (f != null) {
            Random random = pContext.getRandom();
            float f1 = 1.0f / f.floatValue();
            int i = pStack.getCount();
            int j = 0;
            int k = 0;
            while (k < i) {
                if (random.nextFloat() <= f1) {
                    ++j;
                }
                ++k;
            }
            pStack.setCount(j);
        }
        return pStack;
    }

    public static LootItemConditionalFunction.Builder<?> explosionDecay() {
        return ApplyExplosionDecay.simpleBuilder(ApplyExplosionDecay::new);
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<ApplyExplosionDecay> {
        @Override
        public ApplyExplosionDecay b(JsonObject p_80040_, JsonDeserializationContext p_80041_, LootItemCondition[] p_80042_) {
            return new ApplyExplosionDecay(p_80042_);
        }
    }
}

