/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyNameFunction
extends LootItemConditionalFunction {
    final NameSource source;

    CopyNameFunction(LootItemCondition[] pConditions, NameSource pNameSource) {
        super(pConditions);
        this.source = pNameSource;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.COPY_NAME;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(this.source.param);
    }

    @Override
    public ItemStack run(ItemStack pStack, LootContext pContext) {
        Nameable nameable;
        Object object = pContext.getParamOrNull(this.source.param);
        if (object instanceof Nameable && (nameable = (Nameable)object).hasCustomName()) {
            pStack.setHoverName(nameable.getDisplayName());
        }
        return pStack;
    }

    public static LootItemConditionalFunction.Builder<?> copyName(NameSource pSource) {
        return CopyNameFunction.simpleBuilder(p_80191_ -> new CopyNameFunction((LootItemCondition[])p_80191_, pSource));
    }

    public static enum NameSource {
        THIS("this", LootContextParams.THIS_ENTITY),
        KILLER("killer", LootContextParams.KILLER_ENTITY),
        KILLER_PLAYER("killer_player", LootContextParams.LAST_DAMAGE_PLAYER),
        BLOCK_ENTITY("block_entity", LootContextParams.BLOCK_ENTITY);

        public final String name;
        public final LootContextParam<?> param;

        private NameSource(String p_80206_, LootContextParam<?> p_80207_) {
            this.name = p_80206_;
            this.param = p_80207_;
        }

        public static NameSource getByName(String pName) {
            NameSource[] nameSourceArray = NameSource.values();
            int n = nameSourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                NameSource copynamefunction$namesource = nameSourceArray[n2];
                if (copynamefunction$namesource.name.equals(pName)) {
                    return copynamefunction$namesource;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid name source " + pName);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<CopyNameFunction> {
        @Override
        public void serialize(JsonObject pJson, CopyNameFunction pValue, JsonSerializationContext pSerializationContext) {
            super.serialize(pJson, pValue, pSerializationContext);
            pJson.addProperty("source", pValue.source.name);
        }

        @Override
        public CopyNameFunction b(JsonObject p_80215_, JsonDeserializationContext p_80216_, LootItemCondition[] p_80217_) {
            NameSource copynamefunction$namesource = NameSource.getByName(GsonHelper.getAsString(p_80215_, "source"));
            return new CopyNameFunction(p_80217_, copynamefunction$namesource);
        }
    }
}

