/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;

public class CopyNbtFunction
extends LootItemConditionalFunction {
    final NbtProvider source;
    final List<CopyOperation> operations;

    CopyNbtFunction(LootItemCondition[] pConditions, NbtProvider pNbtSource, List<CopyOperation> pNbtOperations) {
        super(pConditions);
        this.source = pNbtSource;
        this.operations = ImmutableList.copyOf(pNbtOperations);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.COPY_NBT;
    }

    static NbtPathArgument.NbtPath compileNbtPath(String pNbtPath) {
        try {
            return new NbtPathArgument().parse(new StringReader(pNbtPath));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            throw new IllegalArgumentException("Failed to parse path " + pNbtPath, commandsyntaxexception);
        }
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.source.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack pStack, LootContext pContext) {
        Tag tag = this.source.get(pContext);
        if (tag != null) {
            this.operations.forEach(p_80255_ -> p_80255_.apply(pStack::getOrCreateTag, tag));
        }
        return pStack;
    }

    public static Builder copyData(NbtProvider pEntitySource) {
        return new Builder(pEntitySource);
    }

    public static Builder copyData(LootContext.EntityTarget pEntitySource) {
        return new Builder(ContextNbtProvider.forContextEntity(pEntitySource));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final NbtProvider source;
        private final List<CopyOperation> ops = Lists.newArrayList();

        Builder(NbtProvider pNbtSource) {
            this.source = pNbtSource;
        }

        public Builder copy(String pSourcePath, String pTargetPath, MergeStrategy pCopyAction) {
            this.ops.add(new CopyOperation(pSourcePath, pTargetPath, pCopyAction));
            return this;
        }

        public Builder copy(String pSourcePath, String pTargetPath) {
            return this.copy(pSourcePath, pTargetPath, MergeStrategy.REPLACE);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new CopyNbtFunction(this.getConditions(), this.source, this.ops);
        }
    }

    static class CopyOperation {
        private final String sourcePathText;
        private final NbtPathArgument.NbtPath sourcePath;
        private final String targetPathText;
        private final NbtPathArgument.NbtPath targetPath;
        private final MergeStrategy op;

        CopyOperation(String pSourcePathText, String pTargetPathText, MergeStrategy pMergeStrategy) {
            this.sourcePathText = pSourcePathText;
            this.sourcePath = CopyNbtFunction.compileNbtPath(pSourcePathText);
            this.targetPathText = pTargetPathText;
            this.targetPath = CopyNbtFunction.compileNbtPath(pTargetPathText);
            this.op = pMergeStrategy;
        }

        public void apply(Supplier<Tag> pTargetTag, Tag pSourceTag) {
            try {
                List<Tag> list = this.sourcePath.get(pSourceTag);
                if (!list.isEmpty()) {
                    this.op.merge(pTargetTag.get(), this.targetPath, list);
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }

        public JsonObject toJson() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("source", this.sourcePathText);
            jsonobject.addProperty("target", this.targetPathText);
            jsonobject.addProperty("op", this.op.name);
            return jsonobject;
        }

        public static CopyOperation fromJson(JsonObject pJson) {
            String s = GsonHelper.getAsString(pJson, "source");
            String s1 = GsonHelper.getAsString(pJson, "target");
            MergeStrategy copynbtfunction$mergestrategy = MergeStrategy.getByName(GsonHelper.getAsString(pJson, "op"));
            return new CopyOperation(s, s1, copynbtfunction$mergestrategy);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum MergeStrategy {
        REPLACE("replace"){

            @Override
            public void merge(Tag p_80362_, NbtPathArgument.NbtPath p_80363_, List<Tag> p_80364_) throws CommandSyntaxException {
                p_80363_.set(p_80362_, ((Tag)Iterables.getLast(p_80364_))::copy);
            }
        }
        ,
        APPEND("append"){

            @Override
            public void merge(Tag p_80373_, NbtPathArgument.NbtPath p_80374_, List<Tag> p_80375_) throws CommandSyntaxException {
                List<Tag> list = p_80374_.getOrCreate(p_80373_, ListTag::new);
                list.forEach(p_80371_ -> {
                    if (p_80371_ instanceof ListTag) {
                        p_80375_.forEach(p_165187_ -> ((ListTag)p_80371_).add(p_165187_.copy()));
                    }
                });
            }
        }
        ,
        MERGE("merge"){

            @Override
            public void merge(Tag p_80387_, NbtPathArgument.NbtPath p_80388_, List<Tag> p_80389_) throws CommandSyntaxException {
                List<Tag> list = p_80388_.getOrCreate(p_80387_, CompoundTag::new);
                list.forEach(p_80385_ -> {
                    if (p_80385_ instanceof CompoundTag) {
                        p_80389_.forEach(p_165190_ -> {
                            if (p_165190_ instanceof CompoundTag) {
                                ((CompoundTag)p_80385_).merge((CompoundTag)p_165190_);
                            }
                        });
                    }
                });
            }
        };

        final String name;

        public abstract void merge(Tag var1, NbtPathArgument.NbtPath var2, List<Tag> var3) throws CommandSyntaxException;

        private MergeStrategy(String p_80341_) {
            this.name = p_80341_;
        }

        public static MergeStrategy getByName(String pName) {
            MergeStrategy[] mergeStrategyArray = MergeStrategy.values();
            int n = mergeStrategyArray.length;
            int n2 = 0;
            while (n2 < n) {
                MergeStrategy copynbtfunction$mergestrategy = mergeStrategyArray[n2];
                if (copynbtfunction$mergestrategy.name.equals(pName)) {
                    return copynbtfunction$mergestrategy;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid merge strategy" + pName);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<CopyNbtFunction> {
        @Override
        public void serialize(JsonObject pJson, CopyNbtFunction pValue, JsonSerializationContext pSerializationContext) {
            super.serialize(pJson, pValue, pSerializationContext);
            pJson.add("source", pSerializationContext.serialize((Object)pValue.source));
            JsonArray jsonarray = new JsonArray();
            pValue.operations.stream().map(CopyOperation::toJson).forEach(arg_0 -> ((JsonArray)jsonarray).add(arg_0));
            pJson.add("ops", (JsonElement)jsonarray);
        }

        @Override
        public CopyNbtFunction b(JsonObject p_80395_, JsonDeserializationContext p_80396_, LootItemCondition[] p_80397_) {
            NbtProvider nbtprovider = GsonHelper.getAsObject(p_80395_, "source", p_80396_, NbtProvider.class);
            ArrayList list = Lists.newArrayList();
            for (JsonElement jsonelement : GsonHelper.getAsJsonArray(p_80395_, "ops")) {
                JsonObject jsonobject = GsonHelper.convertToJsonObject(jsonelement, "op");
                list.add(CopyOperation.fromJson(jsonobject));
            }
            return new CopyNbtFunction(p_80397_, nbtprovider, list);
        }
    }
}

