/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class EnchantRandomlyFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    final List<Enchantment> enchantments;

    EnchantRandomlyFunction(LootItemCondition[] pConditions, Collection<Enchantment> pPossibleEnchantments) {
        super(pConditions);
        this.enchantments = ImmutableList.copyOf(pPossibleEnchantments);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.ENCHANT_RANDOMLY;
    }

    @Override
    public ItemStack run(ItemStack pStack, LootContext pContext) {
        Enchantment enchantment;
        Random random = pContext.getRandom();
        if (this.enchantments.isEmpty()) {
            boolean flag = pStack.is(Items.BOOK);
            List list = Registry.ENCHANTMENT.stream().filter(Enchantment::isDiscoverable).filter(p_80436_ -> flag || p_80436_.canEnchant(pStack)).collect(Collectors.toList());
            if (list.isEmpty()) {
                LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)pStack);
                return pStack;
            }
            enchantment = (Enchantment)list.get(random.nextInt(list.size()));
        } else {
            enchantment = this.enchantments.get(random.nextInt(this.enchantments.size()));
        }
        return EnchantRandomlyFunction.enchantItem(pStack, enchantment, random);
    }

    private static ItemStack enchantItem(ItemStack pStack, Enchantment pEnchantment, Random pRandom) {
        int i = Mth.nextInt(pRandom, pEnchantment.getMinLevel(), pEnchantment.getMaxLevel());
        if (pStack.is(Items.BOOK)) {
            pStack = new ItemStack(Items.ENCHANTED_BOOK);
            EnchantedBookItem.addEnchantment(pStack, new EnchantmentInstance(pEnchantment, i));
        } else {
            pStack.enchant(pEnchantment, i);
        }
        return pStack;
    }

    public static Builder randomEnchantment() {
        return new Builder();
    }

    public static LootItemConditionalFunction.Builder<?> randomApplicableEnchantment() {
        return EnchantRandomlyFunction.simpleBuilder(p_80438_ -> new EnchantRandomlyFunction((LootItemCondition[])p_80438_, (Collection<Enchantment>)ImmutableList.of()));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Set<Enchantment> enchantments = Sets.newHashSet();

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withEnchantment(Enchantment pEnchantment) {
            this.enchantments.add(pEnchantment);
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new EnchantRandomlyFunction(this.getConditions(), this.enchantments);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<EnchantRandomlyFunction> {
        @Override
        public void serialize(JsonObject pJson, EnchantRandomlyFunction pValue, JsonSerializationContext pSerializationContext) {
            super.serialize(pJson, pValue, pSerializationContext);
            if (!pValue.enchantments.isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (Enchantment enchantment : pValue.enchantments) {
                    ResourceLocation resourcelocation = Registry.ENCHANTMENT.getKey(enchantment);
                    if (resourcelocation == null) {
                        throw new IllegalArgumentException("Don't know how to serialize enchantment " + enchantment);
                    }
                    jsonarray.add((JsonElement)new JsonPrimitive(resourcelocation.toString()));
                }
                pJson.add("enchantments", (JsonElement)jsonarray);
            }
        }

        @Override
        public EnchantRandomlyFunction b(JsonObject p_80450_, JsonDeserializationContext p_80451_, LootItemCondition[] p_80452_) {
            ArrayList list = Lists.newArrayList();
            if (p_80450_.has("enchantments")) {
                for (JsonElement jsonelement : GsonHelper.getAsJsonArray(p_80450_, "enchantments")) {
                    String s = GsonHelper.convertToString(jsonelement, "enchantment");
                    Enchantment enchantment = Registry.ENCHANTMENT.getOptional(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown enchantment '" + s + "'"));
                    list.add(enchantment);
                }
            }
            return new EnchantRandomlyFunction(p_80452_, list);
        }
    }
}

