/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SetAttributesFunction
extends LootItemConditionalFunction {
    final List<Modifier> modifiers;

    SetAttributesFunction(LootItemCondition[] pConditions, List<Modifier> pModifiers) {
        super(pConditions);
        this.modifiers = ImmutableList.copyOf(pModifiers);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_ATTRIBUTES;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return (Set)this.modifiers.stream().flatMap(p_165234_ -> p_165234_.amount.getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack pStack, LootContext pContext) {
        Random random = pContext.getRandom();
        for (Modifier setattributesfunction$modifier : this.modifiers) {
            UUID uuid = setattributesfunction$modifier.id;
            if (uuid == null) {
                uuid = UUID.randomUUID();
            }
            EquipmentSlot equipmentslot = Util.a(setattributesfunction$modifier.slots, random);
            pStack.addAttributeModifier(setattributesfunction$modifier.attribute, new AttributeModifier(uuid, setattributesfunction$modifier.name, (double)setattributesfunction$modifier.amount.getFloat(pContext), setattributesfunction$modifier.operation), equipmentslot);
        }
        return pStack;
    }

    public static ModifierBuilder modifier(String pName, Attribute pAttribute, AttributeModifier.Operation pOperation, NumberProvider pValue) {
        return new ModifierBuilder(pName, pAttribute, pOperation, pValue);
    }

    public static Builder setAttributes() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<Modifier> modifiers = Lists.newArrayList();

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withModifier(ModifierBuilder pModifierBuilder) {
            this.modifiers.add(pModifierBuilder.build());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetAttributesFunction(this.getConditions(), this.modifiers);
        }
    }

    static class Modifier {
        final String name;
        final Attribute attribute;
        final AttributeModifier.Operation operation;
        final NumberProvider amount;
        @Nullable
        final UUID id;
        final EquipmentSlot[] slots;

        Modifier(String pName, Attribute pAttribute, AttributeModifier.Operation pOperation, NumberProvider pAmount, EquipmentSlot[] pSlots, @Nullable UUID pId) {
            this.name = pName;
            this.attribute = pAttribute;
            this.operation = pOperation;
            this.amount = pAmount;
            this.id = pId;
            this.slots = pSlots;
        }

        public JsonObject serialize(JsonSerializationContext pContext) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("name", this.name);
            jsonobject.addProperty("attribute", Registry.ATTRIBUTE.getKey(this.attribute).toString());
            jsonobject.addProperty("operation", Modifier.operationToString(this.operation));
            jsonobject.add("amount", pContext.serialize((Object)this.amount));
            if (this.id != null) {
                jsonobject.addProperty("id", this.id.toString());
            }
            if (this.slots.length == 1) {
                jsonobject.addProperty("slot", this.slots[0].getName());
            } else {
                JsonArray jsonarray = new JsonArray();
                EquipmentSlot[] equipmentSlotArray = this.slots;
                int n = this.slots.length;
                int n2 = 0;
                while (n2 < n) {
                    EquipmentSlot equipmentslot = equipmentSlotArray[n2];
                    jsonarray.add((JsonElement)new JsonPrimitive(equipmentslot.getName()));
                    ++n2;
                }
                jsonobject.add("slot", (JsonElement)jsonarray);
            }
            return jsonobject;
        }

        public static Modifier deserialize(JsonObject pJsonObj, JsonDeserializationContext pContext) {
            EquipmentSlot[] aequipmentslot;
            String s = GsonHelper.getAsString(pJsonObj, "name");
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(pJsonObj, "attribute"));
            Attribute attribute = Registry.ATTRIBUTE.get(resourcelocation);
            if (attribute == null) {
                throw new JsonSyntaxException("Unknown attribute: " + resourcelocation);
            }
            AttributeModifier.Operation attributemodifier$operation = Modifier.operationFromString(GsonHelper.getAsString(pJsonObj, "operation"));
            NumberProvider numberprovider = GsonHelper.getAsObject(pJsonObj, "amount", pContext, NumberProvider.class);
            UUID uuid = null;
            if (GsonHelper.isStringValue(pJsonObj, "slot")) {
                aequipmentslot = new EquipmentSlot[]{EquipmentSlot.byName(GsonHelper.getAsString(pJsonObj, "slot"))};
            } else {
                if (!GsonHelper.isArrayNode(pJsonObj, "slot")) {
                    throw new JsonSyntaxException("Invalid or missing attribute modifier slot; must be either string or array of strings.");
                }
                JsonArray jsonarray = GsonHelper.getAsJsonArray(pJsonObj, "slot");
                aequipmentslot = new EquipmentSlot[jsonarray.size()];
                int i = 0;
                for (JsonElement jsonelement : jsonarray) {
                    aequipmentslot[i++] = EquipmentSlot.byName(GsonHelper.convertToString(jsonelement, "slot"));
                }
                if (aequipmentslot.length == 0) {
                    throw new JsonSyntaxException("Invalid attribute modifier slot; must contain at least one entry.");
                }
            }
            if (pJsonObj.has("id")) {
                String s1 = GsonHelper.getAsString(pJsonObj, "id");
                try {
                    uuid = UUID.fromString(s1);
                }
                catch (IllegalArgumentException illegalargumentexception) {
                    throw new JsonSyntaxException("Invalid attribute modifier id '" + s1 + "' (must be UUID format, with dashes)");
                }
            }
            return new Modifier(s, attribute, attributemodifier$operation, numberprovider, aequipmentslot, uuid);
        }

        private static String operationToString(AttributeModifier.Operation pOperation) {
            switch (pOperation) {
                case ADDITION: {
                    return "addition";
                }
                case MULTIPLY_BASE: {
                    return "multiply_base";
                }
                case MULTIPLY_TOTAL: {
                    return "multiply_total";
                }
            }
            throw new IllegalArgumentException("Unknown operation " + (Object)((Object)pOperation));
        }

        private static AttributeModifier.Operation operationFromString(String pName) {
            switch (pName) {
                case "addition": {
                    return AttributeModifier.Operation.ADDITION;
                }
                case "multiply_base": {
                    return AttributeModifier.Operation.MULTIPLY_BASE;
                }
                case "multiply_total": {
                    return AttributeModifier.Operation.MULTIPLY_TOTAL;
                }
            }
            throw new JsonSyntaxException("Unknown attribute modifier operation " + pName);
        }
    }

    public static class ModifierBuilder {
        private final String name;
        private final Attribute attribute;
        private final AttributeModifier.Operation operation;
        private final NumberProvider amount;
        @Nullable
        private UUID id;
        private final Set<EquipmentSlot> slots = EnumSet.noneOf(EquipmentSlot.class);

        public ModifierBuilder(String pName, Attribute pAttribute, AttributeModifier.Operation pOperation, NumberProvider pAmount) {
            this.name = pName;
            this.attribute = pAttribute;
            this.operation = pOperation;
            this.amount = pAmount;
        }

        public ModifierBuilder forSlot(EquipmentSlot pSlot) {
            this.slots.add(pSlot);
            return this;
        }

        public ModifierBuilder withUuid(UUID pId) {
            this.id = pId;
            return this;
        }

        public Modifier build() {
            return new Modifier(this.name, this.attribute, this.operation, this.amount, this.slots.toArray(new EquipmentSlot[0]), this.id);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetAttributesFunction> {
        @Override
        public void serialize(JsonObject pJson, SetAttributesFunction pValue, JsonSerializationContext pSerializationContext) {
            super.serialize(pJson, pValue, pSerializationContext);
            JsonArray jsonarray = new JsonArray();
            for (Modifier setattributesfunction$modifier : pValue.modifiers) {
                jsonarray.add((JsonElement)setattributesfunction$modifier.serialize(pSerializationContext));
            }
            pJson.add("modifiers", (JsonElement)jsonarray);
        }

        @Override
        public SetAttributesFunction b(JsonObject p_80883_, JsonDeserializationContext p_80884_, LootItemCondition[] p_80885_) {
            JsonArray jsonarray = GsonHelper.getAsJsonArray(p_80883_, "modifiers");
            ArrayList list = Lists.newArrayListWithExpectedSize((int)jsonarray.size());
            for (JsonElement jsonelement : jsonarray) {
                list.add(Modifier.deserialize(GsonHelper.convertToJsonObject(jsonelement, "modifier"), p_80884_));
            }
            if (list.isEmpty()) {
                throw new JsonSyntaxException("Invalid attribute modifiers array; cannot be empty");
            }
            return new SetAttributesFunction(p_80885_, list);
        }
    }
}

