/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetLoreFunction
extends LootItemConditionalFunction {
    final boolean replace;
    final List<Component> lore;
    @Nullable
    final LootContext.EntityTarget resolutionContext;

    public SetLoreFunction(LootItemCondition[] pConditions, boolean pReplace, List<Component> pLore, @Nullable LootContext.EntityTarget pResolutionContext) {
        super(pConditions);
        this.replace = pReplace;
        this.lore = ImmutableList.copyOf(pLore);
        this.resolutionContext = pResolutionContext;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_LORE;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.resolutionContext != null ? ImmutableSet.of(this.resolutionContext.getParam()) : ImmutableSet.of();
    }

    @Override
    public ItemStack run(ItemStack pStack, LootContext pContext) {
        ListTag listtag = this.getLoreTag(pStack, !this.lore.isEmpty());
        if (listtag != null) {
            if (this.replace) {
                listtag.clear();
            }
            UnaryOperator<Component> unaryoperator = SetNameFunction.createResolver(pContext, this.resolutionContext);
            this.lore.stream().map(unaryoperator).map(Component.Serializer::toJson).map(StringTag::valueOf).forEach(listtag::add);
        }
        return pStack;
    }

    @Nullable
    private ListTag getLoreTag(ItemStack pStack, boolean pCreateIfMissing) {
        CompoundTag compoundtag1;
        CompoundTag compoundtag;
        if (pStack.hasTag()) {
            compoundtag = pStack.getTag();
        } else {
            if (!pCreateIfMissing) {
                return null;
            }
            compoundtag = new CompoundTag();
            pStack.setTag(compoundtag);
        }
        if (compoundtag.contains("display", 10)) {
            compoundtag1 = compoundtag.getCompound("display");
        } else {
            if (!pCreateIfMissing) {
                return null;
            }
            compoundtag1 = new CompoundTag();
            compoundtag.put("display", compoundtag1);
        }
        if (compoundtag1.contains("Lore", 9)) {
            return compoundtag1.getList("Lore", 8);
        }
        if (pCreateIfMissing) {
            ListTag listtag = new ListTag();
            compoundtag1.put("Lore", listtag);
            return listtag;
        }
        return null;
    }

    public static Builder setLore() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private boolean replace;
        private LootContext.EntityTarget resolutionContext;
        private final List<Component> lore = Lists.newArrayList();

        public Builder setReplace(boolean pReplace) {
            this.replace = pReplace;
            return this;
        }

        public Builder setResolutionContext(LootContext.EntityTarget pResolutionContext) {
            this.resolutionContext = pResolutionContext;
            return this;
        }

        public Builder addLine(Component pLine) {
            this.lore.add(pLine);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetLoreFunction(this.getConditions(), this.replace, this.lore, this.resolutionContext);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetLoreFunction> {
        @Override
        public void serialize(JsonObject pJson, SetLoreFunction pValue, JsonSerializationContext pSerializationContext) {
            super.serialize(pJson, pValue, pSerializationContext);
            pJson.addProperty("replace", Boolean.valueOf(pValue.replace));
            JsonArray jsonarray = new JsonArray();
            for (Component component : pValue.lore) {
                jsonarray.add(Component.Serializer.toJsonTree(component));
            }
            pJson.add("lore", (JsonElement)jsonarray);
            if (pValue.resolutionContext != null) {
                pJson.add("entity", pSerializationContext.serialize((Object)pValue.resolutionContext));
            }
        }

        @Override
        public SetLoreFunction b(JsonObject p_81103_, JsonDeserializationContext p_81104_, LootItemCondition[] p_81105_) {
            boolean flag = GsonHelper.getAsBoolean(p_81103_, "replace", false);
            List list = (List)Streams.stream((Iterable)GsonHelper.getAsJsonArray(p_81103_, "lore")).map(Component.Serializer::fromJson).collect(ImmutableList.toImmutableList());
            LootContext.EntityTarget lootcontext$entitytarget = GsonHelper.getAsObject(p_81103_, "entity", null, p_81104_, LootContext.EntityTarget.class);
            return new SetLoreFunction(p_81105_, flag, list, lootcontext$entitytarget);
        }
    }
}

