/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.parameters;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;

public class LootContextParamSet {
    private final Set<LootContextParam<?>> required;
    private final Set<LootContextParam<?>> all;

    LootContextParamSet(Set<LootContextParam<?>> pRequired, Set<LootContextParam<?>> pOptional) {
        this.required = ImmutableSet.copyOf(pRequired);
        this.all = ImmutableSet.copyOf((Collection)Sets.union(pRequired, pOptional));
    }

    public boolean isAllowed(LootContextParam<?> pParam) {
        return this.all.contains(pParam);
    }

    public Set<LootContextParam<?>> getRequired() {
        return this.required;
    }

    public Set<LootContextParam<?>> getAllowed() {
        return this.all;
    }

    public String toString() {
        return "[" + Joiner.on((String)", ").join(this.all.stream().map(p_81400_ -> String.valueOf(this.required.contains(p_81400_) ? "!" : "") + p_81400_.getName()).iterator()) + "]";
    }

    public void validateUser(ValidationContext pValidationContext, LootContextUser pLootContextUser) {
        Set<LootContextParam<?>> set = pLootContextUser.getReferencedContextParams();
        Sets.SetView set1 = Sets.difference(set, this.all);
        if (!set1.isEmpty()) {
            pValidationContext.reportProblem("Parameters " + set1 + " are not provided in this context");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<LootContextParam<?>> required = Sets.newIdentityHashSet();
        private final Set<LootContextParam<?>> optional = Sets.newIdentityHashSet();

        public Builder required(LootContextParam<?> pParameter) {
            if (this.optional.contains(pParameter)) {
                throw new IllegalArgumentException("Parameter " + pParameter.getName() + " is already optional");
            }
            this.required.add(pParameter);
            return this;
        }

        public Builder optional(LootContextParam<?> pParameter) {
            if (this.required.contains(pParameter)) {
                throw new IllegalArgumentException("Parameter " + pParameter.getName() + " is already required");
            }
            this.optional.add(pParameter);
            return this;
        }

        public LootContextParamSet build() {
            return new LootContextParamSet(this.required, this.optional);
        }
    }
}

