/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.parameters;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LootContextParamSets {
    private static final BiMap<ResourceLocation, LootContextParamSet> REGISTRY = HashBiMap.create();
    public static final LootContextParamSet EMPTY = LootContextParamSets.register("empty", p_81454_ -> {});
    public static final LootContextParamSet CHEST = LootContextParamSets.register("chest", p_81452_ -> p_81452_.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet COMMAND = LootContextParamSets.register("command", p_81450_ -> p_81450_.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet SELECTOR = LootContextParamSets.register("selector", p_81448_ -> p_81448_.required(LootContextParams.ORIGIN).required(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet FISHING = LootContextParamSets.register("fishing", p_81446_ -> p_81446_.required(LootContextParams.ORIGIN).required(LootContextParams.TOOL).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet ENTITY = LootContextParamSets.register("entity", p_81444_ -> p_81444_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.DAMAGE_SOURCE).optional(LootContextParams.KILLER_ENTITY).optional(LootContextParams.DIRECT_KILLER_ENTITY).optional(LootContextParams.LAST_DAMAGE_PLAYER));
    public static final LootContextParamSet GIFT = LootContextParamSets.register("gift", p_81442_ -> p_81442_.required(LootContextParams.ORIGIN).required(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet PIGLIN_BARTER = LootContextParamSets.register("barter", p_81440_ -> p_81440_.required(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet ADVANCEMENT_REWARD = LootContextParamSets.register("advancement_reward", p_81438_ -> p_81438_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN));
    public static final LootContextParamSet ADVANCEMENT_ENTITY = LootContextParamSets.register("advancement_entity", p_81436_ -> p_81436_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN));
    public static final LootContextParamSet ALL_PARAMS = LootContextParamSets.register("generic", p_81434_ -> p_81434_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.LAST_DAMAGE_PLAYER).required(LootContextParams.DAMAGE_SOURCE).required(LootContextParams.KILLER_ENTITY).required(LootContextParams.DIRECT_KILLER_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.BLOCK_STATE).required(LootContextParams.BLOCK_ENTITY).required(LootContextParams.TOOL).required(LootContextParams.EXPLOSION_RADIUS));
    public static final LootContextParamSet BLOCK = LootContextParamSets.register("block", p_81425_ -> p_81425_.required(LootContextParams.BLOCK_STATE).required(LootContextParams.ORIGIN).required(LootContextParams.TOOL).optional(LootContextParams.THIS_ENTITY).optional(LootContextParams.BLOCK_ENTITY).optional(LootContextParams.EXPLOSION_RADIUS));

    private static LootContextParamSet register(String pRegistryName, Consumer<LootContextParamSet.Builder> pBuilderConsumer) {
        LootContextParamSet.Builder lootcontextparamset$builder = new LootContextParamSet.Builder();
        pBuilderConsumer.accept(lootcontextparamset$builder);
        LootContextParamSet lootcontextparamset = lootcontextparamset$builder.build();
        ResourceLocation resourcelocation = new ResourceLocation(pRegistryName);
        LootContextParamSet lootcontextparamset1 = (LootContextParamSet)REGISTRY.put((Object)resourcelocation, (Object)lootcontextparamset);
        if (lootcontextparamset1 != null) {
            throw new IllegalStateException("Loot table parameter set " + resourcelocation + " is already registered");
        }
        return lootcontextparamset;
    }

    @Nullable
    public static LootContextParamSet get(ResourceLocation pRegistryName) {
        return (LootContextParamSet)REGISTRY.get((Object)pRegistryName);
    }

    @Nullable
    public static ResourceLocation getKey(LootContextParamSet pParameterSet) {
        return (ResourceLocation)REGISTRY.inverse().get((Object)pParameterSet);
    }
}

