/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class AlternativeLootItemCondition
implements LootItemCondition {
    final LootItemCondition[] terms;
    private final Predicate<LootContext> composedPredicate;

    AlternativeLootItemCondition(LootItemCondition[] pTerms) {
        this.terms = pTerms;
        this.composedPredicate = LootItemConditions.b(pTerms);
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.ALTERNATIVE;
    }

    @Override
    public final boolean test(LootContext p_81476_) {
        return this.composedPredicate.test(p_81476_);
    }

    @Override
    public void validate(ValidationContext pContext) {
        LootItemCondition.super.validate(pContext);
        int i = 0;
        while (i < this.terms.length) {
            this.terms[i].validate(pContext.forChild(".term[" + i + "]"));
            ++i;
        }
    }

    public static Builder a(LootItemCondition.Builder ... p_81482_) {
        return new Builder(p_81482_);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final List<LootItemCondition> terms = Lists.newArrayList();

        public Builder(LootItemCondition.Builder ... p_81488_) {
            LootItemCondition.Builder[] builderArray = p_81488_;
            int n = p_81488_.length;
            int n2 = 0;
            while (n2 < n) {
                LootItemCondition.Builder lootitemcondition$builder = builderArray[n2];
                this.terms.add(lootitemcondition$builder.build());
                ++n2;
            }
        }

        @Override
        public Builder or(LootItemCondition.Builder pBuilder) {
            this.terms.add(pBuilder.build());
            return this;
        }

        @Override
        public LootItemCondition build() {
            return new AlternativeLootItemCondition(this.terms.toArray(new LootItemCondition[0]));
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<AlternativeLootItemCondition> {
        @Override
        public void serialize(JsonObject p_81497_, AlternativeLootItemCondition p_81498_, JsonSerializationContext p_81499_) {
            p_81497_.add("terms", p_81499_.serialize((Object)p_81498_.terms));
        }

        @Override
        public AlternativeLootItemCondition deserialize(JsonObject p_81505_, JsonDeserializationContext p_81506_) {
            LootItemCondition[] alootitemcondition = GsonHelper.getAsObject(p_81505_, "terms", p_81506_, LootItemCondition[].class);
            return new AlternativeLootItemCondition(alootitemcondition);
        }
    }
}

