/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;

public class EntityHasScoreCondition
implements LootItemCondition {
    final Map<String, IntRange> scores;
    final LootContext.EntityTarget entityTarget;

    EntityHasScoreCondition(Map<String, IntRange> pScoreRanges, LootContext.EntityTarget pEntityTarget) {
        this.scores = ImmutableMap.copyOf(pScoreRanges);
        this.entityTarget = pEntityTarget;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.ENTITY_SCORES;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return (Set)Stream.concat(Stream.of(this.entityTarget.getParam()), this.scores.values().stream().flatMap(p_165487_ -> p_165487_.getReferencedContextParams().stream())).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public boolean test(LootContext p_81631_) {
        Entity entity = p_81631_.getParamOrNull(this.entityTarget.getParam());
        if (entity == null) {
            return false;
        }
        Scoreboard scoreboard = entity.level.getScoreboard();
        for (Map.Entry<String, IntRange> entry : this.scores.entrySet()) {
            if (this.hasScore(p_81631_, entity, scoreboard, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean hasScore(LootContext pLootContext, Entity pTargetEntity, Scoreboard pScoreboard, String pObjectiveName, IntRange pScoreRange) {
        Objective objective = pScoreboard.getObjective(pObjectiveName);
        if (objective == null) {
            return false;
        }
        String s = pTargetEntity.getScoreboardName();
        return !pScoreboard.hasPlayerScore(s, objective) ? false : pScoreRange.test(pLootContext, pScoreboard.getOrCreatePlayerScore(s, objective).getScore());
    }

    public static Builder hasScores(LootContext.EntityTarget pEntityTarget) {
        return new Builder(pEntityTarget);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Map<String, IntRange> scores = Maps.newHashMap();
        private final LootContext.EntityTarget entityTarget;

        public Builder(LootContext.EntityTarget pEntityTarget) {
            this.entityTarget = pEntityTarget;
        }

        public Builder withScore(String pObjectiveName, IntRange pScoreRange) {
            this.scores.put(pObjectiveName, pScoreRange);
            return this;
        }

        @Override
        public LootItemCondition build() {
            return new EntityHasScoreCondition(this.scores, this.entityTarget);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<EntityHasScoreCondition> {
        @Override
        public void serialize(JsonObject p_81644_, EntityHasScoreCondition p_81645_, JsonSerializationContext p_81646_) {
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<String, IntRange> entry : p_81645_.scores.entrySet()) {
                jsonobject.add(entry.getKey(), p_81646_.serialize((Object)entry.getValue()));
            }
            p_81644_.add("scores", (JsonElement)jsonobject);
            p_81644_.add("entity", p_81646_.serialize((Object)p_81645_.entityTarget));
        }

        @Override
        public EntityHasScoreCondition deserialize(JsonObject p_81652_, JsonDeserializationContext p_81653_) {
            Set set = GsonHelper.getAsJsonObject(p_81652_, "scores").entrySet();
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (Map.Entry entry : set) {
                map.put((String)entry.getKey(), GsonHelper.convertToObject((JsonElement)entry.getValue(), "score", p_81653_, IntRange.class));
            }
            return new EntityHasScoreCondition(map, GsonHelper.getAsObject(p_81652_, "entity", p_81653_, LootContext.EntityTarget.class));
        }
    }
}

