/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemRandomChanceCondition
implements LootItemCondition {
    final float probability;

    LootItemRandomChanceCondition(float pProbability) {
        this.probability = pProbability;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.RANDOM_CHANCE;
    }

    @Override
    public boolean test(LootContext p_81930_) {
        return p_81930_.getRandom().nextFloat() < this.probability;
    }

    public static LootItemCondition.Builder randomChance(float pProbability) {
        return () -> new LootItemRandomChanceCondition(pProbability);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LootItemRandomChanceCondition> {
        @Override
        public void serialize(JsonObject p_81943_, LootItemRandomChanceCondition p_81944_, JsonSerializationContext p_81945_) {
            p_81943_.addProperty("chance", (Number)Float.valueOf(p_81944_.probability));
        }

        @Override
        public LootItemRandomChanceCondition deserialize(JsonObject p_81951_, JsonDeserializationContext p_81952_) {
            return new LootItemRandomChanceCondition(GsonHelper.getAsFloat(p_81951_, "chance"));
        }
    }
}

