/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemRandomChanceWithLootingCondition
implements LootItemCondition {
    final float percent;
    final float lootingMultiplier;

    LootItemRandomChanceWithLootingCondition(float pPercent, float pLootingMultiplier) {
        this.percent = pPercent;
        this.lootingMultiplier = pLootingMultiplier;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.RANDOM_CHANCE_WITH_LOOTING;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParams.KILLER_ENTITY);
    }

    @Override
    public boolean test(LootContext p_81967_) {
        Entity entity = p_81967_.getParamOrNull(LootContextParams.KILLER_ENTITY);
        int i = 0;
        if (entity instanceof LivingEntity) {
            i = EnchantmentHelper.getMobLooting((LivingEntity)entity);
        }
        return p_81967_.getRandom().nextFloat() < this.percent + (float)i * this.lootingMultiplier;
    }

    public static LootItemCondition.Builder randomChanceAndLootingBoost(float pChance, float pLootingMultiplier) {
        return () -> new LootItemRandomChanceWithLootingCondition(pChance, pLootingMultiplier);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LootItemRandomChanceWithLootingCondition> {
        @Override
        public void serialize(JsonObject p_81983_, LootItemRandomChanceWithLootingCondition p_81984_, JsonSerializationContext p_81985_) {
            p_81983_.addProperty("chance", (Number)Float.valueOf(p_81984_.percent));
            p_81983_.addProperty("looting_multiplier", (Number)Float.valueOf(p_81984_.lootingMultiplier));
        }

        @Override
        public LootItemRandomChanceWithLootingCondition deserialize(JsonObject p_81991_, JsonDeserializationContext p_81992_) {
            return new LootItemRandomChanceWithLootingCondition(GsonHelper.getAsFloat(p_81991_, "chance"), GsonHelper.getAsFloat(p_81991_, "looting_multiplier"));
        }
    }
}

