/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class MatchTool
implements LootItemCondition {
    final ItemPredicate predicate;

    public MatchTool(ItemPredicate pToolPredicate) {
        this.predicate = pToolPredicate;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.MATCH_TOOL;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParams.TOOL);
    }

    @Override
    public boolean test(LootContext p_82000_) {
        ItemStack itemstack = p_82000_.getParamOrNull(LootContextParams.TOOL);
        return itemstack != null && this.predicate.matches(itemstack);
    }

    public static LootItemCondition.Builder toolMatches(ItemPredicate.Builder pToolPredicateBuilder) {
        return () -> new MatchTool(pToolPredicateBuilder.build());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<MatchTool> {
        @Override
        public void serialize(JsonObject p_82013_, MatchTool p_82014_, JsonSerializationContext p_82015_) {
            p_82013_.add("predicate", p_82014_.predicate.serializeToJson());
        }

        @Override
        public MatchTool deserialize(JsonObject p_82021_, JsonDeserializationContext p_82022_) {
            ItemPredicate itempredicate = ItemPredicate.fromJson(p_82021_.get("predicate"));
            return new MatchTool(itempredicate);
        }
    }
}

