/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class TimeCheck
implements LootItemCondition {
    @Nullable
    final Long period;
    final IntRange value;

    TimeCheck(@Nullable Long pPeriod, IntRange pRange) {
        this.period = pPeriod;
        this.value = pRange;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.TIME_CHECK;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.value.getReferencedContextParams();
    }

    @Override
    public boolean test(LootContext p_82033_) {
        ServerLevel serverlevel = p_82033_.getLevel();
        long i = serverlevel.getDayTime();
        if (this.period != null) {
            i %= this.period.longValue();
        }
        return this.value.test(p_82033_, (int)i);
    }

    public static Builder time(IntRange pTimeRange) {
        return new Builder(pTimeRange);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        @Nullable
        private Long period;
        private final IntRange value;

        public Builder(IntRange pTimeRange) {
            this.value = pTimeRange;
        }

        public Builder setPeriod(long pPeriod) {
            this.period = pPeriod;
            return this;
        }

        @Override
        public TimeCheck build() {
            return new TimeCheck(this.period, this.value);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<TimeCheck> {
        @Override
        public void serialize(JsonObject p_82046_, TimeCheck p_82047_, JsonSerializationContext p_82048_) {
            p_82046_.addProperty("period", (Number)p_82047_.period);
            p_82046_.add("value", p_82048_.serialize((Object)p_82047_.value));
        }

        @Override
        public TimeCheck deserialize(JsonObject p_82054_, JsonDeserializationContext p_82055_) {
            Long olong = p_82054_.has("period") ? Long.valueOf(GsonHelper.getAsLong(p_82054_, "period")) : null;
            IntRange intrange = GsonHelper.getAsObject(p_82054_, "value", p_82055_, IntRange.class);
            return new TimeCheck(olong, intrange);
        }
    }
}

