/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class WeatherCheck
implements LootItemCondition {
    @Nullable
    final Boolean isRaining;
    @Nullable
    final Boolean isThundering;

    WeatherCheck(@Nullable Boolean pIsRaining, @Nullable Boolean pIsThundering) {
        this.isRaining = pIsRaining;
        this.isThundering = pIsThundering;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.WEATHER_CHECK;
    }

    @Override
    public boolean test(LootContext p_82066_) {
        ServerLevel serverlevel = p_82066_.getLevel();
        if (this.isRaining != null && this.isRaining.booleanValue() != serverlevel.isRaining()) {
            return false;
        }
        return this.isThundering == null || this.isThundering.booleanValue() == serverlevel.isThundering();
    }

    public static Builder weather() {
        return new Builder();
    }

    public static class Builder
    implements LootItemCondition.Builder {
        @Nullable
        private Boolean isRaining;
        @Nullable
        private Boolean isThundering;

        public Builder setRaining(@Nullable Boolean pIsRaining) {
            this.isRaining = pIsRaining;
            return this;
        }

        public Builder setThundering(@Nullable Boolean pIsThundering) {
            this.isThundering = pIsThundering;
            return this;
        }

        @Override
        public WeatherCheck build() {
            return new WeatherCheck(this.isRaining, this.isThundering);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<WeatherCheck> {
        @Override
        public void serialize(JsonObject p_82079_, WeatherCheck p_82080_, JsonSerializationContext p_82081_) {
            p_82079_.addProperty("raining", p_82080_.isRaining);
            p_82079_.addProperty("thundering", p_82080_.isThundering);
        }

        @Override
        public WeatherCheck deserialize(JsonObject p_82087_, JsonDeserializationContext p_82088_) {
            Boolean obool = p_82087_.has("raining") ? Boolean.valueOf(GsonHelper.getAsBoolean(p_82087_, "raining")) : null;
            Boolean obool1 = p_82087_.has("thundering") ? Boolean.valueOf(GsonHelper.getAsBoolean(p_82087_, "thundering")) : null;
            return new WeatherCheck(obool, obool1);
        }
    }
}

