/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public final class BinomialDistributionGenerator
implements NumberProvider {
    final NumberProvider n;
    final NumberProvider p;

    BinomialDistributionGenerator(NumberProvider pN, NumberProvider pP) {
        this.n = pN;
        this.p = pP;
    }

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.BINOMIAL;
    }

    @Override
    public int getInt(LootContext pLootContext) {
        int i = this.n.getInt(pLootContext);
        float f = this.p.getFloat(pLootContext);
        Random random = pLootContext.getRandom();
        int j = 0;
        int k = 0;
        while (k < i) {
            if (random.nextFloat() < f) {
                ++j;
            }
            ++k;
        }
        return j;
    }

    @Override
    public float getFloat(LootContext pLootContext) {
        return this.getInt(pLootContext);
    }

    public static BinomialDistributionGenerator binomial(int pN, float pP) {
        return new BinomialDistributionGenerator(ConstantValue.exactly(pN), ConstantValue.exactly(pP));
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Sets.union(this.n.getReferencedContextParams(), this.p.getReferencedContextParams());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<BinomialDistributionGenerator> {
        @Override
        public BinomialDistributionGenerator deserialize(JsonObject p_165680_, JsonDeserializationContext p_165681_) {
            NumberProvider numberprovider = GsonHelper.getAsObject(p_165680_, "n", p_165681_, NumberProvider.class);
            NumberProvider numberprovider1 = GsonHelper.getAsObject(p_165680_, "p", p_165681_, NumberProvider.class);
            return new BinomialDistributionGenerator(numberprovider, numberprovider1);
        }

        @Override
        public void serialize(JsonObject p_165672_, BinomialDistributionGenerator p_165673_, JsonSerializationContext p_165674_) {
            p_165672_.add("n", p_165674_.serialize((Object)p_165673_.n));
            p_165672_.add("p", p_165674_.serialize((Object)p_165673_.p));
        }
    }
}

