/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.GsonAdapterFactory;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public final class ConstantValue
implements NumberProvider {
    final float value;

    ConstantValue(float pValue) {
        this.value = pValue;
    }

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.CONSTANT;
    }

    @Override
    public float getFloat(LootContext pLootContext) {
        return this.value;
    }

    public static ConstantValue exactly(float pValue) {
        return new ConstantValue(pValue);
    }

    public boolean equals(Object p_165697_) {
        if (this == p_165697_) {
            return true;
        }
        if (p_165697_ != null && this.getClass() == p_165697_.getClass()) {
            return Float.compare(((ConstantValue)p_165697_).value, this.value) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
    }

    public static class InlineSerializer
    implements GsonAdapterFactory.InlineSerializer<ConstantValue> {
        @Override
        public JsonElement serialize(ConstantValue p_165704_, JsonSerializationContext p_165705_) {
            return new JsonPrimitive((Number)Float.valueOf(p_165704_.value));
        }

        @Override
        public ConstantValue deserialize(JsonElement p_165710_, JsonDeserializationContext p_165711_) {
            return new ConstantValue(GsonHelper.convertToFloat(p_165710_, "value"));
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ConstantValue> {
        @Override
        public void serialize(JsonObject p_165717_, ConstantValue p_165718_, JsonSerializationContext p_165719_) {
            p_165717_.addProperty("value", (Number)Float.valueOf(p_165718_.value));
        }

        @Override
        public ConstantValue deserialize(JsonObject p_165725_, JsonDeserializationContext p_165726_) {
            float f = GsonHelper.getAsFloat(p_165725_, "value");
            return new ConstantValue(f);
        }
    }
}

