/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.ContextScoreboardNameProvider;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProvider;
import net.minecraft.world.scores.Objective;

public class ScoreboardValue
implements NumberProvider {
    final ScoreboardNameProvider target;
    final String score;
    final float scale;

    ScoreboardValue(ScoreboardNameProvider pTarget, String pScore, float pScale) {
        this.target = pTarget;
        this.score = pScore;
        this.scale = pScale;
    }

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.SCORE;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.target.getReferencedContextParams();
    }

    public static ScoreboardValue fromScoreboard(LootContext.EntityTarget pEntityTarget, String pScore) {
        return ScoreboardValue.fromScoreboard(pEntityTarget, pScore, 1.0f);
    }

    public static ScoreboardValue fromScoreboard(LootContext.EntityTarget pEntityTarget, String pScore, float pScale) {
        return new ScoreboardValue(ContextScoreboardNameProvider.forTarget(pEntityTarget), pScore, pScale);
    }

    @Override
    public float getFloat(LootContext pLootContext) {
        String s = this.target.getScoreboardName(pLootContext);
        if (s == null) {
            return 0.0f;
        }
        ServerScoreboard scoreboard = pLootContext.getLevel().getScoreboard();
        Objective objective = scoreboard.getObjective(this.score);
        if (objective == null) {
            return 0.0f;
        }
        return !scoreboard.hasPlayerScore(s, objective) ? 0.0f : (float)scoreboard.getOrCreatePlayerScore(s, objective).getScore() * this.scale;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ScoreboardValue> {
        @Override
        public ScoreboardValue deserialize(JsonObject p_165772_, JsonDeserializationContext p_165773_) {
            String s = GsonHelper.getAsString(p_165772_, "score");
            float f = GsonHelper.getAsFloat(p_165772_, "scale", 1.0f);
            ScoreboardNameProvider scoreboardnameprovider = GsonHelper.getAsObject(p_165772_, "target", p_165773_, ScoreboardNameProvider.class);
            return new ScoreboardValue(scoreboardnameprovider, s, f);
        }

        @Override
        public void serialize(JsonObject p_165764_, ScoreboardValue p_165765_, JsonSerializationContext p_165766_) {
            p_165764_.addProperty("score", p_165765_.score);
            p_165764_.add("target", p_165766_.serialize((Object)p_165765_.target));
            p_165764_.addProperty("scale", (Number)Float.valueOf(p_165765_.scale));
        }
    }
}

