/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.IndexMerger;
import net.minecraft.world.phys.shapes.Shapes;

public final class DiscreteCubeMerger
implements IndexMerger {
    private final CubePointRange result;
    private final int firstDiv;
    private final int secondDiv;

    DiscreteCubeMerger(int pAa, int pBb) {
        this.result = new CubePointRange((int)Shapes.lcm(pAa, pBb));
        int i = IntMath.gcd((int)pAa, (int)pBb);
        this.firstDiv = pAa / i;
        this.secondDiv = pBb / i;
    }

    @Override
    public boolean forMergedIndexes(IndexMerger.IndexConsumer pConsumer) {
        int i = this.result.size() - 1;
        int j = 0;
        while (j < i) {
            if (!pConsumer.merge(j / this.secondDiv, j / this.firstDiv, j)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    @Override
    public int size() {
        return this.result.size();
    }

    @Override
    public DoubleList getList() {
        return this.result;
    }
}

