/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.world.phys.shapes.IndexMerger;

public class NonOverlappingMerger
extends AbstractDoubleList
implements IndexMerger {
    private final DoubleList lower;
    private final DoubleList upper;
    private final boolean swap;

    protected NonOverlappingMerger(DoubleList pLower, DoubleList pUpper, boolean pSwap) {
        this.lower = pLower;
        this.upper = pUpper;
        this.swap = pSwap;
    }

    @Override
    public int size() {
        return this.lower.size() + this.upper.size();
    }

    @Override
    public boolean forMergedIndexes(IndexMerger.IndexConsumer pConsumer) {
        return this.swap ? this.forNonSwappedIndexes((p_83020_, p_83021_, p_83022_) -> pConsumer.merge(p_83021_, p_83020_, p_83022_)) : this.forNonSwappedIndexes(pConsumer);
    }

    private boolean forNonSwappedIndexes(IndexMerger.IndexConsumer pConsumer) {
        int i = this.lower.size();
        int j = 0;
        while (j < i) {
            if (!pConsumer.merge(j, -1, j)) {
                return false;
            }
            ++j;
        }
        int l = this.upper.size() - 1;
        int k = 0;
        while (k < l) {
            if (!pConsumer.merge(i - 1, k, i + k)) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public double getDouble(int pIndex) {
        return pIndex < this.lower.size() ? this.lower.getDouble(pIndex) : this.upper.getDouble(pIndex - this.lower.size());
    }

    @Override
    public DoubleList getList() {
        return this;
    }
}

