/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class ScoreboardSaveData
extends SavedData {
    public static final String FILE_ID = "scoreboard";
    private final Scoreboard scoreboard;

    public ScoreboardSaveData(Scoreboard p_166101_) {
        this.scoreboard = p_166101_;
    }

    public ScoreboardSaveData load(CompoundTag p_166103_) {
        this.loadObjectives(p_166103_.getList("Objectives", 10));
        this.scoreboard.loadPlayerScores(p_166103_.getList("PlayerScores", 10));
        if (p_166103_.contains("DisplaySlots", 10)) {
            this.loadDisplaySlots(p_166103_.getCompound("DisplaySlots"));
        }
        if (p_166103_.contains("Teams", 9)) {
            this.loadTeams(p_166103_.getList("Teams", 10));
        }
        return this;
    }

    private void loadTeams(ListTag pTagList) {
        int i = 0;
        while (i < pTagList.size()) {
            Team.CollisionRule team$collisionrule;
            Team.Visibility team$visibility1;
            Team.Visibility team$visibility;
            MutableComponent component2;
            MutableComponent component1;
            CompoundTag compoundtag = pTagList.getCompound(i);
            String s = compoundtag.getString("Name");
            PlayerTeam playerteam = this.scoreboard.addPlayerTeam(s);
            MutableComponent component = Component.Serializer.fromJson(compoundtag.getString("DisplayName"));
            if (component != null) {
                playerteam.setDisplayName(component);
            }
            if (compoundtag.contains("TeamColor", 8)) {
                playerteam.setColor(ChatFormatting.getByName(compoundtag.getString("TeamColor")));
            }
            if (compoundtag.contains("AllowFriendlyFire", 99)) {
                playerteam.setAllowFriendlyFire(compoundtag.getBoolean("AllowFriendlyFire"));
            }
            if (compoundtag.contains("SeeFriendlyInvisibles", 99)) {
                playerteam.setSeeFriendlyInvisibles(compoundtag.getBoolean("SeeFriendlyInvisibles"));
            }
            if (compoundtag.contains("MemberNamePrefix", 8) && (component1 = Component.Serializer.fromJson(compoundtag.getString("MemberNamePrefix"))) != null) {
                playerteam.setPlayerPrefix(component1);
            }
            if (compoundtag.contains("MemberNameSuffix", 8) && (component2 = Component.Serializer.fromJson(compoundtag.getString("MemberNameSuffix"))) != null) {
                playerteam.setPlayerSuffix(component2);
            }
            if (compoundtag.contains("NameTagVisibility", 8) && (team$visibility = Team.Visibility.byName(compoundtag.getString("NameTagVisibility"))) != null) {
                playerteam.setNameTagVisibility(team$visibility);
            }
            if (compoundtag.contains("DeathMessageVisibility", 8) && (team$visibility1 = Team.Visibility.byName(compoundtag.getString("DeathMessageVisibility"))) != null) {
                playerteam.setDeathMessageVisibility(team$visibility1);
            }
            if (compoundtag.contains("CollisionRule", 8) && (team$collisionrule = Team.CollisionRule.byName(compoundtag.getString("CollisionRule"))) != null) {
                playerteam.setCollisionRule(team$collisionrule);
            }
            this.loadTeamPlayers(playerteam, compoundtag.getList("Players", 8));
            ++i;
        }
    }

    private void loadTeamPlayers(PlayerTeam pPlayerTeam, ListTag pTagList) {
        int i = 0;
        while (i < pTagList.size()) {
            this.scoreboard.addPlayerToTeam(pTagList.getString(i), pPlayerTeam);
            ++i;
        }
    }

    private void loadDisplaySlots(CompoundTag pCompound) {
        int i = 0;
        while (i < 19) {
            if (pCompound.contains("slot_" + i, 8)) {
                String s = pCompound.getString("slot_" + i);
                Objective objective = this.scoreboard.getObjective(s);
                this.scoreboard.setDisplayObjective(i, objective);
            }
            ++i;
        }
    }

    private void loadObjectives(ListTag pNbt) {
        int i = 0;
        while (i < pNbt.size()) {
            CompoundTag compoundtag = pNbt.getCompound(i);
            ObjectiveCriteria.byName(compoundtag.getString("CriteriaName")).ifPresent(p_83523_ -> {
                String s = compoundtag.getString("Name");
                MutableComponent component = Component.Serializer.fromJson(compoundtag.getString("DisplayName"));
                ObjectiveCriteria.RenderType objectivecriteria$rendertype = ObjectiveCriteria.RenderType.byId(compoundtag.getString("RenderType"));
                this.scoreboard.addObjective(s, (ObjectiveCriteria)p_83523_, component, objectivecriteria$rendertype);
            });
            ++i;
        }
    }

    @Override
    public CompoundTag save(CompoundTag pCompound) {
        pCompound.put("Objectives", this.saveObjectives());
        pCompound.put("PlayerScores", this.scoreboard.savePlayerScores());
        pCompound.put("Teams", this.saveTeams());
        this.saveDisplaySlots(pCompound);
        return pCompound;
    }

    private ListTag saveTeams() {
        ListTag listtag = new ListTag();
        for (PlayerTeam playerteam : this.scoreboard.getPlayerTeams()) {
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putString("Name", playerteam.getName());
            compoundtag.putString("DisplayName", Component.Serializer.toJson(playerteam.getDisplayName()));
            if (playerteam.getColor().getId() >= 0) {
                compoundtag.putString("TeamColor", playerteam.getColor().getName());
            }
            compoundtag.putBoolean("AllowFriendlyFire", playerteam.isAllowFriendlyFire());
            compoundtag.putBoolean("SeeFriendlyInvisibles", playerteam.canSeeFriendlyInvisibles());
            compoundtag.putString("MemberNamePrefix", Component.Serializer.toJson(playerteam.getPlayerPrefix()));
            compoundtag.putString("MemberNameSuffix", Component.Serializer.toJson(playerteam.getPlayerSuffix()));
            compoundtag.putString("NameTagVisibility", playerteam.getNameTagVisibility().name);
            compoundtag.putString("DeathMessageVisibility", playerteam.getDeathMessageVisibility().name);
            compoundtag.putString("CollisionRule", playerteam.getCollisionRule().name);
            ListTag listtag1 = new ListTag();
            for (String s : playerteam.getPlayers()) {
                listtag1.add(StringTag.valueOf(s));
            }
            compoundtag.put("Players", listtag1);
            listtag.add(compoundtag);
        }
        return listtag;
    }

    private void saveDisplaySlots(CompoundTag pCompound) {
        CompoundTag compoundtag = new CompoundTag();
        boolean flag = false;
        int i = 0;
        while (i < 19) {
            Objective objective = this.scoreboard.getDisplayObjective(i);
            if (objective != null) {
                compoundtag.putString("slot_" + i, objective.getName());
                flag = true;
            }
            ++i;
        }
        if (flag) {
            pCompound.put("DisplaySlots", compoundtag);
        }
    }

    private ListTag saveObjectives() {
        ListTag listtag = new ListTag();
        for (Objective objective : this.scoreboard.getObjectives()) {
            if (objective.getCriteria() == null) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putString("Name", objective.getName());
            compoundtag.putString("CriteriaName", objective.getCriteria().getName());
            compoundtag.putString("DisplayName", Component.Serializer.toJson(objective.getDisplayName()));
            compoundtag.putString("RenderType", objective.getRenderType().getId());
            listtag.add(compoundtag);
        }
        return listtag;
    }
}

