/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;

public abstract class Team {
    public boolean isAlliedTo(@Nullable Team pOther) {
        if (pOther == null) {
            return false;
        }
        return this == pOther;
    }

    public abstract String getName();

    public abstract MutableComponent getFormattedName(Component var1);

    public abstract boolean canSeeFriendlyInvisibles();

    public abstract boolean isAllowFriendlyFire();

    public abstract Visibility getNameTagVisibility();

    public abstract ChatFormatting getColor();

    public abstract Collection<String> getPlayers();

    public abstract Visibility getDeathMessageVisibility();

    public abstract CollisionRule getCollisionRule();

    public static enum CollisionRule {
        ALWAYS("always", 0),
        NEVER("never", 1),
        PUSH_OTHER_TEAMS("pushOtherTeams", 2),
        PUSH_OWN_TEAM("pushOwnTeam", 3);

        private static final Map<String, CollisionRule> BY_NAME;
        public final String name;
        public final int id;

        static {
            BY_NAME = Arrays.stream(CollisionRule.values()).collect(Collectors.toMap(p_83559_ -> p_83559_.name, p_83554_ -> p_83554_));
        }

        @Nullable
        public static CollisionRule byName(String pName) {
            return BY_NAME.get(pName);
        }

        private CollisionRule(String p_83551_, int p_83552_) {
            this.name = p_83551_;
            this.id = p_83552_;
        }

        public Component getDisplayName() {
            return new TranslatableComponent("team.collision." + this.name);
        }
    }

    public static enum Visibility {
        ALWAYS("always", 0),
        NEVER("never", 1),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams", 2),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam", 3);

        private static final Map<String, Visibility> BY_NAME;
        public final String name;
        public final int id;

        static {
            BY_NAME = Arrays.stream(Visibility.values()).collect(Collectors.toMap(p_83583_ -> p_83583_.name, p_83578_ -> p_83578_));
        }

        public static String[] getAllNames() {
            return BY_NAME.keySet().toArray(new String[0]);
        }

        @Nullable
        public static Visibility byName(String pName) {
            return BY_NAME.get(pName);
        }

        private Visibility(String p_83575_, int p_83576_) {
            this.name = p_83575_;
            this.id = p_83576_;
        }

        public Component getDisplayName() {
            return new TranslatableComponent("team.visibility." + this.name);
        }
    }
}

