/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.Config;
import net.optifine.model.BlockModelUtils;
import net.optifine.util.PropertiesOrdered;

public class BetterGrass {
    private static boolean betterGrass = true;
    private static boolean betterDirtPath = true;
    private static boolean betterMycelium = true;
    private static boolean betterPodzol = true;
    private static boolean betterCrimsonNylium = true;
    private static boolean betterWarpedNylium = true;
    private static boolean betterGrassSnow = true;
    private static boolean betterMyceliumSnow = true;
    private static boolean betterPodzolSnow = true;
    private static boolean grassMultilayer = false;
    private static TextureAtlasSprite spriteGrass = null;
    private static TextureAtlasSprite spriteGrassSide = null;
    private static TextureAtlasSprite spriteDirtPath = null;
    private static TextureAtlasSprite spriteDirtPathSide = null;
    private static TextureAtlasSprite spriteMycelium = null;
    private static TextureAtlasSprite spritePodzol = null;
    private static TextureAtlasSprite spriteCrimsonNylium = null;
    private static TextureAtlasSprite spriteWarpedNylium = null;
    private static TextureAtlasSprite spriteSnow = null;
    private static boolean spritesLoaded = false;
    private static BakedModel modelCubeGrass = null;
    private static BakedModel modelDirtPath = null;
    private static BakedModel modelCubeDirtPath = null;
    private static BakedModel modelCubeMycelium = null;
    private static BakedModel modelCubePodzol = null;
    private static BakedModel modelCubeCrimsonNylium = null;
    private static BakedModel modelCubeWarpedNylium = null;
    private static BakedModel modelCubeSnow = null;
    private static boolean modelsLoaded = false;
    private static final String TEXTURE_GRASS_DEFAULT = "block/grass_block_top";
    private static final String TEXTURE_GRASS_SIDE_DEFAULT = "block/grass_block_side";
    private static final String TEXTURE_DIRT_PATH_DEFAULT = "block/dirt_path_top";
    private static final String TEXTURE_DIRT_PATH_SIDE_DEFAULT = "block/dirt_path_side";
    private static final String TEXTURE_MYCELIUM_DEFAULT = "block/mycelium_top";
    private static final String TEXTURE_PODZOL_DEFAULT = "block/podzol_top";
    private static final String TEXTURE_CRIMSON_NYLIUM = "block/crimson_nylium";
    private static final String TEXTURE_WARPED_NYLIUM = "block/warped_nylium";
    private static final String TEXTURE_SNOW_DEFAULT = "block/snow";
    private static final Random RANDOM = new Random(0L);

    public static void updateIcons(TextureAtlas textureMap) {
        spritesLoaded = false;
        modelsLoaded = false;
        BetterGrass.loadProperties(textureMap);
    }

    public static void update() {
        if (spritesLoaded) {
            modelCubeGrass = BlockModelUtils.makeModelCube(spriteGrass, 0);
            if (grassMultilayer) {
                BakedModel bakedmodel = BlockModelUtils.makeModelCube(spriteGrassSide, -1);
                modelCubeGrass = BlockModelUtils.joinModelsCube(bakedmodel, modelCubeGrass);
            }
            modelDirtPath = BlockModelUtils.makeModel("dirt_path", spriteDirtPathSide, spriteDirtPath);
            modelCubeDirtPath = BlockModelUtils.makeModelCube(spriteDirtPath, -1);
            modelCubeMycelium = BlockModelUtils.makeModelCube(spriteMycelium, -1);
            modelCubePodzol = BlockModelUtils.makeModelCube(spritePodzol, 0);
            modelCubeCrimsonNylium = BlockModelUtils.makeModelCube(spriteCrimsonNylium, -1);
            modelCubeWarpedNylium = BlockModelUtils.makeModelCube(spriteWarpedNylium, -1);
            modelCubeSnow = BlockModelUtils.makeModelCube(spriteSnow, -1);
            modelsLoaded = true;
        }
    }

    private static void loadProperties(TextureAtlas textureMap) {
        betterGrass = true;
        betterDirtPath = true;
        betterMycelium = true;
        betterPodzol = true;
        betterCrimsonNylium = true;
        betterWarpedNylium = true;
        betterGrassSnow = true;
        betterMyceliumSnow = true;
        betterPodzolSnow = true;
        spriteGrass = textureMap.registerSprite(new ResourceLocation(TEXTURE_GRASS_DEFAULT));
        spriteGrassSide = textureMap.registerSprite(new ResourceLocation(TEXTURE_GRASS_SIDE_DEFAULT));
        spriteDirtPath = textureMap.registerSprite(new ResourceLocation(TEXTURE_DIRT_PATH_DEFAULT));
        spriteDirtPathSide = textureMap.registerSprite(new ResourceLocation(TEXTURE_DIRT_PATH_SIDE_DEFAULT));
        spriteMycelium = textureMap.registerSprite(new ResourceLocation(TEXTURE_MYCELIUM_DEFAULT));
        spritePodzol = textureMap.registerSprite(new ResourceLocation(TEXTURE_PODZOL_DEFAULT));
        spriteCrimsonNylium = textureMap.registerSprite(new ResourceLocation(TEXTURE_CRIMSON_NYLIUM));
        spriteWarpedNylium = textureMap.registerSprite(new ResourceLocation(TEXTURE_WARPED_NYLIUM));
        spriteSnow = textureMap.registerSprite(new ResourceLocation(TEXTURE_SNOW_DEFAULT));
        spritesLoaded = true;
        String s = "optifine/bettergrass.properties";
        try {
            ResourceLocation resourcelocation = new ResourceLocation(s);
            if (!Config.hasResource(resourcelocation)) {
                return;
            }
            InputStream inputstream = Config.getResourceStream(resourcelocation);
            if (inputstream == null) {
                return;
            }
            boolean flag = Config.isFromDefaultResourcePack(resourcelocation);
            if (flag) {
                Config.dbg("BetterGrass: Parsing default configuration " + s);
            } else {
                Config.dbg("BetterGrass: Parsing configuration " + s);
            }
            PropertiesOrdered properties = new PropertiesOrdered();
            properties.load(inputstream);
            inputstream.close();
            betterGrass = BetterGrass.getBoolean(properties, "grass", true);
            betterDirtPath = BetterGrass.getBoolean(properties, "dirt_path", true);
            betterMycelium = BetterGrass.getBoolean(properties, "mycelium", true);
            betterPodzol = BetterGrass.getBoolean(properties, "podzol", true);
            betterCrimsonNylium = BetterGrass.getBoolean(properties, "crimson_nylium", true);
            betterWarpedNylium = BetterGrass.getBoolean(properties, "warped_nylium", true);
            betterGrassSnow = BetterGrass.getBoolean(properties, "grass.snow", true);
            betterMyceliumSnow = BetterGrass.getBoolean(properties, "mycelium.snow", true);
            betterPodzolSnow = BetterGrass.getBoolean(properties, "podzol.snow", true);
            grassMultilayer = BetterGrass.getBoolean(properties, "grass.multilayer", false);
            spriteGrass = BetterGrass.registerSprite(properties, "texture.grass", TEXTURE_GRASS_DEFAULT, textureMap);
            spriteGrassSide = BetterGrass.registerSprite(properties, "texture.grass_side", TEXTURE_GRASS_SIDE_DEFAULT, textureMap);
            spriteDirtPath = BetterGrass.registerSprite(properties, "texture.dirt_path", TEXTURE_DIRT_PATH_DEFAULT, textureMap);
            spriteDirtPathSide = BetterGrass.registerSprite(properties, "texture.dirt_path_side", TEXTURE_DIRT_PATH_SIDE_DEFAULT, textureMap);
            spriteMycelium = BetterGrass.registerSprite(properties, "texture.mycelium", TEXTURE_MYCELIUM_DEFAULT, textureMap);
            spritePodzol = BetterGrass.registerSprite(properties, "texture.podzol", TEXTURE_PODZOL_DEFAULT, textureMap);
            spriteCrimsonNylium = BetterGrass.registerSprite(properties, "texture.crimson_nylium", TEXTURE_CRIMSON_NYLIUM, textureMap);
            spriteWarpedNylium = BetterGrass.registerSprite(properties, "texture.warped_nylium", TEXTURE_WARPED_NYLIUM, textureMap);
            spriteSnow = BetterGrass.registerSprite(properties, "texture.snow", TEXTURE_SNOW_DEFAULT, textureMap);
        }
        catch (IOException ioexception) {
            Config.warn("Error reading: " + s + ", " + ioexception.getClass().getName() + ": " + ioexception.getMessage());
        }
    }

    public static void refreshIcons(TextureAtlas textureMap) {
        spriteGrass = BetterGrass.getSprite(textureMap, spriteGrass.getName());
        spriteGrassSide = BetterGrass.getSprite(textureMap, spriteGrassSide.getName());
        spriteDirtPath = BetterGrass.getSprite(textureMap, spriteDirtPath.getName());
        spriteDirtPathSide = BetterGrass.getSprite(textureMap, spriteDirtPathSide.getName());
        spriteMycelium = BetterGrass.getSprite(textureMap, spriteMycelium.getName());
        spritePodzol = BetterGrass.getSprite(textureMap, spritePodzol.getName());
        spriteCrimsonNylium = BetterGrass.getSprite(textureMap, spriteCrimsonNylium.getName());
        spriteWarpedNylium = BetterGrass.getSprite(textureMap, spriteWarpedNylium.getName());
        spriteSnow = BetterGrass.getSprite(textureMap, spriteSnow.getName());
    }

    private static TextureAtlasSprite getSprite(TextureAtlas textureMap, ResourceLocation loc) {
        TextureAtlasSprite textureatlassprite = textureMap.getSprite(loc);
        if (textureatlassprite == null || textureatlassprite instanceof MissingTextureAtlasSprite) {
            Config.warn("Missing BetterGrass sprite: " + loc);
        }
        return textureatlassprite;
    }

    private static TextureAtlasSprite registerSprite(Properties props, String key, String textureDefault, TextureAtlas textureMap) {
        ResourceLocation resourcelocation;
        String s = props.getProperty(key);
        if (s == null) {
            s = textureDefault;
        }
        if (!Config.hasResource(resourcelocation = new ResourceLocation("textures/" + s + ".png"))) {
            Config.warn("BetterGrass texture not found: " + resourcelocation);
            s = textureDefault;
        }
        ResourceLocation resourcelocation1 = new ResourceLocation(s);
        return textureMap.registerSprite(resourcelocation1);
    }

    public static List getFaceQuads(BlockGetter blockAccess, BlockState blockState, BlockPos blockPos, Direction facing, List quads) {
        if (facing != Direction.UP && facing != Direction.DOWN) {
            if (!modelsLoaded) {
                return quads;
            }
            Block block = blockState.getBlock();
            if (block instanceof MyceliumBlock) {
                return BetterGrass.getFaceQuadsMycelium(blockAccess, blockState, blockPos, facing, quads);
            }
            if (block instanceof DirtPathBlock) {
                return BetterGrass.getFaceQuadsDirtPath(blockAccess, blockState, blockPos, facing, quads);
            }
            if (block == Blocks.PODZOL) {
                return BetterGrass.getFaceQuadsPodzol(blockAccess, blockState, blockPos, facing, quads);
            }
            if (block == Blocks.CRIMSON_NYLIUM) {
                return BetterGrass.getFaceQuadsCrimsonNylium(blockAccess, blockState, blockPos, facing, quads);
            }
            if (block == Blocks.WARPED_NYLIUM) {
                return BetterGrass.getFaceQuadsWarpedNylium(blockAccess, blockState, blockPos, facing, quads);
            }
            if (block == Blocks.DIRT) {
                return BetterGrass.getFaceQuadsDirt(blockAccess, blockState, blockPos, facing, quads);
            }
            return block instanceof GrassBlock ? BetterGrass.getFaceQuadsGrass(blockAccess, blockState, blockPos, facing, quads) : quads;
        }
        return quads;
    }

    private static List getFaceQuadsMycelium(BlockGetter blockAccess, BlockState blockState, BlockPos blockPos, Direction facing, List quads) {
        boolean flag;
        Block block = blockAccess.getBlockState(blockPos.above()).getBlock();
        boolean bl = flag = block == Blocks.SNOW_BLOCK || block == Blocks.SNOW;
        if (Config.isBetterGrassFancy()) {
            if (flag) {
                if (betterMyceliumSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == Blocks.SNOW) {
                    return modelCubeSnow.getQuads(blockState, facing, RANDOM);
                }
            } else if (betterMycelium && BetterGrass.getBlockAt(blockPos.below(), facing, blockAccess) == Blocks.MYCELIUM) {
                return modelCubeMycelium.getQuads(blockState, facing, RANDOM);
            }
        } else if (flag) {
            if (betterMyceliumSnow) {
                return modelCubeSnow.getQuads(blockState, facing, RANDOM);
            }
        } else if (betterMycelium) {
            return modelCubeMycelium.getQuads(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsDirtPath(BlockGetter blockAccess, BlockState blockState, BlockPos blockPos, Direction facing, List quads) {
        if (!betterDirtPath) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            return BetterGrass.getBlockAt(blockPos.below(), facing, blockAccess) == Blocks.DIRT_PATH ? modelDirtPath.getQuads(blockState, facing, RANDOM) : quads;
        }
        return modelDirtPath.getQuads(blockState, facing, RANDOM);
    }

    private static List getFaceQuadsPodzol(BlockGetter blockAccess, BlockState blockState, BlockPos blockPos, Direction facing, List quads) {
        boolean flag;
        Block block = BetterGrass.getBlockAt(blockPos, Direction.UP, blockAccess);
        boolean bl = flag = block == Blocks.SNOW_BLOCK || block == Blocks.SNOW;
        if (Config.isBetterGrassFancy()) {
            BlockPos blockpos;
            BlockState blockstate;
            if (flag) {
                if (betterPodzolSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == Blocks.SNOW) {
                    return modelCubeSnow.getQuads(blockState, facing, RANDOM);
                }
            } else if (betterPodzol && (blockstate = blockAccess.getBlockState(blockpos = blockPos.below().relative(facing))).getBlock() == Blocks.PODZOL) {
                return modelCubePodzol.getQuads(blockState, facing, RANDOM);
            }
        } else if (flag) {
            if (betterPodzolSnow) {
                return modelCubeSnow.getQuads(blockState, facing, RANDOM);
            }
        } else if (betterPodzol) {
            return modelCubePodzol.getQuads(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsCrimsonNylium(BlockGetter blockAccess, BlockState blockState, BlockPos blockPos, Direction facing, List quads) {
        if (!betterCrimsonNylium) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            return BetterGrass.getBlockAt(blockPos.below(), facing, blockAccess) == Blocks.CRIMSON_NYLIUM ? modelCubeCrimsonNylium.getQuads(blockState, facing, RANDOM) : quads;
        }
        return modelCubeCrimsonNylium.getQuads(blockState, facing, RANDOM);
    }

    private static List getFaceQuadsWarpedNylium(BlockGetter blockAccess, BlockState blockState, BlockPos blockPos, Direction facing, List quads) {
        if (!betterWarpedNylium) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            return BetterGrass.getBlockAt(blockPos.below(), facing, blockAccess) == Blocks.WARPED_NYLIUM ? modelCubeWarpedNylium.getQuads(blockState, facing, RANDOM) : quads;
        }
        return modelCubeWarpedNylium.getQuads(blockState, facing, RANDOM);
    }

    private static List getFaceQuadsDirt(BlockGetter blockAccess, BlockState blockState, BlockPos blockPos, Direction facing, List quads) {
        Block block = BetterGrass.getBlockAt(blockPos, Direction.UP, blockAccess);
        return block == Blocks.DIRT_PATH && betterDirtPath && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == Blocks.DIRT_PATH ? modelCubeDirtPath.getQuads(blockState, facing, RANDOM) : quads;
    }

    private static List getFaceQuadsGrass(BlockGetter blockAccess, BlockState blockState, BlockPos blockPos, Direction facing, List quads) {
        boolean flag;
        Block block = blockAccess.getBlockState(blockPos.above()).getBlock();
        boolean bl = flag = block == Blocks.SNOW_BLOCK || block == Blocks.SNOW;
        if (Config.isBetterGrassFancy()) {
            if (flag) {
                if (betterGrassSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == Blocks.SNOW) {
                    return modelCubeSnow.getQuads(blockState, facing, RANDOM);
                }
            } else if (betterGrass && BetterGrass.getBlockAt(blockPos.below(), facing, blockAccess) == Blocks.GRASS_BLOCK) {
                return modelCubeGrass.getQuads(blockState, facing, RANDOM);
            }
        } else if (flag) {
            if (betterGrassSnow) {
                return modelCubeSnow.getQuads(blockState, facing, RANDOM);
            }
        } else if (betterGrass) {
            return modelCubeGrass.getQuads(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static Block getBlockAt(BlockPos blockPos, Direction facing, BlockGetter blockAccess) {
        BlockPos blockpos = blockPos.relative(facing);
        return blockAccess.getBlockState(blockpos).getBlock();
    }

    private static boolean getBoolean(Properties props, String key, boolean def) {
        String s = props.getProperty(key);
        return s == null ? def : Boolean.parseBoolean(s);
    }
}

