/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.DetectedVersion;
import net.minecraft.Util;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Mth;
import net.optifine.DynamicLights;
import net.optifine.GlErrors;
import net.optifine.VersionCheckThread;
import net.optifine.config.GlVersion;
import net.optifine.gui.GuiMessage;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.Shaders;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.TextureUtils;
import net.optifine.util.TimedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLCapabilities;

public class Config {
    public static final String OF_NAME = "OptiFine";
    public static final String MC_VERSION = "1.18.2";
    public static final String OF_EDITION = "HD_U";
    public static final String OF_RELEASE = "H7";
    public static final String VERSION = "OptiFine_1.18.2_HD_U_H7";
    private static String build = null;
    private static String newRelease = null;
    private static boolean notify64BitJava = false;
    public static String openGlVersion = null;
    public static String openGlRenderer = null;
    public static String openGlVendor = null;
    public static String[] openGlExtensions = null;
    public static GlVersion glVersion = null;
    public static GlVersion glslVersion = null;
    public static int minecraftVersionInt = -1;
    private static Options gameSettings = null;
    private static Minecraft minecraft = Minecraft.getInstance();
    private static boolean initialized = false;
    private static Thread minecraftThread = null;
    private static int antialiasingLevel = 0;
    private static int availableProcessors = 0;
    public static boolean zoomMode = false;
    public static boolean zoomSmoothCamera = false;
    private static int texturePackClouds = 0;
    private static boolean fullscreenModeChecked = false;
    private static boolean desktopModeChecked = false;
    public static final Float DEF_ALPHA_FUNC_LEVEL = Float.valueOf(0.1f);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean logDetail = System.getProperty("log.detail", "false").equals("true");
    private static String mcDebugLast = null;
    private static int fpsMinLast = 0;
    private static int chunkUpdatesLast = 0;
    private static TextureAtlas textureMapTerrain;
    private static long timeLastFrameMs;
    private static long averageFrameTimeMs;
    private static boolean showFrameTime;

    static {
        showFrameTime = Boolean.getBoolean("frame.time");
    }

    private Config() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getVersionDebug() {
        StringBuffer stringbuffer = new StringBuffer(32);
        if (Config.isDynamicLights()) {
            stringbuffer.append("DL: ");
            stringbuffer.append(String.valueOf(DynamicLights.getCount()));
            stringbuffer.append(", ");
        }
        stringbuffer.append(VERSION);
        String s = Shaders.getShaderPackName();
        if (s != null) {
            stringbuffer.append(", ");
            stringbuffer.append(s);
        }
        return stringbuffer.toString();
    }

    public static void initGameSettings(Options settings) {
        if (gameSettings == null) {
            gameSettings = settings;
            Config.updateAvailableProcessors();
            ReflectorForge.putLaunchBlackboard("optifine.ForgeSplashCompatible", Boolean.TRUE);
            antialiasingLevel = Config.gameSettings.ofAaLevel;
        }
    }

    public static void initDisplay() {
        Config.checkInitialized();
        minecraftThread = Thread.currentThread();
        Config.updateThreadPriorities();
        Shaders.startup(Minecraft.getInstance());
    }

    public static void checkInitialized() {
        if (!initialized && Minecraft.getInstance().getWindow() != null) {
            initialized = true;
            Config.checkOpenGlCaps();
            Config.startVersionCheckThread();
        }
    }

    private static void checkOpenGlCaps() {
        Config.log("");
        Config.log(Config.getVersion());
        Config.log("Build: " + Config.getBuild());
        Config.log("OS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
        Config.log("Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        Config.log("VM: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
        Config.log("LWJGL: " + GLFW.glfwGetVersionString());
        openGlVersion = GL11.glGetString((int)7938);
        openGlRenderer = GL11.glGetString((int)7937);
        openGlVendor = GL11.glGetString((int)7936);
        Config.log("OpenGL: " + openGlRenderer + ", version " + openGlVersion + ", " + openGlVendor);
        Config.log("OpenGL Version: " + Config.getOpenGlVersionString());
        int i = TextureUtils.getGLMaximumTextureSize();
        Config.dbg("Maximum texture size: " + i + "x" + i);
    }

    public static String getBuild() {
        if (build == null) {
            InputStream inputstream;
            block4: {
                inputstream = Config.getOptiFineResourceStream("/buildof.txt");
                if (inputstream != null) break block4;
                return null;
            }
            try {
                build = Config.readLines(inputstream)[0];
            }
            catch (Exception exception) {
                Config.warn(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
                build = "";
            }
        }
        return build;
    }

    public static InputStream getOptiFineResourceStream(String name) {
        InputStream inputstream = ReflectorForge.getOptiFineResourceStream(name);
        return inputstream != null ? inputstream : Config.class.getResourceAsStream(name);
    }

    public static int getMinecraftVersionInt() {
        if (minecraftVersionInt < 0) {
            String s = MC_VERSION;
            if (s.contains("-")) {
                s = Config.tokenize(s, "-")[0];
            }
            if (!s.contains(".")) {
                s = DetectedVersion.BUILT_IN.getReleaseTarget();
            }
            String[] astring = Config.tokenize(s, ".");
            int i = 0;
            if (astring.length > 0) {
                i += 10000 * Config.parseInt(astring[0], 0);
            }
            if (astring.length > 1) {
                i += 100 * Config.parseInt(astring[1], 0);
            }
            if (astring.length > 2) {
                i += 1 * Config.parseInt(astring[2], 0);
            }
            minecraftVersionInt = i;
        }
        return minecraftVersionInt;
    }

    public static String getOpenGlVersionString() {
        GlVersion glversion = Config.getGlVersion();
        return String.valueOf(glversion.getMajor()) + "." + glversion.getMinor() + "." + glversion.getRelease();
    }

    private static GlVersion getGlVersionLwjgl() {
        GLCapabilities glcapabilities = GL.getCapabilities();
        if (glcapabilities.OpenGL44) {
            return new GlVersion(4, 4);
        }
        if (glcapabilities.OpenGL43) {
            return new GlVersion(4, 3);
        }
        if (glcapabilities.OpenGL42) {
            return new GlVersion(4, 2);
        }
        if (glcapabilities.OpenGL41) {
            return new GlVersion(4, 1);
        }
        if (glcapabilities.OpenGL40) {
            return new GlVersion(4, 0);
        }
        if (glcapabilities.OpenGL33) {
            return new GlVersion(3, 3);
        }
        if (glcapabilities.OpenGL32) {
            return new GlVersion(3, 2);
        }
        if (glcapabilities.OpenGL31) {
            return new GlVersion(3, 1);
        }
        if (glcapabilities.OpenGL30) {
            return new GlVersion(3, 0);
        }
        if (glcapabilities.OpenGL21) {
            return new GlVersion(2, 1);
        }
        if (glcapabilities.OpenGL20) {
            return new GlVersion(2, 0);
        }
        if (glcapabilities.OpenGL15) {
            return new GlVersion(1, 5);
        }
        if (glcapabilities.OpenGL14) {
            return new GlVersion(1, 4);
        }
        if (glcapabilities.OpenGL13) {
            return new GlVersion(1, 3);
        }
        if (glcapabilities.OpenGL12) {
            return new GlVersion(1, 2);
        }
        return glcapabilities.OpenGL11 ? new GlVersion(1, 1) : new GlVersion(1, 0);
    }

    public static GlVersion getGlVersion() {
        if (glVersion == null) {
            String s = GL11.glGetString((int)7938);
            glVersion = Config.parseGlVersion(s, null);
            if (glVersion == null) {
                glVersion = Config.getGlVersionLwjgl();
            }
            if (glVersion == null) {
                glVersion = new GlVersion(1, 0);
            }
        }
        return glVersion;
    }

    public static GlVersion getGlslVersion() {
        String s;
        if (glslVersion == null && (glslVersion = Config.parseGlVersion(s = GL11.glGetString((int)35724), null)) == null) {
            glslVersion = new GlVersion(1, 10);
        }
        return glslVersion;
    }

    public static GlVersion parseGlVersion(String versionString, GlVersion def) {
        try {
            if (versionString == null) {
                return def;
            }
            Pattern pattern = Pattern.compile("([0-9]+)\\.([0-9]+)(\\.([0-9]+))?(.+)?");
            Matcher matcher = pattern.matcher(versionString);
            if (!matcher.matches()) {
                return def;
            }
            int i = Integer.parseInt(matcher.group(1));
            int j = Integer.parseInt(matcher.group(2));
            int k = matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : 0;
            String s = matcher.group(5);
            return new GlVersion(i, j, k, s);
        }
        catch (Exception exception) {
            Config.error("", exception);
            return def;
        }
    }

    public static String[] getOpenGlExtensions() {
        if (openGlExtensions == null) {
            openGlExtensions = Config.detectOpenGlExtensions();
        }
        return openGlExtensions;
    }

    private static String[] detectOpenGlExtensions() {
        try {
            int i;
            GlVersion glversion = Config.getGlVersion();
            if (glversion.getMajor() >= 3 && (i = GL11.glGetInteger((int)33309)) > 0) {
                String[] astring = new String[i];
                int j = 0;
                while (j < i) {
                    astring[j] = GL30.glGetStringi((int)7939, (int)j);
                    ++j;
                }
                return astring;
            }
        }
        catch (Exception exception1) {
            Config.error("", exception1);
        }
        try {
            String s = GL11.glGetString((int)7939);
            return s.split(" ");
        }
        catch (Exception exception) {
            Config.error("", exception);
            return new String[0];
        }
    }

    public static void updateThreadPriorities() {
        Config.updateAvailableProcessors();
        int i = 8;
        if (Config.isSingleProcessor()) {
            if (Config.isSmoothWorld()) {
                minecraftThread.setPriority(10);
                Config.setThreadPriority("Server thread", 1);
            } else {
                minecraftThread.setPriority(5);
                Config.setThreadPriority("Server thread", 5);
            }
        } else {
            minecraftThread.setPriority(10);
            Config.setThreadPriority("Server thread", 5);
        }
    }

    private static void setThreadPriority(String prefix, int priority) {
        try {
            ThreadGroup threadgroup = Thread.currentThread().getThreadGroup();
            if (threadgroup == null) {
                return;
            }
            int i = (threadgroup.activeCount() + 10) * 2;
            Thread[] athread = new Thread[i];
            threadgroup.enumerate(athread, false);
            int j = 0;
            while (j < athread.length) {
                Thread thread = athread[j];
                if (thread != null && thread.getName().startsWith(prefix)) {
                    thread.setPriority(priority);
                }
                ++j;
            }
        }
        catch (Throwable throwable) {
            Config.warn(String.valueOf(throwable.getClass().getName()) + ": " + throwable.getMessage());
        }
    }

    public static boolean isMinecraftThread() {
        return Thread.currentThread() == minecraftThread;
    }

    private static void startVersionCheckThread() {
        VersionCheckThread versioncheckthread = new VersionCheckThread();
        versioncheckthread.start();
    }

    public static boolean isMipmaps() {
        return Config.gameSettings.mipmapLevels > 0;
    }

    public static int getMipmapLevels() {
        return Config.gameSettings.mipmapLevels;
    }

    public static int getMipmapType() {
        switch (Config.gameSettings.ofMipmapType) {
            case 0: {
                return 9986;
            }
            case 1: {
                return 9986;
            }
            case 2: {
                if (Config.isMultiTexture()) {
                    return 9985;
                }
                return 9986;
            }
            case 3: {
                if (Config.isMultiTexture()) {
                    return 9987;
                }
                return 9986;
            }
        }
        return 9986;
    }

    public static boolean isUseAlphaFunc() {
        float f = Config.getAlphaFuncLevel();
        return f > DEF_ALPHA_FUNC_LEVEL.floatValue() + 1.0E-5f;
    }

    public static float getAlphaFuncLevel() {
        return DEF_ALPHA_FUNC_LEVEL.floatValue();
    }

    public static boolean isFogOff() {
        return Config.gameSettings.ofFogType == 3;
    }

    public static boolean isFogOn() {
        return Config.gameSettings.ofFogType != 3;
    }

    public static float getFogStart() {
        return Config.gameSettings.ofFogStart;
    }

    public static void detail(String s) {
        if (logDetail) {
            LOGGER.info("[OptiFine] " + s);
        }
    }

    public static void dbg(String s) {
        LOGGER.info("[OptiFine] " + s);
    }

    public static void warn(String s) {
        LOGGER.warn("[OptiFine] " + s);
    }

    public static void warn(String s, Throwable t) {
        LOGGER.warn("[OptiFine] " + s, t);
    }

    public static void error(String s) {
        LOGGER.error("[OptiFine] " + s);
    }

    public static void error(String s, Throwable t) {
        LOGGER.error("[OptiFine] " + s, t);
    }

    public static void log(String s) {
        Config.dbg(s);
    }

    public static int getUpdatesPerFrame() {
        return Config.gameSettings.ofChunkUpdates;
    }

    public static boolean isDynamicUpdates() {
        return Config.gameSettings.ofChunkUpdatesDynamic;
    }

    public static boolean isGraphicsFancy() {
        return Config.gameSettings.graphicsMode != GraphicsStatus.FAST;
    }

    public static boolean isGraphicsFabulous() {
        return Config.gameSettings.graphicsMode == GraphicsStatus.FABULOUS;
    }

    public static boolean isRainFancy() {
        if (Config.gameSettings.ofRain == 0) {
            return Config.isGraphicsFancy();
        }
        return Config.gameSettings.ofRain == 2;
    }

    public static boolean isRainOff() {
        return Config.gameSettings.ofRain == 3;
    }

    public static boolean isCloudsFancy() {
        if (Config.gameSettings.ofClouds != 0) {
            return Config.gameSettings.ofClouds == 2;
        }
        if (Config.isShaders() && !Shaders.shaderPackClouds.isDefault()) {
            return Shaders.shaderPackClouds.isFancy();
        }
        if (texturePackClouds != 0) {
            return texturePackClouds == 2;
        }
        return Config.isGraphicsFancy();
    }

    public static boolean isCloudsOff() {
        if (Config.gameSettings.ofClouds != 0) {
            return Config.gameSettings.ofClouds == 3;
        }
        if (Config.isShaders() && !Shaders.shaderPackClouds.isDefault()) {
            return Shaders.shaderPackClouds.isOff();
        }
        if (texturePackClouds != 0) {
            return texturePackClouds == 3;
        }
        return false;
    }

    public static void updateTexturePackClouds() {
        texturePackClouds = 0;
        ResourceManager resourcemanager = Config.getResourceManager();
        if (resourcemanager != null) {
            try {
                InputStream inputstream = resourcemanager.getResource(new ResourceLocation("optifine/color.properties")).getInputStream();
                if (inputstream == null) {
                    return;
                }
                PropertiesOrdered properties = new PropertiesOrdered();
                properties.load(inputstream);
                inputstream.close();
                String s = properties.getProperty("clouds");
                if (s == null) {
                    return;
                }
                Config.dbg("Texture pack clouds: " + s);
                s = s.toLowerCase();
                if (s.equals("fast")) {
                    texturePackClouds = 1;
                }
                if (s.equals("fancy")) {
                    texturePackClouds = 2;
                }
                if (s.equals("off") || s.equals("none")) {
                    texturePackClouds = 3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ModelManager getModelManager() {
        return Config.minecraft.getItemRenderer().modelManager;
    }

    public static boolean isTreesFancy() {
        if (Config.gameSettings.ofTrees == 0) {
            return Config.isGraphicsFancy();
        }
        return Config.gameSettings.ofTrees != 1;
    }

    public static boolean isTreesSmart() {
        return Config.gameSettings.ofTrees == 4;
    }

    public static boolean isCullFacesLeaves() {
        if (Config.gameSettings.ofTrees == 0) {
            return !Config.isGraphicsFancy();
        }
        return Config.gameSettings.ofTrees == 4;
    }

    public static int limit(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        return val > max ? max : val;
    }

    public static long limit(long val, long min, long max) {
        if (val < min) {
            return min;
        }
        return val > max ? max : val;
    }

    public static float limit(float val, float min, float max) {
        if (val < min) {
            return min;
        }
        return val > max ? max : val;
    }

    public static double limit(double val, double min, double max) {
        if (val < min) {
            return min;
        }
        return val > max ? max : val;
    }

    public static float limitTo1(float val) {
        if (val < 0.0f) {
            return 0.0f;
        }
        return val > 1.0f ? 1.0f : val;
    }

    public static boolean isAnimatedWater() {
        return Config.gameSettings.ofAnimatedWater != 2;
    }

    public static boolean isGeneratedWater() {
        return Config.gameSettings.ofAnimatedWater == 1;
    }

    public static boolean isAnimatedPortal() {
        return Config.gameSettings.ofAnimatedPortal;
    }

    public static boolean isAnimatedLava() {
        return Config.gameSettings.ofAnimatedLava != 2;
    }

    public static boolean isGeneratedLava() {
        return Config.gameSettings.ofAnimatedLava == 1;
    }

    public static boolean isAnimatedFire() {
        return Config.gameSettings.ofAnimatedFire;
    }

    public static boolean isAnimatedRedstone() {
        return Config.gameSettings.ofAnimatedRedstone;
    }

    public static boolean isAnimatedExplosion() {
        return Config.gameSettings.ofAnimatedExplosion;
    }

    public static boolean isAnimatedFlame() {
        return Config.gameSettings.ofAnimatedFlame;
    }

    public static boolean isAnimatedSmoke() {
        return Config.gameSettings.ofAnimatedSmoke;
    }

    public static boolean isVoidParticles() {
        return Config.gameSettings.ofVoidParticles;
    }

    public static boolean isWaterParticles() {
        return Config.gameSettings.ofWaterParticles;
    }

    public static boolean isRainSplash() {
        return Config.gameSettings.ofRainSplash;
    }

    public static boolean isPortalParticles() {
        return Config.gameSettings.ofPortalParticles;
    }

    public static boolean isPotionParticles() {
        return Config.gameSettings.ofPotionParticles;
    }

    public static boolean isFireworkParticles() {
        return Config.gameSettings.ofFireworkParticles;
    }

    public static float getAmbientOcclusionLevel() {
        return Config.isShaders() && Shaders.aoLevel >= 0.0f ? Shaders.aoLevel : (float)Config.gameSettings.ofAoLevel;
    }

    public static String listToString(List list) {
        return Config.listToString(list, ", ");
    }

    public static String listToString(List list, String separator) {
        if (list == null) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer(list.size() * 5);
        int i = 0;
        while (i < list.size()) {
            Object object = list.get(i);
            if (i > 0) {
                stringbuffer.append(separator);
            }
            stringbuffer.append(String.valueOf(object));
            ++i;
        }
        return stringbuffer.toString();
    }

    public static String arrayToString(Object[] arr) {
        return Config.arrayToString(arr, ", ");
    }

    public static String arrayToString(Object[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer(arr.length * 5);
        int i = 0;
        while (i < arr.length) {
            Object object = arr[i];
            if (i > 0) {
                stringbuffer.append(separator);
            }
            stringbuffer.append(String.valueOf(object));
            ++i;
        }
        return stringbuffer.toString();
    }

    public static String arrayToString(int[] arr) {
        return Config.arrayToString(arr, ", ");
    }

    public static String arrayToString(int[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer(arr.length * 5);
        int i = 0;
        while (i < arr.length) {
            int j = arr[i];
            if (i > 0) {
                stringbuffer.append(separator);
            }
            stringbuffer.append(String.valueOf(j));
            ++i;
        }
        return stringbuffer.toString();
    }

    public static String arrayToString(float[] arr) {
        return Config.arrayToString(arr, ", ");
    }

    public static String arrayToString(float[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer(arr.length * 5);
        int i = 0;
        while (i < arr.length) {
            float f = arr[i];
            if (i > 0) {
                stringbuffer.append(separator);
            }
            stringbuffer.append(String.valueOf(f));
            ++i;
        }
        return stringbuffer.toString();
    }

    public static Minecraft getMinecraft() {
        return minecraft;
    }

    public static TextureManager getTextureManager() {
        return minecraft.getTextureManager();
    }

    public static ResourceManager getResourceManager() {
        return minecraft.getResourceManager();
    }

    public static InputStream getResourceStream(ResourceLocation location) throws IOException {
        return Config.getResourceStream(minecraft.getResourceManager(), location);
    }

    public static InputStream getResourceStream(ResourceManager resourceManager, ResourceLocation location) throws IOException {
        Resource resource = resourceManager.getResource(location);
        return resource == null ? null : resource.getInputStream();
    }

    public static Resource getResource(ResourceLocation location) throws IOException {
        return minecraft.getResourceManager().getResource(location);
    }

    public static boolean hasResource(ResourceLocation location) {
        if (location == null) {
            return false;
        }
        PackResources packresources = Config.getDefiningResourcePack(location);
        return packresources != null;
    }

    public static boolean hasResource(ResourceManager resourceManager, ResourceLocation location) {
        try {
            Resource resource = resourceManager.getResource(location);
            return resource != null;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public static boolean hasResource(PackResources rp, ResourceLocation loc) {
        return rp != null && loc != null ? rp.hasResource(PackType.CLIENT_RESOURCES, loc) : false;
    }

    public static PackResources[] getResourcePacks() {
        PackRepository packrepository = minecraft.getResourcePackRepository();
        Collection<Pack> collection = packrepository.getSelectedPacks();
        ArrayList<PackResources> list = new ArrayList<PackResources>();
        for (Pack pack : collection) {
            PackResources packresources = pack.open();
            if (packresources == Config.getDefaultResourcePack()) continue;
            list.add(packresources);
        }
        PackResources[] apackresources = list.toArray(new PackResources[list.size()]);
        return apackresources;
    }

    public static String getResourcePackNames() {
        if (minecraft.getResourceManager() == null) {
            return "";
        }
        PackResources[] apackresources = Config.getResourcePacks();
        if (apackresources.length <= 0) {
            return Config.getDefaultResourcePack().getName();
        }
        Object[] astring = new String[apackresources.length];
        int i = 0;
        while (i < apackresources.length) {
            astring[i] = apackresources[i].getName();
            ++i;
        }
        return Config.arrayToString(astring);
    }

    public static VanillaPackResources getDefaultResourcePack() {
        return minecraft.getClientPackSource().getVanillaPack();
    }

    public static boolean isFromDefaultResourcePack(ResourceLocation loc) {
        return Config.getDefiningResourcePack(loc) == Config.getDefaultResourcePack();
    }

    public static PackResources getDefiningResourcePack(ResourceLocation location) {
        PackRepository packrepository = minecraft.getResourcePackRepository();
        Collection<Pack> collection = packrepository.getSelectedPacks();
        List list = (List)collection;
        int i = list.size() - 1;
        while (i >= 0) {
            Pack pack = (Pack)list.get(i);
            PackResources packresources = pack.open();
            if (packresources.hasResource(PackType.CLIENT_RESOURCES, location)) {
                return packresources;
            }
            --i;
        }
        return null;
    }

    public static LevelRenderer getRenderGlobal() {
        return Config.minecraft.levelRenderer;
    }

    public static LevelRenderer getWorldRenderer() {
        return Config.minecraft.levelRenderer;
    }

    public static GameRenderer getGameRenderer() {
        return Config.minecraft.gameRenderer;
    }

    public static EntityRenderDispatcher getEntityRenderDispatcher() {
        return minecraft.getEntityRenderDispatcher();
    }

    public static boolean isBetterGrass() {
        return Config.gameSettings.ofBetterGrass != 3;
    }

    public static boolean isBetterGrassFancy() {
        return Config.gameSettings.ofBetterGrass == 2;
    }

    public static boolean isWeatherEnabled() {
        return Config.gameSettings.ofWeather;
    }

    public static boolean isSkyEnabled() {
        return Config.gameSettings.ofSky;
    }

    public static boolean isSunMoonEnabled() {
        return Config.gameSettings.ofSunMoon;
    }

    public static boolean isSunTexture() {
        if (!Config.isSunMoonEnabled()) {
            return false;
        }
        return !Config.isShaders() || Shaders.isSun();
    }

    public static boolean isMoonTexture() {
        if (!Config.isSunMoonEnabled()) {
            return false;
        }
        return !Config.isShaders() || Shaders.isMoon();
    }

    public static boolean isVignetteEnabled() {
        if (Config.isShaders() && !Shaders.isVignette()) {
            return false;
        }
        if (Config.gameSettings.ofVignette == 0) {
            return Config.isGraphicsFancy();
        }
        return Config.gameSettings.ofVignette == 2;
    }

    public static boolean isStarsEnabled() {
        return Config.gameSettings.ofStars;
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedexception) {
            Config.error("", interruptedexception);
        }
    }

    public static boolean isTimeDayOnly() {
        return Config.gameSettings.ofTime == 1;
    }

    public static boolean isTimeDefault() {
        return Config.gameSettings.ofTime == 0;
    }

    public static boolean isTimeNightOnly() {
        return Config.gameSettings.ofTime == 2;
    }

    public static int getAnisotropicFilterLevel() {
        return Config.gameSettings.ofAfLevel;
    }

    public static boolean isAnisotropicFiltering() {
        return Config.getAnisotropicFilterLevel() > 1;
    }

    public static int getAntialiasingLevel() {
        return antialiasingLevel;
    }

    public static boolean isAntialiasing() {
        return Config.getAntialiasingLevel() > 0;
    }

    public static boolean isAntialiasingConfigured() {
        return Config.getGameSettings().ofAaLevel > 0;
    }

    public static boolean isMultiTexture() {
        if (Config.getAnisotropicFilterLevel() > 1) {
            return true;
        }
        return Config.getAntialiasingLevel() > 0;
    }

    public static boolean between(int val, int min, int max) {
        return val >= min && val <= max;
    }

    public static boolean between(float val, float min, float max) {
        return val >= min && val <= max;
    }

    public static boolean between(double val, double min, double max) {
        return val >= min && val <= max;
    }

    public static boolean isDrippingWaterLava() {
        return Config.gameSettings.ofDrippingWaterLava;
    }

    public static boolean isBetterSnow() {
        return Config.gameSettings.ofBetterSnow;
    }

    public static int parseInt(String str, int defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            str = str.trim();
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberformatexception) {
            return defVal;
        }
    }

    public static int parseHexInt(String str, int defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            if ((str = str.trim()).startsWith("0x")) {
                str = str.substring(2);
            }
            return Integer.parseInt(str, 16);
        }
        catch (NumberFormatException numberformatexception) {
            return defVal;
        }
    }

    public static float parseFloat(String str, float defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            str = str.trim();
            return Float.parseFloat(str);
        }
        catch (NumberFormatException numberformatexception) {
            return defVal;
        }
    }

    public static boolean parseBoolean(String str, boolean defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            str = str.trim();
            return Boolean.parseBoolean(str);
        }
        catch (NumberFormatException numberformatexception) {
            return defVal;
        }
    }

    public static Boolean parseBoolean(String str, Boolean defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            if ((str = str.trim().toLowerCase()).equals("true")) {
                return Boolean.TRUE;
            }
            return str.equals("false") ? Boolean.FALSE : defVal;
        }
        catch (NumberFormatException numberformatexception) {
            return defVal;
        }
    }

    public static String[] tokenize(String str, String delim) {
        StringTokenizer stringtokenizer = new StringTokenizer(str, delim);
        ArrayList<String> list = new ArrayList<String>();
        while (stringtokenizer.hasMoreTokens()) {
            String s = stringtokenizer.nextToken();
            list.add(s);
        }
        String[] astring = list.toArray(new String[list.size()]);
        return astring;
    }

    public static boolean isAnimatedTerrain() {
        return Config.gameSettings.ofAnimatedTerrain;
    }

    public static boolean isAnimatedTextures() {
        return Config.gameSettings.ofAnimatedTextures;
    }

    public static boolean isSwampColors() {
        return Config.gameSettings.ofSwampColors;
    }

    public static boolean isRandomEntities() {
        return Config.gameSettings.ofRandomEntities;
    }

    public static void checkGlError(String loc) {
        int i = GlStateManager._getError();
        if (i != 0 && GlErrors.isEnabled(i)) {
            String s = Config.getGlErrorString(i);
            String s1 = String.format("OpenGL error: %s (%s), at: %s", i, s, loc);
            Config.error(s1);
            if (Config.isShowGlErrors() && TimedEvent.isActive("ShowGlError", 10000L)) {
                String s2 = I18n.a("of.message.openglError", i, s);
                Config.minecraft.gui.getChat().addMessage(new TextComponent(s2));
            }
        }
    }

    public static boolean isSmoothBiomes() {
        return Config.gameSettings.biomeBlendRadius > 0;
    }

    public static int getBiomeBlendRadius() {
        return Config.gameSettings.biomeBlendRadius;
    }

    public static boolean isCustomColors() {
        return Config.gameSettings.ofCustomColors;
    }

    public static boolean isCustomSky() {
        return Config.gameSettings.ofCustomSky;
    }

    public static boolean isCustomFonts() {
        return Config.gameSettings.ofCustomFonts;
    }

    public static boolean isShowCapes() {
        return Config.gameSettings.ofShowCapes;
    }

    public static boolean isConnectedTextures() {
        return Config.gameSettings.ofConnectedTextures != 3;
    }

    public static boolean isNaturalTextures() {
        return Config.gameSettings.ofNaturalTextures;
    }

    public static boolean isEmissiveTextures() {
        return Config.gameSettings.ofEmissiveTextures;
    }

    public static boolean isConnectedTexturesFancy() {
        return Config.gameSettings.ofConnectedTextures == 2;
    }

    public static boolean isFastRender() {
        return Config.gameSettings.ofFastRender;
    }

    public static boolean isShaders() {
        return Shaders.shaderPackLoaded;
    }

    public static boolean isShadersShadows() {
        return Config.isShaders() && Shaders.hasShadowMap;
    }

    public static String[] readLines(File file) throws IOException {
        FileInputStream fileinputstream = new FileInputStream(file);
        return Config.readLines(fileinputstream);
    }

    public static String[] readLines(InputStream is) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        InputStreamReader inputstreamreader = new InputStreamReader(is, "ASCII");
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        String s;
        while ((s = bufferedreader.readLine()) != null) {
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String readFile(File file) throws IOException {
        FileInputStream fileinputstream = new FileInputStream(file);
        return Config.readInputStream(fileinputstream, "ASCII");
    }

    public static String readInputStream(InputStream in) throws IOException {
        return Config.readInputStream(in, "ASCII");
    }

    public static String readInputStream(InputStream in, String encoding) throws IOException {
        InputStreamReader inputstreamreader = new InputStreamReader(in, encoding);
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        StringBuffer stringbuffer = new StringBuffer();
        while (true) {
            String s;
            if ((s = bufferedreader.readLine()) == null) {
                in.close();
                return stringbuffer.toString();
            }
            stringbuffer.append(s);
            stringbuffer.append("\n");
        }
    }

    public static byte[] readAll(InputStream is) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        byte[] abyte = new byte[1024];
        while (true) {
            int i;
            if ((i = is.read(abyte)) < 0) {
                is.close();
                return bytearrayoutputstream.toByteArray();
            }
            bytearrayoutputstream.write(abyte, 0, i);
        }
    }

    public static Options getGameSettings() {
        return gameSettings;
    }

    public static String getNewRelease() {
        return newRelease;
    }

    public static void setNewRelease(String newRelease) {
        Config.newRelease = newRelease;
    }

    public static int compareRelease(String rel1, String rel2) {
        int j;
        String[] astring1;
        String s1;
        String[] astring = Config.splitRelease(rel1);
        String s = astring[0];
        if (!s.equals(s1 = (astring1 = Config.splitRelease(rel2))[0])) {
            return s.compareTo(s1);
        }
        int i = Config.parseInt(astring[1], -1);
        if (i != (j = Config.parseInt(astring1[1], -1))) {
            return i - j;
        }
        String s2 = astring[2];
        String s3 = astring1[2];
        if (!s2.equals(s3)) {
            if (s2.isEmpty()) {
                return 1;
            }
            if (s3.isEmpty()) {
                return -1;
            }
        }
        return s2.compareTo(s3);
    }

    private static String[] splitRelease(String relStr) {
        if (relStr != null && relStr.length() > 0) {
            Pattern pattern = Pattern.compile("([A-Z])([0-9]+)(.*)");
            Matcher matcher = pattern.matcher(relStr);
            if (!matcher.matches()) {
                return new String[]{"", "", ""};
            }
            String s = Config.normalize(matcher.group(1));
            String s1 = Config.normalize(matcher.group(2));
            String s2 = Config.normalize(matcher.group(3));
            return new String[]{s, s1, s2};
        }
        return new String[]{"", "", ""};
    }

    public static int intHash(int x) {
        x = x ^ 0x3D ^ x >> 16;
        x += x << 3;
        x ^= x >> 4;
        return (x *= 668265261) ^ x >> 15;
    }

    public static int getRandom(BlockPos blockPos, int face) {
        int i = Config.intHash(face + 37);
        i = Config.intHash(i + blockPos.getX());
        i = Config.intHash(i + blockPos.getZ());
        return Config.intHash(i + blockPos.getY());
    }

    public static int getAvailableProcessors() {
        return availableProcessors;
    }

    public static void updateAvailableProcessors() {
        availableProcessors = Runtime.getRuntime().availableProcessors();
    }

    public static boolean isSingleProcessor() {
        return Config.getAvailableProcessors() <= 1;
    }

    public static boolean isSmoothWorld() {
        return Config.gameSettings.ofSmoothWorld;
    }

    public static boolean isLazyChunkLoading() {
        return Config.gameSettings.ofLazyChunkLoading;
    }

    public static boolean isDynamicFov() {
        return Config.gameSettings.ofDynamicFov;
    }

    public static boolean isAlternateBlocks() {
        return Config.gameSettings.ofAlternateBlocks;
    }

    public static int getChunkViewDistance() {
        return gameSettings == null ? 10 : Config.gameSettings.renderDistance;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        return o1 == null ? false : o1.equals(o2);
    }

    public static boolean equalsOne(Object a, Object[] bs) {
        if (bs == null) {
            return false;
        }
        int i = 0;
        while (i < bs.length) {
            Object object = bs[i];
            if (Config.equals(a, object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean equalsOne(int val, int[] vals) {
        int i = 0;
        while (i < vals.length) {
            if (vals[i] == val) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSameOne(Object a, Object[] bs) {
        if (bs == null) {
            return false;
        }
        int i = 0;
        while (i < bs.length) {
            Object object = bs[i];
            if (a == object) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String normalize(String s) {
        return s == null ? "" : s;
    }

    private static ByteBuffer readIconImage(InputStream is) throws IOException {
        BufferedImage bufferedimage = ImageIO.read(is);
        int[] aint = bufferedimage.getRGB(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight(), null, 0, bufferedimage.getWidth());
        ByteBuffer bytebuffer = ByteBuffer.allocate(4 * aint.length);
        int[] nArray = aint;
        int n = aint.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            bytebuffer.putInt(i << 8 | i >> 24 & 0xFF);
            ++n2;
        }
        bytebuffer.flip();
        return bytebuffer;
    }

    public static Object[] addObjectToArray(Object[] arr, Object obj) {
        if (arr == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int i = arr.length;
        int j = i + 1;
        Object[] aobject = (Object[])Array.newInstance(arr.getClass().getComponentType(), j);
        System.arraycopy(arr, 0, aobject, 0, i);
        aobject[i] = obj;
        return aobject;
    }

    public static Object[] addObjectToArray(Object[] arr, Object obj, int index) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
        list.add(index, obj);
        Object[] aobject = (Object[])Array.newInstance(arr.getClass().getComponentType(), list.size());
        return list.toArray(aobject);
    }

    public static Object[] addObjectsToArray(Object[] arr, Object[] objs) {
        if (arr == null) {
            throw new NullPointerException("The given array is NULL");
        }
        if (objs.length == 0) {
            return arr;
        }
        int i = arr.length;
        int j = i + objs.length;
        Object[] aobject = (Object[])Array.newInstance(arr.getClass().getComponentType(), j);
        System.arraycopy(arr, 0, aobject, 0, i);
        System.arraycopy(objs, 0, aobject, i, objs.length);
        return aobject;
    }

    public static Object[] removeObjectFromArray(Object[] arr, Object obj) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
        list.remove(obj);
        return Config.collectionToArray(list, arr.getClass().getComponentType());
    }

    public static Object[] collectionToArray(Collection coll, Class elementClass) {
        if (coll == null) {
            return null;
        }
        if (elementClass == null) {
            return null;
        }
        if (elementClass.isPrimitive()) {
            throw new IllegalArgumentException("Can not make arrays with primitive elements (int, double), element class: " + elementClass);
        }
        Object[] aobject = (Object[])Array.newInstance(elementClass, coll.size());
        return coll.toArray(aobject);
    }

    public static boolean isCustomItems() {
        return Config.gameSettings.ofCustomItems;
    }

    public static void drawFps(PoseStack matrixStackIn) {
        int i = Config.getChunkUpdates();
        int j = Config.minecraft.levelRenderer.countRenderedChunks();
        int k = Config.minecraft.levelRenderer.getCountEntitiesRendered();
        int l = Config.minecraft.levelRenderer.getCountTileEntitiesRendered();
        String s = String.valueOf(Config.getFpsString()) + ", C: " + j + ", E: " + k + "+" + l + ", U: " + i;
        Config.minecraft.font.draw(matrixStackIn, s, 2.0f, 2.0f, -2039584);
    }

    public static String getFpsString() {
        int i = Config.getFpsAverage();
        int j = Config.getFpsMin();
        if (showFrameTime) {
            String s1 = String.format("%.1f", 1000.0 / (double)Config.limit(i, 1, Integer.MAX_VALUE));
            String s = String.format("%.1f", 1000.0 / (double)Config.limit(j, 1, Integer.MAX_VALUE));
            return String.valueOf(s1) + "/" + s + " ms";
        }
        return String.valueOf(i) + "/" + j + " fps";
    }

    public static boolean isShowFrameTime() {
        return showFrameTime;
    }

    public static int getFpsAverage() {
        return Reflector.getFieldValueInt(Reflector.Minecraft_debugFPS, -1);
    }

    public static int getFpsMin() {
        return fpsMinLast;
    }

    public static int getChunkUpdates() {
        return chunkUpdatesLast;
    }

    public static void updateFpsMin() {
        int j;
        FrameTimer frametimer = minecraft.getFrameTimer();
        long[] along = frametimer.getLog();
        int i = frametimer.getLogEnd();
        if (i != (j = frametimer.getLogStart())) {
            long l;
            int k = Reflector.getFieldValueInt(Reflector.Minecraft_debugFPS, -1);
            if (k <= 0) {
                k = 1;
            }
            long i1 = l = (long)(1.0 / (double)k * 1.0E9);
            long j1 = 0L;
            int k1 = Mth.positiveModulo(i - 1, along.length);
            while (k1 != j && (double)j1 < 1.0E9) {
                long l1 = along[k1];
                if (l1 > i1) {
                    i1 = l1;
                }
                j1 += l1;
                k1 = Mth.positiveModulo(k1 - 1, along.length);
            }
            double d0 = (double)i1 / 1.0E9;
            fpsMinLast = (int)(1.0 / d0);
        }
    }

    private static void updateChunkUpdates() {
        chunkUpdatesLast = ChunkRenderDispatcher.renderChunksUpdated;
        ChunkRenderDispatcher.renderChunksUpdated = 0;
    }

    public static int getBitsOs() {
        String s = System.getenv("ProgramFiles(X86)");
        return s != null ? 64 : 32;
    }

    public static int getBitsJre() {
        String[] astring = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"};
        int i = 0;
        while (i < astring.length) {
            String s = astring[i];
            String s1 = System.getProperty(s);
            if (s1 != null && s1.contains("64")) {
                return 64;
            }
            ++i;
        }
        return 32;
    }

    public static boolean isNotify64BitJava() {
        return notify64BitJava;
    }

    public static void setNotify64BitJava(boolean flag) {
        notify64BitJava = flag;
    }

    public static boolean isConnectedModels() {
        return false;
    }

    public static void showGuiMessage(String line1, String line2) {
        GuiMessage guimessage = new GuiMessage(Config.minecraft.screen, line1, line2);
        minecraft.setScreen(guimessage);
    }

    public static int[] addIntToArray(int[] intArray, int intValue) {
        return Config.addIntsToArray(intArray, new int[]{intValue});
    }

    public static int[] addIntsToArray(int[] intArray, int[] copyFrom) {
        if (intArray != null && copyFrom != null) {
            int i = intArray.length;
            int j = i + copyFrom.length;
            int[] aint = new int[j];
            System.arraycopy(intArray, 0, aint, 0, i);
            int k = 0;
            while (k < copyFrom.length) {
                aint[k + i] = copyFrom[k];
                ++k;
            }
            return aint;
        }
        throw new NullPointerException("The given array is NULL");
    }

    public static void writeFile(File file, String str) throws IOException {
        FileOutputStream fileoutputstream = new FileOutputStream(file);
        byte[] abyte = str.getBytes("ASCII");
        fileoutputstream.write(abyte);
        fileoutputstream.close();
    }

    public static void setTextureMap(TextureAtlas textureMapTerrain) {
        Config.textureMapTerrain = textureMapTerrain;
    }

    public static TextureAtlas getTextureMap() {
        return textureMapTerrain;
    }

    public static boolean isDynamicLights() {
        return Config.gameSettings.ofDynamicLights != 3;
    }

    public static boolean isDynamicLightsFast() {
        return Config.gameSettings.ofDynamicLights == 1;
    }

    public static boolean isDynamicHandLight() {
        if (!Config.isDynamicLights()) {
            return false;
        }
        return Config.isShaders() ? Shaders.isDynamicHandLight() : true;
    }

    public static boolean isCustomEntityModels() {
        return Config.gameSettings.ofCustomEntityModels;
    }

    public static boolean isCustomGuis() {
        return Config.gameSettings.ofCustomGuis;
    }

    public static int getScreenshotSize() {
        return Config.gameSettings.ofScreenshotSize;
    }

    public static int[] toPrimitive(Integer[] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return new int[0];
        }
        int[] aint = new int[arr.length];
        int i = 0;
        while (i < aint.length) {
            aint[i] = arr[i];
            ++i;
        }
        return aint;
    }

    public static boolean isRenderRegions() {
        if (Config.isMultiTexture()) {
            return false;
        }
        return Config.gameSettings.ofRenderRegions && GlStateManager.vboRegions;
    }

    public static boolean isVbo() {
        return GLX.useVbo();
    }

    public static boolean isSmoothFps() {
        return Config.gameSettings.ofSmoothFps;
    }

    public static boolean openWebLink(URI uri) {
        Util.setExceptionOpenUrl(null);
        Util.getPlatform().openUri(uri);
        Exception exception = Util.getExceptionOpenUrl();
        return exception == null;
    }

    public static boolean isShowGlErrors() {
        return Config.gameSettings.ofShowGlErrors;
    }

    public static String arrayToString(boolean[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer(arr.length * 5);
        int i = 0;
        while (i < arr.length) {
            boolean flag = arr[i];
            if (i > 0) {
                stringbuffer.append(separator);
            }
            stringbuffer.append(String.valueOf(flag));
            ++i;
        }
        return stringbuffer.toString();
    }

    public static boolean isIntegratedServerRunning() {
        if (minecraft.getSingleplayerServer() == null) {
            return false;
        }
        return minecraft.isLocalServer();
    }

    public static IntBuffer createDirectIntBuffer(int capacity) {
        return MemoryTracker.create(capacity << 2).asIntBuffer();
    }

    public static PointerBuffer createDirectPointerBuffer(int capacity) {
        return PointerBuffer.allocateDirect((int)capacity);
    }

    public static String getGlErrorString(int err) {
        switch (err) {
            case 0: {
                return "No error";
            }
            case 1280: {
                return "Invalid enum";
            }
            case 1281: {
                return "Invalid value";
            }
            case 1282: {
                return "Invalid operation";
            }
            case 1283: {
                return "Stack overflow";
            }
            case 1284: {
                return "Stack underflow";
            }
            case 1285: {
                return "Out of memory";
            }
            case 1286: {
                return "Invalid framebuffer operation";
            }
        }
        return "Unknown";
    }

    public static boolean isKeyDown(int key) {
        return GLFW.glfwGetKey((long)minecraft.getWindow().getWindow(), (int)key) == 1;
    }

    public static boolean isTrue(Boolean val) {
        return val != null && val != false;
    }

    public static boolean isFalse(Boolean val) {
        return val != null && val == false;
    }

    public static boolean isReloadingResources() {
        LoadingOverlay loadingoverlay;
        if (minecraft.getOverlay() == null) {
            return false;
        }
        return !(minecraft.getOverlay() instanceof LoadingOverlay) || !(loadingoverlay = (LoadingOverlay)minecraft.getOverlay()).isFadeOut();
    }

    public static boolean isQuadsToTriangles() {
        if (!Config.isShaders()) {
            return false;
        }
        return !Shaders.canRenderQuads();
    }

    public static void frameStart() {
        long i = System.currentTimeMillis();
        long j = i - timeLastFrameMs;
        timeLastFrameMs = i;
        j = Config.limit(j, 1L, 1000L);
        averageFrameTimeMs = (averageFrameTimeMs + j) / 2L;
        averageFrameTimeMs = Config.limit(averageFrameTimeMs, 1L, 1000L);
        if (Config.minecraft.fpsString != mcDebugLast) {
            mcDebugLast = Config.minecraft.fpsString;
            Config.updateFpsMin();
            Config.updateChunkUpdates();
        }
    }

    public static long getAverageFrameTimeMs() {
        return averageFrameTimeMs;
    }

    public static float getAverageFrameTimeSec() {
        return (float)Config.getAverageFrameTimeMs() / 1000.0f;
    }

    public static long getAverageFrameFps() {
        return 1000L / Config.getAverageFrameTimeMs();
    }

    public static void checkNull(Object obj, String msg) throws NullPointerException {
        if (obj == null) {
            throw new NullPointerException(msg);
        }
    }

    public static boolean isTelemetryOn() {
        return Config.gameSettings.ofTelemetry != 2;
    }

    public static boolean isTelemetryAnonymous() {
        return Config.gameSettings.ofTelemetry == 1;
    }
}

