/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.WaterLilyBlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.optifine.BlockPosM;
import net.optifine.Config;
import net.optifine.CustomColorFader;
import net.optifine.CustomColormap;
import net.optifine.LightMap;
import net.optifine.LightMapPack;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.render.RenderEnv;
import net.optifine.util.BiomeUtils;
import net.optifine.util.EntityUtils;
import net.optifine.util.PotionUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import net.optifine.util.WorldUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CustomColors {
    private static String paletteFormatDefault = "vanilla";
    private static CustomColormap waterColors = null;
    private static CustomColormap foliagePineColors = null;
    private static CustomColormap foliageBirchColors = null;
    private static CustomColormap swampFoliageColors = null;
    private static CustomColormap swampGrassColors = null;
    private static CustomColormap[] colorsBlockColormaps = null;
    private static CustomColormap[][] blockColormaps = null;
    private static CustomColormap skyColors = null;
    private static CustomColorFader skyColorFader = new CustomColorFader();
    private static CustomColormap fogColors = null;
    private static CustomColorFader fogColorFader = new CustomColorFader();
    private static CustomColormap underwaterColors = null;
    private static CustomColorFader underwaterColorFader = new CustomColorFader();
    private static CustomColormap underlavaColors = null;
    private static CustomColorFader underlavaColorFader = new CustomColorFader();
    private static LightMapPack[] lightMapPacks = null;
    private static int lightmapMinDimensionId = 0;
    private static CustomColormap redstoneColors = null;
    private static CustomColormap xpOrbColors = null;
    private static int xpOrbTime = -1;
    private static CustomColormap durabilityColors = null;
    private static CustomColormap stemColors = null;
    private static CustomColormap stemMelonColors = null;
    private static CustomColormap stemPumpkinColors = null;
    private static CustomColormap lavaDropColors = null;
    private static CustomColormap myceliumParticleColors = null;
    private static boolean useDefaultGrassFoliageColors = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static int expBarTextColor = -1;
    private static int bossTextColor = -1;
    private static int signTextColor = -1;
    private static Vec3 fogColorNether = null;
    private static Vec3 fogColorEnd = null;
    private static Vec3 skyColorEnd = null;
    private static int[] spawnEggPrimaryColors = null;
    private static int[] spawnEggSecondaryColors = null;
    private static float[][] wolfCollarColors = null;
    private static float[][] sheepColors = null;
    private static int[] textColors = null;
    private static int[] mapColorsOriginal = null;
    private static float[][] dyeColorsOriginal = null;
    private static int[] potionColors = null;
    private static final BlockState BLOCK_STATE_DIRT = Blocks.DIRT.defaultBlockState();
    private static final BlockState BLOCK_STATE_WATER = Blocks.WATER.defaultBlockState();
    public static Random random = new Random();
    private static final IColorizer COLORIZER_GRASS = new IColorizer(){

        @Override
        public int getColor(BlockState blockState, BlockAndTintGetter blockAccess, BlockPos blockPos) {
            Biome biome = CustomColors.getColorBiome(blockAccess, blockPos);
            return swampGrassColors != null && biome == BiomeUtils.SWAMP ? swampGrassColors.getColor(biome, blockPos) : biome.getGrassColor(blockPos.getX(), blockPos.getZ());
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE = new IColorizer(){

        @Override
        public int getColor(BlockState blockState, BlockAndTintGetter blockAccess, BlockPos blockPos) {
            Biome biome = CustomColors.getColorBiome(blockAccess, blockPos);
            return swampFoliageColors != null && biome == BiomeUtils.SWAMP ? swampFoliageColors.getColor(biome, blockPos) : biome.getFoliageColor();
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_PINE = new IColorizer(){

        @Override
        public int getColor(BlockState blockState, BlockAndTintGetter blockAccess, BlockPos blockPos) {
            return foliagePineColors != null ? foliagePineColors.getColor(blockAccess, blockPos) : FoliageColor.getEvergreenColor();
        }

        @Override
        public boolean isColorConstant() {
            return foliagePineColors == null;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_BIRCH = new IColorizer(){

        @Override
        public int getColor(BlockState blockState, BlockAndTintGetter blockAccess, BlockPos blockPos) {
            return foliageBirchColors != null ? foliageBirchColors.getColor(blockAccess, blockPos) : FoliageColor.getBirchColor();
        }

        @Override
        public boolean isColorConstant() {
            return foliageBirchColors == null;
        }
    };
    private static final IColorizer COLORIZER_WATER = new IColorizer(){

        @Override
        public int getColor(BlockState blockState, BlockAndTintGetter blockAccess, BlockPos blockPos) {
            Biome biome = CustomColors.getColorBiome(blockAccess, blockPos);
            return waterColors != null ? waterColors.getColor(biome, blockPos) : biome.getWaterColor();
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };

    public static void update() {
        paletteFormatDefault = "vanilla";
        waterColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        underlavaColors = null;
        redstoneColors = null;
        xpOrbColors = null;
        xpOrbTime = -1;
        durabilityColors = null;
        stemColors = null;
        lavaDropColors = null;
        myceliumParticleColors = null;
        lightMapPacks = null;
        particleWaterColor = -1;
        particlePortalColor = -1;
        lilyPadColor = -1;
        expBarTextColor = -1;
        bossTextColor = -1;
        signTextColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        colorsBlockColormaps = null;
        blockColormaps = null;
        useDefaultGrassFoliageColors = true;
        spawnEggPrimaryColors = null;
        spawnEggSecondaryColors = null;
        wolfCollarColors = null;
        sheepColors = null;
        textColors = null;
        CustomColors.setMapColors(mapColorsOriginal);
        CustomColors.setDyeColors(dyeColorsOriginal);
        potionColors = null;
        paletteFormatDefault = CustomColors.getValidProperty("optifine/color.properties", "palette.format", CustomColormap.FORMAT_STRINGS, "vanilla");
        String s = "optifine/colormap/";
        String[] astring = new String[]{"water.png", "watercolorx.png"};
        waterColors = CustomColors.getCustomColors(s, astring, 256, -1);
        CustomColors.updateUseDefaultGrassFoliageColors();
        if (Config.isCustomColors()) {
            String[] astring1 = new String[]{"pine.png", "pinecolor.png"};
            foliagePineColors = CustomColors.getCustomColors(s, astring1, 256, -1);
            String[] astring2 = new String[]{"birch.png", "birchcolor.png"};
            foliageBirchColors = CustomColors.getCustomColors(s, astring2, 256, -1);
            String[] astring3 = new String[]{"swampgrass.png", "swampgrasscolor.png"};
            swampGrassColors = CustomColors.getCustomColors(s, astring3, 256, -1);
            String[] astring4 = new String[]{"swampfoliage.png", "swampfoliagecolor.png"};
            swampFoliageColors = CustomColors.getCustomColors(s, astring4, 256, -1);
            String[] astring5 = new String[]{"sky0.png", "skycolor0.png"};
            skyColors = CustomColors.getCustomColors(s, astring5, 256, -1);
            String[] astring6 = new String[]{"fog0.png", "fogcolor0.png"};
            fogColors = CustomColors.getCustomColors(s, astring6, 256, -1);
            String[] astring7 = new String[]{"underwater.png", "underwatercolor.png"};
            underwaterColors = CustomColors.getCustomColors(s, astring7, 256, -1);
            String[] astring8 = new String[]{"underlava.png", "underlavacolor.png"};
            underlavaColors = CustomColors.getCustomColors(s, astring8, 256, -1);
            String[] astring9 = new String[]{"redstone.png", "redstonecolor.png"};
            redstoneColors = CustomColors.getCustomColors(s, astring9, 16, 1);
            xpOrbColors = CustomColors.getCustomColors(String.valueOf(s) + "xporb.png", -1, -1);
            durabilityColors = CustomColors.getCustomColors(String.valueOf(s) + "durability.png", -1, -1);
            String[] astring10 = new String[]{"stem.png", "stemcolor.png"};
            stemColors = CustomColors.getCustomColors(s, astring10, 8, 1);
            stemPumpkinColors = CustomColors.getCustomColors(String.valueOf(s) + "pumpkinstem.png", 8, 1);
            stemMelonColors = CustomColors.getCustomColors(String.valueOf(s) + "melonstem.png", 8, 1);
            lavaDropColors = CustomColors.getCustomColors(String.valueOf(s) + "lavadrop.png", -1, 1);
            String[] astring11 = new String[]{"myceliumparticle.png", "myceliumparticlecolor.png"};
            myceliumParticleColors = CustomColors.getCustomColors(s, astring11, -1, -1);
            Pair<LightMapPack[], Integer> pair = CustomColors.parseLightMapPacks();
            lightMapPacks = (LightMapPack[])pair.getLeft();
            lightmapMinDimensionId = (Integer)pair.getRight();
            CustomColors.readColorProperties("optifine/color.properties");
            blockColormaps = CustomColors.readBlockColormaps(new String[]{String.valueOf(s) + "custom/", String.valueOf(s) + "blocks/"}, colorsBlockColormaps, 256, -1);
            CustomColors.updateUseDefaultGrassFoliageColors();
        }
    }

    private static String getValidProperty(String fileName, String key, String[] validValues, String valDef) {
        try {
            ResourceLocation resourcelocation = new ResourceLocation(fileName);
            InputStream inputstream = Config.getResourceStream(resourcelocation);
            if (inputstream == null) {
                return valDef;
            }
            PropertiesOrdered properties = new PropertiesOrdered();
            properties.load(inputstream);
            inputstream.close();
            String s = properties.getProperty(key);
            if (s == null) {
                return valDef;
            }
            List<String> list = Arrays.asList(validValues);
            if (!list.contains(s)) {
                CustomColors.warn("Invalid value: " + key + "=" + s);
                CustomColors.warn("Expected values: " + Config.arrayToString(validValues));
                return valDef;
            }
            CustomColors.dbg(String.valueOf(key) + "=" + s);
            return s;
        }
        catch (FileNotFoundException filenotfoundexception) {
            return valDef;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            return valDef;
        }
    }

    private static Pair<LightMapPack[], Integer> parseLightMapPacks() {
        String s = "optifine/lightmap/world";
        String s1 = ".png";
        String[] astring = ResUtils.collectFiles(s, s1);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int i = 0;
        while (i < astring.length) {
            String s2 = astring[i];
            String s3 = StrUtils.removePrefixSuffix(s2, s, s1);
            int j = Config.parseInt(s3, Integer.MIN_VALUE);
            if (j == Integer.MIN_VALUE) {
                CustomColors.warn("Invalid dimension ID: " + s3 + ", path: " + s2);
            } else {
                map.put(j, s2);
            }
            ++i;
        }
        Set set = map.keySet();
        Object[] ainteger = set.toArray(new Integer[set.size()]);
        Arrays.sort(ainteger);
        if (ainteger.length <= 0) {
            return new ImmutablePair(null, (Object)0);
        }
        int j1 = (Integer)ainteger[0];
        int k1 = (Integer)ainteger[ainteger.length - 1];
        int k = k1 - j1 + 1;
        CustomColormap[] acustomcolormap = new CustomColormap[k];
        int l = 0;
        while (l < ainteger.length) {
            Object integer = ainteger[l];
            String s4 = (String)map.get(integer);
            CustomColormap customcolormap = CustomColors.getCustomColors(s4, -1, -1);
            if (customcolormap != null) {
                if (customcolormap.getWidth() < 16) {
                    CustomColors.warn("Invalid lightmap width: " + customcolormap.getWidth() + ", path: " + s4);
                } else {
                    int i1 = (Integer)integer - j1;
                    acustomcolormap[i1] = customcolormap;
                }
            }
            ++l;
        }
        LightMapPack[] alightmappack = new LightMapPack[acustomcolormap.length];
        int l1 = 0;
        while (l1 < acustomcolormap.length) {
            CustomColormap customcolormap3 = acustomcolormap[l1];
            if (customcolormap3 != null) {
                LightMapPack lightmappack;
                String s5 = customcolormap3.name;
                String s6 = customcolormap3.basePath;
                CustomColormap customcolormap1 = CustomColors.getCustomColors(String.valueOf(s6) + "/" + s5 + "_rain.png", -1, -1);
                CustomColormap customcolormap2 = CustomColors.getCustomColors(String.valueOf(s6) + "/" + s5 + "_thunder.png", -1, -1);
                LightMap lightmap = new LightMap(customcolormap3);
                LightMap lightmap1 = customcolormap1 != null ? new LightMap(customcolormap1) : null;
                LightMap lightmap2 = customcolormap2 != null ? new LightMap(customcolormap2) : null;
                alightmappack[l1] = lightmappack = new LightMapPack(lightmap, lightmap1, lightmap2);
            }
            ++l1;
        }
        return new ImmutablePair((Object)alightmappack, (Object)j1);
    }

    private static int getTextureHeight(String path, int defHeight) {
        try {
            InputStream inputstream = Config.getResourceStream(new ResourceLocation(path));
            if (inputstream == null) {
                return defHeight;
            }
            BufferedImage bufferedimage = ImageIO.read(inputstream);
            inputstream.close();
            return bufferedimage == null ? defHeight : bufferedimage.getHeight();
        }
        catch (IOException ioexception) {
            return defHeight;
        }
    }

    private static void readColorProperties(String fileName) {
        try {
            float[][] afloat;
            ResourceLocation resourcelocation = new ResourceLocation(fileName);
            InputStream inputstream = Config.getResourceStream(resourcelocation);
            if (inputstream == null) {
                return;
            }
            CustomColors.dbg("Loading " + fileName);
            PropertiesOrdered properties = new PropertiesOrdered();
            properties.load(inputstream);
            inputstream.close();
            particleWaterColor = CustomColors.readColor((Properties)properties, new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColors.readColor((Properties)properties, "particle.portal");
            lilyPadColor = CustomColors.readColor((Properties)properties, "lilypad");
            expBarTextColor = CustomColors.readColor((Properties)properties, "text.xpbar");
            bossTextColor = CustomColors.readColor((Properties)properties, "text.boss");
            signTextColor = CustomColors.readColor((Properties)properties, "text.sign");
            fogColorNether = CustomColors.readColorVec3(properties, "fog.nether");
            fogColorEnd = CustomColors.readColorVec3(properties, "fog.end");
            skyColorEnd = CustomColors.readColorVec3(properties, "sky.end");
            colorsBlockColormaps = CustomColors.readCustomColormaps(properties, fileName);
            spawnEggPrimaryColors = CustomColors.readSpawnEggColors(properties, fileName, "egg.shell.", "Spawn egg shell");
            spawnEggSecondaryColors = CustomColors.readSpawnEggColors(properties, fileName, "egg.spots.", "Spawn egg spot");
            wolfCollarColors = CustomColors.readDyeColors(properties, fileName, "collar.", "Wolf collar");
            sheepColors = CustomColors.readDyeColors(properties, fileName, "sheep.", "Sheep");
            textColors = CustomColors.readTextColors(properties, fileName, "text.code.", "Text");
            int[] aint = CustomColors.readMapColors(properties, fileName, "map.", "Map");
            if (aint != null) {
                if (mapColorsOriginal == null) {
                    mapColorsOriginal = CustomColors.getMapColors();
                }
                CustomColors.setMapColors(aint);
            }
            if ((afloat = CustomColors.readDyeColors(properties, fileName, "dye.", "Dye")) != null) {
                if (dyeColorsOriginal == null) {
                    dyeColorsOriginal = CustomColors.getDyeColors();
                }
                CustomColors.setDyeColors(afloat);
            }
            potionColors = CustomColors.readPotionColors(properties, fileName, "potion.", "Potion");
            xpOrbTime = Config.parseInt(properties.getProperty("xporb.time"), -1);
        }
        catch (FileNotFoundException filenotfoundexception) {
            return;
        }
        catch (IOException ioexception) {
            Config.warn("Error parsing: " + fileName);
            Config.warn(String.valueOf(ioexception.getClass().getName()) + ": " + ioexception.getMessage());
        }
    }

    private static CustomColormap[] readCustomColormaps(Properties props, String fileName) {
        ArrayList<CustomColormap> list = new ArrayList<CustomColormap>();
        String s = "palette.block.";
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : props.keySet()) {
            String s2 = props.getProperty(string);
            if (!string.startsWith(s)) continue;
            map.put(string, s2);
        }
        String[] stringArray = map.keySet().toArray(new String[map.size()]);
        int j = 0;
        while (j < stringArray.length) {
            String s6 = stringArray[j];
            String s3 = props.getProperty(s6);
            CustomColors.dbg("Block palette: " + s6 + " = " + s3);
            String s4 = s6.substring(s.length());
            String s5 = TextureUtils.getBasePath(fileName);
            s4 = TextureUtils.fixResourcePath(s4, s5);
            CustomColormap customcolormap = CustomColors.getCustomColors(s4, 256, -1);
            if (customcolormap == null) {
                CustomColors.warn("Colormap not found: " + s4);
            } else {
                ConnectedParser connectedparser = new ConnectedParser("CustomColors");
                MatchBlock[] amatchblock = connectedparser.parseMatchBlocks(s3);
                if (amatchblock != null && amatchblock.length > 0) {
                    int i = 0;
                    while (i < amatchblock.length) {
                        MatchBlock matchblock = amatchblock[i];
                        customcolormap.addMatchBlock(matchblock);
                        ++i;
                    }
                    list.add(customcolormap);
                } else {
                    CustomColors.warn("Invalid match blocks: " + s3);
                }
            }
            ++j;
        }
        return list.size() <= 0 ? null : list.toArray(new CustomColormap[list.size()]);
    }

    private static CustomColormap[][] readBlockColormaps(String[] basePaths, CustomColormap[] basePalettes, int width, int height) {
        Object[] astring = ResUtils.collectFiles(basePaths, new String[]{".properties"});
        Arrays.sort(astring);
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < astring.length) {
            Object s = astring[i];
            CustomColors.dbg("Block colormap: " + (String)s);
            try {
                ResourceLocation resourcelocation = new ResourceLocation("minecraft", (String)s);
                InputStream inputstream = Config.getResourceStream(resourcelocation);
                if (inputstream == null) {
                    CustomColors.warn("File not found: " + (String)s);
                } else {
                    PropertiesOrdered properties = new PropertiesOrdered();
                    properties.load(inputstream);
                    inputstream.close();
                    CustomColormap customcolormap = new CustomColormap(properties, (String)s, width, height, paletteFormatDefault);
                    if (customcolormap.isValid((String)s) && customcolormap.isValidMatchBlocks((String)s)) {
                        CustomColors.addToBlockList(customcolormap, list);
                    }
                }
            }
            catch (FileNotFoundException filenotfoundexception) {
                CustomColors.warn("File not found: " + (String)s);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++i;
        }
        if (basePalettes != null) {
            int j = 0;
            while (j < basePalettes.length) {
                CustomColormap customcolormap1 = basePalettes[j];
                CustomColors.addToBlockList(customcolormap1, list);
                ++j;
            }
        }
        return list.size() <= 0 ? null : CustomColors.blockListToArray(list);
    }

    private static void addToBlockList(CustomColormap cm, List blockList) {
        int[] aint = cm.getMatchBlockIds();
        if (aint != null && aint.length > 0) {
            int i = 0;
            while (i < aint.length) {
                int j = aint[i];
                if (j < 0) {
                    CustomColors.warn("Invalid block ID: " + j);
                } else {
                    CustomColors.addToList(cm, blockList, j);
                }
                ++i;
            }
        } else {
            CustomColors.warn("No match blocks: " + Config.arrayToString(aint));
        }
    }

    private static void addToList(CustomColormap cm, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<CustomColormap> sublist = (ArrayList<CustomColormap>)list.get(id);
        if (sublist == null) {
            sublist = new ArrayList<CustomColormap>();
            list.set(id, sublist);
        }
        sublist.add(cm);
    }

    private static CustomColormap[][] blockListToArray(List list) {
        CustomColormap[][] acustomcolormap = new CustomColormap[list.size()][];
        int i = 0;
        while (i < list.size()) {
            List lista = (List)list.get(i);
            if (lista != null) {
                CustomColormap[] acustomcolormap1 = lista.toArray(new CustomColormap[lista.size()]);
                acustomcolormap[i] = acustomcolormap1;
            }
            ++i;
        }
        return acustomcolormap;
    }

    private static int readColor(Properties props, String[] names) {
        int i = 0;
        while (i < names.length) {
            String s = names[i];
            int j = CustomColors.readColor(props, s);
            if (j >= 0) {
                return j;
            }
            ++i;
        }
        return -1;
    }

    private static int readColor(Properties props, String name) {
        String s = props.getProperty(name);
        if (s == null) {
            return -1;
        }
        int i = CustomColors.parseColor(s = s.trim());
        if (i < 0) {
            CustomColors.warn("Invalid color: " + name + " = " + s);
            return i;
        }
        CustomColors.dbg(String.valueOf(name) + " = " + s);
        return i;
    }

    private static int parseColor(String str) {
        if (str == null) {
            return -1;
        }
        str = str.trim();
        try {
            return Integer.parseInt(str, 16) & 0xFFFFFF;
        }
        catch (NumberFormatException numberformatexception) {
            return -1;
        }
    }

    private static Vec3 readColorVec3(Properties props, String name) {
        int i = CustomColors.readColor(props, name);
        if (i < 0) {
            return null;
        }
        int j = i >> 16 & 0xFF;
        int k = i >> 8 & 0xFF;
        int l = i & 0xFF;
        float f = (float)j / 255.0f;
        float f1 = (float)k / 255.0f;
        float f2 = (float)l / 255.0f;
        return new Vec3(f, f1, f2);
    }

    private static CustomColormap getCustomColors(String basePath, String[] paths, int width, int height) {
        int i = 0;
        while (i < paths.length) {
            String s = paths[i];
            s = String.valueOf(basePath) + s;
            CustomColormap customcolormap = CustomColors.getCustomColors(s, width, height);
            if (customcolormap != null) {
                return customcolormap;
            }
            ++i;
        }
        return null;
    }

    public static CustomColormap getCustomColors(String pathImage, int width, int height) {
        block5: {
            try {
                ResourceLocation resourcelocation = new ResourceLocation(pathImage);
                if (Config.hasResource(resourcelocation)) break block5;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        CustomColors.dbg("Colormap " + pathImage);
        PropertiesOrdered properties = new PropertiesOrdered();
        String s = StrUtils.replaceSuffix(pathImage, ".png", ".properties");
        ResourceLocation resourcelocation1 = new ResourceLocation(s);
        if (Config.hasResource(resourcelocation1)) {
            InputStream inputstream = Config.getResourceStream(resourcelocation1);
            properties.load(inputstream);
            inputstream.close();
            CustomColors.dbg("Colormap properties: " + s);
        } else {
            ((Properties)properties).put("format", paletteFormatDefault);
            ((Properties)properties).put("source", pathImage);
            s = pathImage;
        }
        CustomColormap customcolormap = new CustomColormap(properties, s, width, height, paletteFormatDefault);
        return !customcolormap.isValid(s) ? null : customcolormap;
    }

    public static void updateUseDefaultGrassFoliageColors() {
        useDefaultGrassFoliageColors = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && Config.isSwampColors();
    }

    public static int getColorMultiplier(BakedQuad quad, BlockState blockState, BlockAndTintGetter blockAccess, BlockPos blockPos, RenderEnv renderEnv) {
        return CustomColors.getColorMultiplier(quad.isTinted(), blockState, blockAccess, blockPos, renderEnv);
    }

    public static int getColorMultiplier(boolean quadHasTintIndex, BlockState blockState, BlockAndTintGetter blockAccess, BlockPos blockPos, RenderEnv renderEnv) {
        IColorizer customcolors$icolorizer;
        Block block = blockState.getBlock();
        BlockState blockstate = blockState;
        if (blockColormaps != null) {
            CustomColormap customcolormap;
            if (!quadHasTintIndex) {
                if (block == Blocks.GRASS_BLOCK) {
                    blockstate = BLOCK_STATE_DIRT;
                }
                if (block == Blocks.REDSTONE_WIRE) {
                    return -1;
                }
            }
            if (block instanceof DoublePlantBlock && blockState.getValue(DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
                blockPos = blockPos.below();
                blockstate = blockAccess.getBlockState(blockPos);
            }
            if ((customcolormap = CustomColors.getBlockColormap(blockstate)) != null) {
                if (Config.isSmoothBiomes() && !customcolormap.isColorConstant()) {
                    return CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, customcolormap, renderEnv.getColorizerBlockPosM());
                }
                return customcolormap.getColor(blockAccess, blockPos);
            }
        }
        if (!quadHasTintIndex) {
            return -1;
        }
        if (block == Blocks.LILY_PAD) {
            return CustomColors.getLilypadColorMultiplier(blockAccess, blockPos);
        }
        if (block == Blocks.REDSTONE_WIRE) {
            return CustomColors.getRedstoneColor(renderEnv.getBlockState());
        }
        if (block instanceof StemBlock) {
            return CustomColors.getStemColorMultiplier(blockState, blockAccess, blockPos, renderEnv);
        }
        if (useDefaultGrassFoliageColors) {
            return -1;
        }
        if (block != Blocks.GRASS_BLOCK && !(block instanceof TallGrassBlock) && !(block instanceof DoublePlantBlock) && block != Blocks.SUGAR_CANE) {
            if (block instanceof DoublePlantBlock) {
                customcolors$icolorizer = COLORIZER_GRASS;
                if (blockState.getValue(DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
                    blockPos = blockPos.below();
                }
            } else if (block instanceof LeavesBlock) {
                customcolors$icolorizer = block == Blocks.OAK_LEAVES ? COLORIZER_FOLIAGE : (block == Blocks.SPRUCE_LEAVES ? COLORIZER_FOLIAGE_PINE : (block == Blocks.BIRCH_LEAVES ? COLORIZER_FOLIAGE_BIRCH : COLORIZER_FOLIAGE));
            } else {
                if (block != Blocks.VINE) {
                    return -1;
                }
                customcolors$icolorizer = COLORIZER_FOLIAGE;
            }
        } else {
            customcolors$icolorizer = COLORIZER_GRASS;
        }
        return Config.isSmoothBiomes() && !customcolors$icolorizer.isColorConstant() ? CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, customcolors$icolorizer, renderEnv.getColorizerBlockPosM()) : customcolors$icolorizer.getColor(blockstate, blockAccess, blockPos);
    }

    protected static Biome getColorBiome(BlockAndTintGetter blockAccess, BlockPos blockPos) {
        Biome biome = BiomeUtils.getBiome(blockAccess, blockPos);
        if (!(biome != BiomeUtils.SWAMP && biome != BiomeUtils.SWAMP_HILLS || Config.isSwampColors())) {
            biome = BiomeUtils.PLAINS;
        }
        return biome;
    }

    private static CustomColormap getBlockColormap(BlockState blockState) {
        if (blockColormaps == null) {
            return null;
        }
        if (!(blockState instanceof BlockState)) {
            return null;
        }
        BlockState blockstate = blockState;
        int i = blockState.getBlockId();
        if (i >= 0 && i < blockColormaps.length) {
            CustomColormap[] acustomcolormap = blockColormaps[i];
            if (acustomcolormap == null) {
                return null;
            }
            int j = 0;
            while (j < acustomcolormap.length) {
                CustomColormap customcolormap = acustomcolormap[j];
                if (customcolormap.matchesBlock(blockstate)) {
                    return customcolormap;
                }
                ++j;
            }
            return null;
        }
        return null;
    }

    private static int getSmoothColorMultiplier(BlockState blockState, BlockAndTintGetter blockAccess, BlockPos blockPos, IColorizer colorizer, BlockPosM blockPosM) {
        int i = 0;
        int j = 0;
        int k = 0;
        int l = blockPos.getX();
        int i1 = blockPos.getY();
        int j1 = blockPos.getZ();
        BlockPosM blockposm = blockPosM;
        int k1 = Config.getBiomeBlendRadius();
        int l1 = k1 * 2 + 1;
        int i2 = l1 * l1;
        int j2 = l - k1;
        while (j2 <= l + k1) {
            int k2 = j1 - k1;
            while (k2 <= j1 + k1) {
                blockposm.setXyz(j2, i1, k2);
                int l2 = colorizer.getColor(blockState, blockAccess, blockposm);
                i += l2 >> 16 & 0xFF;
                j += l2 >> 8 & 0xFF;
                k += l2 & 0xFF;
                ++k2;
            }
            ++j2;
        }
        int i3 = i / i2;
        int j3 = j / i2;
        int k3 = k / i2;
        return i3 << 16 | j3 << 8 | k3;
    }

    public static int getFluidColor(BlockAndTintGetter blockAccess, BlockState blockState, BlockPos blockPos, RenderEnv renderEnv) {
        Block block = blockState.getBlock();
        IColorizer customcolors$icolorizer = CustomColors.getBlockColormap(blockState);
        if (customcolors$icolorizer == null && blockState.getMaterial() == Material.WATER) {
            customcolors$icolorizer = COLORIZER_WATER;
        }
        if (customcolors$icolorizer == null) {
            return CustomColors.getBlockColors().getColor(blockState, blockAccess, blockPos, 0);
        }
        return Config.isSmoothBiomes() && !customcolors$icolorizer.isColorConstant() ? CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, customcolors$icolorizer, renderEnv.getColorizerBlockPosM()) : customcolors$icolorizer.getColor(blockState, blockAccess, blockPos);
    }

    public static BlockColors getBlockColors() {
        return Minecraft.getInstance().getBlockColors();
    }

    public static void updatePortalFX(Particle fx) {
        if (particlePortalColor >= 0) {
            int i = particlePortalColor;
            int j = i >> 16 & 0xFF;
            int k = i >> 8 & 0xFF;
            int l = i & 0xFF;
            float f = (float)j / 255.0f;
            float f1 = (float)k / 255.0f;
            float f2 = (float)l / 255.0f;
            fx.setColor(f, f1, f2);
        }
    }

    public static void updateLavaFX(Particle fx) {
        if (lavaDropColors != null) {
            int i = fx.getAge();
            int j = lavaDropColors.getColor(i);
            int k = j >> 16 & 0xFF;
            int l = j >> 8 & 0xFF;
            int i1 = j & 0xFF;
            float f = (float)k / 255.0f;
            float f1 = (float)l / 255.0f;
            float f2 = (float)i1 / 255.0f;
            fx.setColor(f, f1, f2);
        }
    }

    public static void updateMyceliumFX(Particle fx) {
        if (myceliumParticleColors != null) {
            int i = myceliumParticleColors.getColorRandom();
            int j = i >> 16 & 0xFF;
            int k = i >> 8 & 0xFF;
            int l = i & 0xFF;
            float f = (float)j / 255.0f;
            float f1 = (float)k / 255.0f;
            float f2 = (float)l / 255.0f;
            fx.setColor(f, f1, f2);
        }
    }

    private static int getRedstoneColor(BlockState blockState) {
        if (redstoneColors == null) {
            return -1;
        }
        int i = CustomColors.getRedstoneLevel(blockState, 15);
        return redstoneColors.getColor(i);
    }

    public static void updateReddustFX(Particle fx, BlockAndTintGetter blockAccess, double x, double y, double z) {
        if (redstoneColors != null) {
            BlockState blockstate = blockAccess.getBlockState(new BlockPos(x, y, z));
            int i = CustomColors.getRedstoneLevel(blockstate, 15);
            int j = redstoneColors.getColor(i);
            int k = j >> 16 & 0xFF;
            int l = j >> 8 & 0xFF;
            int i1 = j & 0xFF;
            float f = (float)k / 255.0f;
            float f1 = (float)l / 255.0f;
            float f2 = (float)i1 / 255.0f;
            fx.setColor(f, f1, f2);
        }
    }

    private static int getRedstoneLevel(BlockState state, int def) {
        Block block = state.getBlock();
        if (!(block instanceof RedStoneWireBlock)) {
            return def;
        }
        Integer object = state.getValue(RedStoneWireBlock.POWER);
        if (!(object instanceof Integer)) {
            return def;
        }
        Integer integer = object;
        return integer;
    }

    public static float getXpOrbTimer(float timer) {
        if (xpOrbTime <= 0) {
            return timer;
        }
        float f = 628.0f / (float)xpOrbTime;
        return timer * f;
    }

    public static int getXpOrbColor(float timer) {
        if (xpOrbColors == null) {
            return -1;
        }
        int i = (int)Math.round((double)((Mth.sin(timer) + 1.0f) * (float)(xpOrbColors.getLength() - 1)) / 2.0);
        return xpOrbColors.getColor(i);
    }

    public static int getDurabilityColor(float dur, int color) {
        if (durabilityColors == null) {
            return color;
        }
        int i = (int)(dur * (float)durabilityColors.getLength());
        return durabilityColors.getColor(i);
    }

    public static void updateWaterFX(Particle fx, BlockAndTintGetter blockAccess, double x, double y, double z, RenderEnv renderEnv) {
        if (waterColors != null || blockColormaps != null || particleWaterColor >= 0) {
            BlockPos blockpos = new BlockPos(x, y, z);
            renderEnv.reset(BLOCK_STATE_WATER, blockpos);
            int i = CustomColors.getFluidColor(blockAccess, BLOCK_STATE_WATER, blockpos, renderEnv);
            int j = i >> 16 & 0xFF;
            int k = i >> 8 & 0xFF;
            int l = i & 0xFF;
            float f = (float)j / 255.0f;
            float f1 = (float)k / 255.0f;
            float f2 = (float)l / 255.0f;
            if (particleWaterColor >= 0) {
                int i1 = particleWaterColor >> 16 & 0xFF;
                int j1 = particleWaterColor >> 8 & 0xFF;
                int k1 = particleWaterColor & 0xFF;
                f = (float)i1 / 255.0f;
                f1 = (float)j1 / 255.0f;
                f2 = (float)k1 / 255.0f;
                f *= (float)i1 / 255.0f;
                f1 *= (float)j1 / 255.0f;
                f2 *= (float)k1 / 255.0f;
            }
            fx.setColor(f, f1, f2);
        }
    }

    private static int getLilypadColorMultiplier(BlockAndTintGetter blockAccess, BlockPos blockPos) {
        return lilyPadColor < 0 ? CustomColors.getBlockColors().getColor(Blocks.LILY_PAD.defaultBlockState(), blockAccess, blockPos, 0) : lilyPadColor;
    }

    private static Vec3 getFogColorNether(Vec3 col) {
        return fogColorNether == null ? col : fogColorNether;
    }

    private static Vec3 getFogColorEnd(Vec3 col) {
        return fogColorEnd == null ? col : fogColorEnd;
    }

    private static Vec3 getSkyColorEnd(Vec3 col) {
        return skyColorEnd == null ? col : skyColorEnd;
    }

    public static Vec3 getSkyColor(Vec3 skyColor3d, BlockAndTintGetter blockAccess, double x, double y, double z) {
        if (skyColors == null) {
            return skyColor3d;
        }
        int i = skyColors.getColorSmooth(blockAccess, x, y, z, 3);
        int j = i >> 16 & 0xFF;
        int k = i >> 8 & 0xFF;
        int l = i & 0xFF;
        float f = (float)j / 255.0f;
        float f1 = (float)k / 255.0f;
        float f2 = (float)l / 255.0f;
        float f3 = (float)skyColor3d.x / 0.5f;
        float f4 = (float)skyColor3d.y / 0.66275f;
        float f5 = (float)skyColor3d.z;
        return skyColorFader.getColor(f *= f3, f1 *= f4, f2 *= f5);
    }

    private static Vec3 getFogColor(Vec3 fogColor3d, BlockAndTintGetter blockAccess, double x, double y, double z) {
        if (fogColors == null) {
            return fogColor3d;
        }
        int i = fogColors.getColorSmooth(blockAccess, x, y, z, 3);
        int j = i >> 16 & 0xFF;
        int k = i >> 8 & 0xFF;
        int l = i & 0xFF;
        float f = (float)j / 255.0f;
        float f1 = (float)k / 255.0f;
        float f2 = (float)l / 255.0f;
        float f3 = (float)fogColor3d.x / 0.753f;
        float f4 = (float)fogColor3d.y / 0.8471f;
        float f5 = (float)fogColor3d.z;
        return fogColorFader.getColor(f *= f3, f1 *= f4, f2 *= f5);
    }

    public static Vec3 getUnderwaterColor(BlockAndTintGetter blockAccess, double x, double y, double z) {
        return CustomColors.getUnderFluidColor(blockAccess, x, y, z, underwaterColors, underwaterColorFader);
    }

    public static Vec3 getUnderlavaColor(BlockAndTintGetter blockAccess, double x, double y, double z) {
        return CustomColors.getUnderFluidColor(blockAccess, x, y, z, underlavaColors, underlavaColorFader);
    }

    public static Vec3 getUnderFluidColor(BlockAndTintGetter blockAccess, double x, double y, double z, CustomColormap underFluidColors, CustomColorFader underFluidColorFader) {
        if (underFluidColors == null) {
            return null;
        }
        int i = underFluidColors.getColorSmooth(blockAccess, x, y, z, 3);
        int j = i >> 16 & 0xFF;
        int k = i >> 8 & 0xFF;
        int l = i & 0xFF;
        float f = (float)j / 255.0f;
        float f1 = (float)k / 255.0f;
        float f2 = (float)l / 255.0f;
        return underFluidColorFader.getColor(f, f1, f2);
    }

    private static int getStemColorMultiplier(BlockState blockState, BlockGetter blockAccess, BlockPos blockPos, RenderEnv renderEnv) {
        CustomColormap customcolormap = stemColors;
        Block block = blockState.getBlock();
        if (block == Blocks.PUMPKIN_STEM && stemPumpkinColors != null) {
            customcolormap = stemPumpkinColors;
        }
        if (block == Blocks.MELON_STEM && stemMelonColors != null) {
            customcolormap = stemMelonColors;
        }
        if (customcolormap == null) {
            return -1;
        }
        if (!(block instanceof StemBlock)) {
            return -1;
        }
        int i = blockState.getValue(StemBlock.AGE);
        return customcolormap.getColor(i);
    }

    public static boolean updateLightmap(ClientLevel world, float torchFlickerX, NativeImage lmColors, boolean nightvision, float partialTicks) {
        if (world == null) {
            return false;
        }
        if (lightMapPacks == null) {
            return false;
        }
        int i = WorldUtils.getDimensionId(world);
        int j = i - lightmapMinDimensionId;
        if (j >= 0 && j < lightMapPacks.length) {
            LightMapPack lightmappack = lightMapPacks[j];
            return lightmappack == null ? false : lightmappack.updateLightmap(world, torchFlickerX, lmColors, nightvision, partialTicks);
        }
        return false;
    }

    public static Vec3 getWorldFogColor(Vec3 fogVec, Level world, Entity renderViewEntity, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        if (WorldUtils.isNether(world)) {
            return CustomColors.getFogColorNether(fogVec);
        }
        if (WorldUtils.isOverworld(world)) {
            return CustomColors.getFogColor(fogVec, minecraft.level, renderViewEntity.getX(), renderViewEntity.getY() + 1.0, renderViewEntity.getZ());
        }
        return WorldUtils.isEnd(world) ? CustomColors.getFogColorEnd(fogVec) : fogVec;
    }

    public static Vec3 getWorldSkyColor(Vec3 skyVec, Level world, Entity renderViewEntity, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        if (WorldUtils.isOverworld(world) && renderViewEntity != null) {
            return CustomColors.getSkyColor(skyVec, minecraft.level, renderViewEntity.getX(), renderViewEntity.getY() + 1.0, renderViewEntity.getZ());
        }
        return WorldUtils.isEnd(world) ? CustomColors.getSkyColorEnd(skyVec) : skyVec;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static int[] readSpawnEggColors(Properties props, String fileName, String prefix, String logName) {
        list = new ArrayList<Integer>();
        set = props.keySet();
        i = 0;
        for (String s : set) {
            s1 = props.getProperty(s);
            if (!s.startsWith(prefix)) continue;
            s2 = StrUtils.removePrefix(s, prefix);
            j = EntityUtils.getEntityIdByName(s2);
            try {
                if (j < 0) {
                    j = EntityUtils.getEntityIdByLocation(new ResourceLocation(s2).toString());
                }
            }
            catch (ResourceLocationException resourcelocationexception) {
                Config.warn("ResourceLocationException: " + resourcelocationexception.getMessage());
            }
            if (j < 0) {
                CustomColors.warn("Invalid spawn egg name: " + s);
                continue;
            }
            k = CustomColors.parseColor(s1);
            if (k >= 0) ** GOTO lbl24
            CustomColors.warn("Invalid spawn egg color: " + s + " = " + s1);
            continue;
lbl-1000:
            // 1 sources

            {
                list.add(-1);
lbl24:
                // 2 sources

                ** while (list.size() <= j)
            }
lbl25:
            // 1 sources

            list.set(j, k);
            ++i;
        }
        if (i <= 0) {
            return null;
        }
        CustomColors.dbg(String.valueOf(logName) + " colors: " + i);
        aint = new int[list.size()];
        l = 0;
        while (l < aint.length) {
            aint[l] = (Integer)list.get(l);
            ++l;
        }
        return aint;
    }

    private static int getSpawnEggColor(SpawnEggItem item, ItemStack itemStack, int layer, int color) {
        int[] aint;
        if (spawnEggPrimaryColors == null && spawnEggSecondaryColors == null) {
            return color;
        }
        EntityType<?> entitytype = item.getType(itemStack.getTag());
        if (entitytype == null) {
            return color;
        }
        int i = Registry.ENTITY_TYPE.getId(entitytype);
        if (i < 0) {
            return color;
        }
        int[] nArray = aint = layer == 0 ? spawnEggPrimaryColors : spawnEggSecondaryColors;
        if (aint == null) {
            return color;
        }
        if (i >= 0 && i < aint.length) {
            int j = aint[i];
            return j < 0 ? color : j;
        }
        return color;
    }

    public static int getColorFromItemStack(ItemStack itemStack, int layer, int color) {
        if (itemStack == null) {
            return color;
        }
        Item item = itemStack.getItem();
        if (item == null) {
            return color;
        }
        if (item instanceof SpawnEggItem) {
            return CustomColors.getSpawnEggColor((SpawnEggItem)item, itemStack, layer, color);
        }
        return item instanceof WaterLilyBlockItem && lilyPadColor != -1 ? lilyPadColor : color;
    }

    private static float[][] readDyeColors(Properties props, String fileName, String prefix, String logName) {
        DyeColor[] adyecolor = DyeColor.values();
        HashMap<String, DyeColor> map = new HashMap<String, DyeColor>();
        int i = 0;
        while (i < adyecolor.length) {
            DyeColor dyecolor = adyecolor[i];
            map.put(dyecolor.getSerializedName(), dyecolor);
            ++i;
        }
        map.put("lightBlue", DyeColor.LIGHT_BLUE);
        map.put("silver", DyeColor.LIGHT_GRAY);
        float[][] afloat1 = new float[adyecolor.length][];
        int k = 0;
        for (String string : props.keySet()) {
            String s1 = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String s2 = StrUtils.removePrefix(string, prefix);
            DyeColor dyecolor1 = (DyeColor)map.get(s2);
            int j = CustomColors.parseColor(s1);
            if (dyecolor1 != null && j >= 0) {
                float[] afloat = new float[]{(float)(j >> 16 & 0xFF) / 255.0f, (float)(j >> 8 & 0xFF) / 255.0f, (float)(j & 0xFF) / 255.0f};
                afloat1[dyecolor1.ordinal()] = afloat;
                ++k;
                continue;
            }
            CustomColors.warn("Invalid color: " + string + " = " + s1);
        }
        if (k <= 0) {
            return null;
        }
        CustomColors.dbg(String.valueOf(logName) + " colors: " + k);
        return afloat1;
    }

    private static float[] getDyeColors(DyeColor dye, float[][] dyeColors, float[] colors) {
        if (dyeColors == null) {
            return colors;
        }
        if (dye == null) {
            return colors;
        }
        float[] afloat = dyeColors[dye.ordinal()];
        return afloat == null ? colors : afloat;
    }

    public static float[] getWolfCollarColors(DyeColor dye, float[] colors) {
        return CustomColors.getDyeColors(dye, wolfCollarColors, colors);
    }

    public static float[] getSheepColors(DyeColor dye, float[] colors) {
        return CustomColors.getDyeColors(dye, sheepColors, colors);
    }

    private static int[] readTextColors(Properties props, String fileName, String prefix, String logName) {
        int[] aint = new int[32];
        Arrays.fill(aint, -1);
        int i = 0;
        for (String string : props.keySet()) {
            String s1 = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String s2 = StrUtils.removePrefix(string, prefix);
            int j = Config.parseInt(s2, -1);
            int k = CustomColors.parseColor(s1);
            if (j >= 0 && j < aint.length && k >= 0) {
                aint[j] = k;
                ++i;
                continue;
            }
            CustomColors.warn("Invalid color: " + string + " = " + s1);
        }
        if (i <= 0) {
            return null;
        }
        CustomColors.dbg(String.valueOf(logName) + " colors: " + i);
        return aint;
    }

    public static int getTextColor(int index, int color) {
        if (textColors == null) {
            return color;
        }
        if (index >= 0 && index < textColors.length) {
            int i = textColors[index];
            return i < 0 ? color : i;
        }
        return color;
    }

    private static int[] readMapColors(Properties props, String fileName, String prefix, String logName) {
        int[] aint = new int[MaterialColor.MATERIAL_COLORS.length];
        Arrays.fill(aint, -1);
        int i = 0;
        for (String string : props.keySet()) {
            String s1 = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String s2 = StrUtils.removePrefix(string, prefix);
            int j = CustomColors.getMapColorIndex(s2);
            int k = CustomColors.parseColor(s1);
            if (j >= 0 && j < aint.length && k >= 0) {
                aint[j] = k;
                ++i;
                continue;
            }
            CustomColors.warn("Invalid color: " + string + " = " + s1);
        }
        if (i <= 0) {
            return null;
        }
        CustomColors.dbg(String.valueOf(logName) + " colors: " + i);
        return aint;
    }

    private static int[] readPotionColors(Properties props, String fileName, String prefix, String logName) {
        int[] aint = new int[CustomColors.getMaxPotionId()];
        Arrays.fill(aint, -1);
        int i = 0;
        for (String string : props.keySet()) {
            String s1 = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            int j = CustomColors.getPotionId(string);
            int k = CustomColors.parseColor(s1);
            if (j >= 0 && j < aint.length && k >= 0) {
                aint[j] = k;
                ++i;
                continue;
            }
            CustomColors.warn("Invalid color: " + string + " = " + s1);
        }
        if (i <= 0) {
            return null;
        }
        CustomColors.dbg(String.valueOf(logName) + " colors: " + i);
        return aint;
    }

    private static int getMaxPotionId() {
        int i = 0;
        for (ResourceLocation resourcelocation : Registry.MOB_EFFECT.keySet()) {
            MobEffect mobeffect = PotionUtils.getPotion(resourcelocation);
            int j = MobEffect.getId(mobeffect);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    private static int getPotionId(String name) {
        if (name.equals("potion.water")) {
            return 0;
        }
        name = StrUtils.replacePrefix(name, "potion.", "effect.");
        String s = StrUtils.replacePrefix(name, "effect.", "effect.minecraft.");
        for (ResourceLocation resourcelocation : Registry.MOB_EFFECT.keySet()) {
            MobEffect mobeffect = PotionUtils.getPotion(resourcelocation);
            if (mobeffect.getDescriptionId().equals(name)) {
                return MobEffect.getId(mobeffect);
            }
            if (!mobeffect.getDescriptionId().equals(s)) continue;
            return MobEffect.getId(mobeffect);
        }
        return -1;
    }

    public static int getPotionColor(MobEffect potion, int color) {
        int i = 0;
        if (potion != null) {
            i = MobEffect.getId(potion);
        }
        return CustomColors.getPotionColor(i, color);
    }

    public static int getPotionColor(int potionId, int color) {
        if (potionColors == null) {
            return color;
        }
        if (potionId >= 0 && potionId < potionColors.length) {
            int i = potionColors[potionId];
            return i < 0 ? color : i;
        }
        return color;
    }

    private static int getMapColorIndex(String name) {
        if (name == null) {
            return -1;
        }
        if (name.equals("air")) {
            return MaterialColor.NONE.id;
        }
        if (name.equals("grass")) {
            return MaterialColor.GRASS.id;
        }
        if (name.equals("sand")) {
            return MaterialColor.SAND.id;
        }
        if (name.equals("cloth")) {
            return MaterialColor.WOOL.id;
        }
        if (name.equals("tnt")) {
            return MaterialColor.FIRE.id;
        }
        if (name.equals("ice")) {
            return MaterialColor.ICE.id;
        }
        if (name.equals("iron")) {
            return MaterialColor.METAL.id;
        }
        if (name.equals("foliage")) {
            return MaterialColor.PLANT.id;
        }
        if (name.equals("clay")) {
            return MaterialColor.CLAY.id;
        }
        if (name.equals("dirt")) {
            return MaterialColor.DIRT.id;
        }
        if (name.equals("stone")) {
            return MaterialColor.STONE.id;
        }
        if (name.equals("water")) {
            return MaterialColor.WATER.id;
        }
        if (name.equals("wood")) {
            return MaterialColor.WOOD.id;
        }
        if (name.equals("quartz")) {
            return MaterialColor.QUARTZ.id;
        }
        if (name.equals("gold")) {
            return MaterialColor.GOLD.id;
        }
        if (name.equals("diamond")) {
            return MaterialColor.DIAMOND.id;
        }
        if (name.equals("lapis")) {
            return MaterialColor.LAPIS.id;
        }
        if (name.equals("emerald")) {
            return MaterialColor.EMERALD.id;
        }
        if (name.equals("obsidian")) {
            return MaterialColor.PODZOL.id;
        }
        if (name.equals("netherrack")) {
            return MaterialColor.NETHER.id;
        }
        if (!name.equals("snow") && !name.equals("white")) {
            if (!name.equals("adobe") && !name.equals("orange")) {
                if (name.equals("magenta")) {
                    return MaterialColor.COLOR_MAGENTA.id;
                }
                if (!name.equals("light_blue") && !name.equals("lightBlue")) {
                    if (name.equals("yellow")) {
                        return MaterialColor.COLOR_YELLOW.id;
                    }
                    if (name.equals("lime")) {
                        return MaterialColor.COLOR_LIGHT_GREEN.id;
                    }
                    if (name.equals("pink")) {
                        return MaterialColor.COLOR_PINK.id;
                    }
                    if (name.equals("gray")) {
                        return MaterialColor.COLOR_GRAY.id;
                    }
                    if (!name.equals("silver") && !name.equals("light_gray")) {
                        if (name.equals("cyan")) {
                            return MaterialColor.COLOR_CYAN.id;
                        }
                        if (name.equals("purple")) {
                            return MaterialColor.COLOR_PURPLE.id;
                        }
                        if (name.equals("blue")) {
                            return MaterialColor.COLOR_BLUE.id;
                        }
                        if (name.equals("brown")) {
                            return MaterialColor.COLOR_BROWN.id;
                        }
                        if (name.equals("green")) {
                            return MaterialColor.COLOR_GREEN.id;
                        }
                        if (name.equals("red")) {
                            return MaterialColor.COLOR_RED.id;
                        }
                        if (name.equals("black")) {
                            return MaterialColor.COLOR_BLACK.id;
                        }
                        if (name.equals("white_terracotta")) {
                            return MaterialColor.TERRACOTTA_WHITE.id;
                        }
                        if (name.equals("orange_terracotta")) {
                            return MaterialColor.TERRACOTTA_ORANGE.id;
                        }
                        if (name.equals("magenta_terracotta")) {
                            return MaterialColor.TERRACOTTA_MAGENTA.id;
                        }
                        if (name.equals("light_blue_terracotta")) {
                            return MaterialColor.TERRACOTTA_LIGHT_BLUE.id;
                        }
                        if (name.equals("yellow_terracotta")) {
                            return MaterialColor.TERRACOTTA_YELLOW.id;
                        }
                        if (name.equals("lime_terracotta")) {
                            return MaterialColor.TERRACOTTA_LIGHT_GREEN.id;
                        }
                        if (name.equals("pink_terracotta")) {
                            return MaterialColor.TERRACOTTA_PINK.id;
                        }
                        if (name.equals("gray_terracotta")) {
                            return MaterialColor.TERRACOTTA_GRAY.id;
                        }
                        if (name.equals("light_gray_terracotta")) {
                            return MaterialColor.TERRACOTTA_LIGHT_GRAY.id;
                        }
                        if (name.equals("cyan_terracotta")) {
                            return MaterialColor.TERRACOTTA_CYAN.id;
                        }
                        if (name.equals("purple_terracotta")) {
                            return MaterialColor.TERRACOTTA_PURPLE.id;
                        }
                        if (name.equals("blue_terracotta")) {
                            return MaterialColor.TERRACOTTA_BLUE.id;
                        }
                        if (name.equals("brown_terracotta")) {
                            return MaterialColor.TERRACOTTA_BROWN.id;
                        }
                        if (name.equals("green_terracotta")) {
                            return MaterialColor.TERRACOTTA_GREEN.id;
                        }
                        if (name.equals("red_terracotta")) {
                            return MaterialColor.TERRACOTTA_RED.id;
                        }
                        if (name.equals("black_terracotta")) {
                            return MaterialColor.TERRACOTTA_BLACK.id;
                        }
                        if (name.equals("crimson_nylium")) {
                            return MaterialColor.CRIMSON_NYLIUM.id;
                        }
                        if (name.equals("crimson_stem")) {
                            return MaterialColor.CRIMSON_STEM.id;
                        }
                        if (name.equals("crimson_hyphae")) {
                            return MaterialColor.CRIMSON_HYPHAE.id;
                        }
                        if (name.equals("warped_nylium")) {
                            return MaterialColor.WARPED_NYLIUM.id;
                        }
                        if (name.equals("warped_stem")) {
                            return MaterialColor.WARPED_STEM.id;
                        }
                        if (name.equals("warped_hyphae")) {
                            return MaterialColor.WARPED_HYPHAE.id;
                        }
                        return name.equals("warped_wart_block") ? MaterialColor.WARPED_WART_BLOCK.id : -1;
                    }
                    return MaterialColor.COLOR_LIGHT_GRAY.id;
                }
                return MaterialColor.COLOR_LIGHT_BLUE.id;
            }
            return MaterialColor.COLOR_ORANGE.id;
        }
        return MaterialColor.SNOW.id;
    }

    private static int[] getMapColors() {
        MaterialColor[] amaterialcolor = MaterialColor.MATERIAL_COLORS;
        int[] aint = new int[amaterialcolor.length];
        Arrays.fill(aint, -1);
        int i = 0;
        while (i < amaterialcolor.length && i < aint.length) {
            MaterialColor materialcolor = amaterialcolor[i];
            if (materialcolor != null) {
                aint[i] = materialcolor.col;
            }
            ++i;
        }
        return aint;
    }

    private static void setMapColors(int[] colors) {
        if (colors != null) {
            MaterialColor[] amaterialcolor = MaterialColor.MATERIAL_COLORS;
            int i = 0;
            while (i < amaterialcolor.length && i < colors.length) {
                int j;
                MaterialColor materialcolor = amaterialcolor[i];
                if (materialcolor != null && (j = colors[i]) >= 0 && materialcolor.col != j) {
                    materialcolor.col = j;
                }
                ++i;
            }
        }
    }

    private static float[][] getDyeColors() {
        DyeColor[] adyecolor = DyeColor.values();
        float[][] afloat = new float[adyecolor.length][];
        int i = 0;
        while (i < adyecolor.length && i < afloat.length) {
            DyeColor dyecolor = adyecolor[i];
            if (dyecolor != null) {
                afloat[i] = dyecolor.getTextureDiffuseColors();
            }
            ++i;
        }
        return afloat;
    }

    private static void setDyeColors(float[][] colors) {
        if (colors != null) {
            DyeColor[] adyecolor = DyeColor.values();
            int i = 0;
            while (i < adyecolor.length && i < colors.length) {
                float[] afloat;
                DyeColor dyecolor = adyecolor[i];
                if (dyecolor != null && (afloat = colors[i]) != null && !dyecolor.getTextureDiffuseColors().equals(afloat)) {
                    dyecolor.setColorComponentValues(afloat);
                }
                ++i;
            }
        }
    }

    private static void dbg(String str) {
        Config.dbg("CustomColors: " + str);
    }

    private static void warn(String str) {
        Config.warn("CustomColors: " + str);
    }

    public static int getExpBarTextColor(int color) {
        return expBarTextColor < 0 ? color : expBarTextColor;
    }

    public static int getBossTextColor(int color) {
        return bossTextColor < 0 ? color : bossTextColor;
    }

    public static int getSignTextColor(int color) {
        if (color != 0) {
            return color;
        }
        return signTextColor < 0 ? color : signTextColor;
    }

    public static interface IColorizer {
        public int getColor(BlockState var1, BlockAndTintGetter var2, BlockPos var3);

        public boolean isColorConstant();
    }
}

