/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.BeaconScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.DispenserScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.gui.screens.inventory.FurnaceScreen;
import net.minecraft.client.gui.screens.inventory.HopperScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.optifine.Config;
import net.optifine.CustomGuiProperties;
import net.optifine.override.PlayerControllerOF;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;

public class CustomGuis {
    private static Minecraft mc = Config.getMinecraft();
    private static PlayerControllerOF playerControllerOF = null;
    private static CustomGuiProperties[][] guiProperties = null;
    public static boolean isChristmas = CustomGuis.isChristmas();

    public static ResourceLocation getTextureLocation(ResourceLocation loc) {
        if (guiProperties == null) {
            return loc;
        }
        Screen screen = CustomGuis.mc.screen;
        if (!(screen instanceof AbstractContainerScreen)) {
            return loc;
        }
        if (loc.getNamespace().equals("minecraft") && loc.getPath().startsWith("textures/gui/")) {
            Entity entity;
            if (playerControllerOF == null) {
                return loc;
            }
            ClientLevel levelreader = CustomGuis.mc.level;
            if (levelreader == null) {
                return loc;
            }
            if (screen instanceof CreativeModeInventoryScreen) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CREATIVE, CustomGuis.mc.player.blockPosition(), levelreader, loc, screen);
            }
            if (screen instanceof InventoryScreen) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.INVENTORY, CustomGuis.mc.player.blockPosition(), levelreader, loc, screen);
            }
            BlockPos blockpos = playerControllerOF.getLastClickBlockPos();
            if (blockpos != null) {
                if (screen instanceof AnvilScreen) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ANVIL, blockpos, levelreader, loc, screen);
                }
                if (screen instanceof BeaconScreen) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BEACON, blockpos, levelreader, loc, screen);
                }
                if (screen instanceof BrewingStandScreen) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BREWING_STAND, blockpos, levelreader, loc, screen);
                }
                if (screen instanceof ContainerScreen) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CHEST, blockpos, levelreader, loc, screen);
                }
                if (screen instanceof CraftingScreen) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CRAFTING, blockpos, levelreader, loc, screen);
                }
                if (screen instanceof DispenserScreen) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.DISPENSER, blockpos, levelreader, loc, screen);
                }
                if (screen instanceof EnchantmentScreen) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ENCHANTMENT, blockpos, levelreader, loc, screen);
                }
                if (screen instanceof FurnaceScreen) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.FURNACE, blockpos, levelreader, loc, screen);
                }
                if (screen instanceof HopperScreen) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.HOPPER, blockpos, levelreader, loc, screen);
                }
                if (screen instanceof ShulkerBoxScreen) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.SHULKER_BOX, blockpos, levelreader, loc, screen);
                }
            }
            if ((entity = playerControllerOF.getLastClickEntity()) != null) {
                if (screen instanceof HorseInventoryScreen) {
                    return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.HORSE, entity, levelreader, loc);
                }
                if (screen instanceof MerchantScreen) {
                    return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.VILLAGER, entity, levelreader, loc);
                }
            }
            return loc;
        }
        return loc;
    }

    private static ResourceLocation getTexturePos(CustomGuiProperties.EnumContainer container, BlockPos pos, LevelReader blockAccess, ResourceLocation loc, Screen screen) {
        CustomGuiProperties[] acustomguiproperties = guiProperties[container.ordinal()];
        if (acustomguiproperties == null) {
            return loc;
        }
        int i = 0;
        while (i < acustomguiproperties.length) {
            CustomGuiProperties customguiproperties = acustomguiproperties[i];
            if (customguiproperties.matchesPos(container, pos, blockAccess, screen)) {
                return customguiproperties.getTextureLocation(loc);
            }
            ++i;
        }
        return loc;
    }

    private static ResourceLocation getTextureEntity(CustomGuiProperties.EnumContainer container, Entity entity, LevelReader blockAccess, ResourceLocation loc) {
        CustomGuiProperties[] acustomguiproperties = guiProperties[container.ordinal()];
        if (acustomguiproperties == null) {
            return loc;
        }
        int i = 0;
        while (i < acustomguiproperties.length) {
            CustomGuiProperties customguiproperties = acustomguiproperties[i];
            if (customguiproperties.matchesEntity(container, entity, blockAccess)) {
                return customguiproperties.getTextureLocation(loc);
            }
            ++i;
        }
        return loc;
    }

    public static void update() {
        guiProperties = null;
        if (Config.isCustomGuis()) {
            ArrayList<List<CustomGuiProperties>> list = new ArrayList<List<CustomGuiProperties>>();
            PackResources[] apackresources = Config.getResourcePacks();
            int i = apackresources.length - 1;
            while (i >= 0) {
                PackResources packresources = apackresources[i];
                CustomGuis.update(packresources, list);
                --i;
            }
            guiProperties = CustomGuis.propertyListToArray(list);
        }
    }

    private static CustomGuiProperties[][] propertyListToArray(List<List<CustomGuiProperties>> listProps) {
        if (listProps.isEmpty()) {
            return null;
        }
        CustomGuiProperties[][] acustomguiproperties = new CustomGuiProperties[CustomGuiProperties.EnumContainer.values().length][];
        int i = 0;
        while (i < acustomguiproperties.length) {
            List<CustomGuiProperties> list;
            if (listProps.size() > i && (list = listProps.get(i)) != null) {
                CustomGuiProperties[] acustomguiproperties1 = list.toArray(new CustomGuiProperties[list.size()]);
                acustomguiproperties[i] = acustomguiproperties1;
            }
            ++i;
        }
        return acustomguiproperties;
    }

    private static void update(PackResources rp, List<List<CustomGuiProperties>> listProps) {
        Object[] astring = ResUtils.collectFiles(rp, "optifine/gui/container/", ".properties", null);
        Arrays.sort(astring);
        int i = 0;
        while (i < astring.length) {
            Object s = astring[i];
            Config.dbg("CustomGuis: " + (String)s);
            try {
                ResourceLocation resourcelocation = new ResourceLocation((String)s);
                InputStream inputstream = rp.getResource(PackType.CLIENT_RESOURCES, resourcelocation);
                if (inputstream == null) {
                    Config.warn("CustomGuis file not found: " + (String)s);
                } else {
                    PropertiesOrdered properties = new PropertiesOrdered();
                    properties.load(inputstream);
                    inputstream.close();
                    CustomGuiProperties customguiproperties = new CustomGuiProperties(properties, (String)s);
                    if (customguiproperties.isValid((String)s)) {
                        CustomGuis.addToList(customguiproperties, listProps);
                    }
                }
            }
            catch (FileNotFoundException filenotfoundexception) {
                Config.warn("CustomGuis file not found: " + (String)s);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++i;
        }
    }

    private static void addToList(CustomGuiProperties cgp, List<List<CustomGuiProperties>> listProps) {
        if (cgp.getContainer() == null) {
            CustomGuis.warn("Invalid container: " + (Object)((Object)cgp.getContainer()));
        } else {
            int i = cgp.getContainer().ordinal();
            while (listProps.size() <= i) {
                listProps.add(null);
            }
            List<CustomGuiProperties> list = listProps.get(i);
            if (list == null) {
                list = new ArrayList<CustomGuiProperties>();
                listProps.set(i, list);
            }
            list.add(cgp);
        }
    }

    public static PlayerControllerOF getPlayerControllerOF() {
        return playerControllerOF;
    }

    public static void setPlayerControllerOF(PlayerControllerOF playerControllerOF) {
        CustomGuis.playerControllerOF = playerControllerOF;
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }
}

