/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.optifine.Config;
import net.optifine.CustomItemProperties;
import net.optifine.CustomItemsComparator;
import net.optifine.config.NbtTagValue;
import net.optifine.shaders.Shaders;
import net.optifine.util.EnchantmentUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

public class CustomItems {
    private static CustomItemProperties[][] itemProperties = null;
    private static CustomItemProperties[][] enchantmentProperties = null;
    private static Map mapPotionIds = null;
    private static ItemModelGenerator itemModelGenerator = new ItemModelGenerator();
    private static boolean useGlint = true;
    private static boolean renderOffHand = false;
    public static final int MASK_POTION_SPLASH = 16384;
    public static final int MASK_POTION_NAME = 63;
    public static final int MASK_POTION_EXTENDED = 64;
    public static final String KEY_TEXTURE_OVERLAY = "texture.potion_overlay";
    public static final String KEY_TEXTURE_SPLASH = "texture.potion_bottle_splash";
    public static final String KEY_TEXTURE_DRINKABLE = "texture.potion_bottle_drinkable";
    public static final String DEFAULT_TEXTURE_OVERLAY = "item/potion_overlay";
    public static final String DEFAULT_TEXTURE_SPLASH = "item/potion_bottle_splash";
    public static final String DEFAULT_TEXTURE_DRINKABLE = "item/potion_bottle_drinkable";
    private static final int[][] EMPTY_INT2_ARRAY = new int[0][];
    private static final Map<String, Integer> mapPotionDamages = CustomItems.makeMapPotionDamages();
    private static final String TYPE_POTION_NORMAL = "normal";
    private static final String TYPE_POTION_SPLASH = "splash";
    private static final String TYPE_POTION_LINGER = "linger";

    public static void update() {
        itemProperties = null;
        enchantmentProperties = null;
        useGlint = true;
        if (Config.isCustomItems()) {
            CustomItems.readCitProperties("optifine/cit.properties");
            PackResources[] apackresources = Config.getResourcePacks();
            int i = apackresources.length - 1;
            while (i >= 0) {
                PackResources packresources = apackresources[i];
                CustomItems.update(packresources);
                --i;
            }
            CustomItems.update(Config.getDefaultResourcePack());
            if (itemProperties.length <= 0) {
                itemProperties = null;
            }
            if (enchantmentProperties.length <= 0) {
                enchantmentProperties = null;
            }
        }
    }

    private static void readCitProperties(String fileName) {
        try {
            ResourceLocation resourcelocation = new ResourceLocation(fileName);
            InputStream inputstream = Config.getResourceStream(resourcelocation);
            if (inputstream == null) {
                return;
            }
            Config.dbg("CustomItems: Loading " + fileName);
            PropertiesOrdered properties = new PropertiesOrdered();
            properties.load(inputstream);
            inputstream.close();
            useGlint = Config.parseBoolean(properties.getProperty("useGlint"), true);
        }
        catch (FileNotFoundException filenotfoundexception) {
            return;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void update(PackResources rp) {
        Object[] astring = ResUtils.collectFiles(rp, "optifine/cit/", ".properties", null);
        Map<String, CustomItemProperties> map = CustomItems.makeAutoImageProperties(rp);
        if (map.size() > 0) {
            Set<String> set = map.keySet();
            Object[] astring1 = set.toArray(new String[set.size()]);
            astring = (String[])Config.addObjectsToArray(astring, astring1);
        }
        Arrays.sort(astring);
        List<List<CustomItemProperties>> list = CustomItems.makePropertyList(itemProperties);
        List<List<CustomItemProperties>> list1 = CustomItems.makePropertyList(enchantmentProperties);
        int i = 0;
        while (i < astring.length) {
            block13: {
                Object s = astring[i];
                Config.dbg("CustomItems: " + (String)s);
                try {
                    CustomItemProperties customitemproperties = null;
                    if (map.containsKey(s)) {
                        customitemproperties = map.get(s);
                    }
                    if (customitemproperties == null) {
                        ResourceLocation resourcelocation = new ResourceLocation((String)s);
                        InputStream inputstream = rp.getResource(PackType.CLIENT_RESOURCES, resourcelocation);
                        if (inputstream == null) {
                            Config.warn("CustomItems file not found: " + (String)s);
                            break block13;
                        }
                        PropertiesOrdered properties = new PropertiesOrdered();
                        properties.load(inputstream);
                        inputstream.close();
                        customitemproperties = new CustomItemProperties(properties, (String)s);
                    }
                    if (customitemproperties.isValid((String)s)) {
                        CustomItems.addToItemList(customitemproperties, list);
                        CustomItems.addToEnchantmentList(customitemproperties, list1);
                    }
                }
                catch (FileNotFoundException filenotfoundexception) {
                    Config.warn("CustomItems file not found: " + (String)s);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++i;
        }
        itemProperties = CustomItems.propertyListToArray(list);
        enchantmentProperties = CustomItems.propertyListToArray(list1);
        Comparator comparator = CustomItems.getPropertiesComparator();
        int j = 0;
        while (j < itemProperties.length) {
            CustomItemProperties[] acustomitemproperties = itemProperties[j];
            if (acustomitemproperties != null) {
                Arrays.sort(acustomitemproperties, comparator);
            }
            ++j;
        }
        int k = 0;
        while (k < enchantmentProperties.length) {
            CustomItemProperties[] acustomitemproperties1 = enchantmentProperties[k];
            if (acustomitemproperties1 != null) {
                Arrays.sort(acustomitemproperties1, comparator);
            }
            ++k;
        }
    }

    private static Comparator getPropertiesComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                CustomItemProperties customitemproperties = (CustomItemProperties)o1;
                CustomItemProperties customitemproperties1 = (CustomItemProperties)o2;
                if (customitemproperties.layer != customitemproperties1.layer) {
                    return customitemproperties.layer - customitemproperties1.layer;
                }
                if (customitemproperties.weight != customitemproperties1.weight) {
                    return customitemproperties1.weight - customitemproperties.weight;
                }
                return !customitemproperties.basePath.equals(customitemproperties1.basePath) ? customitemproperties.basePath.compareTo(customitemproperties1.basePath) : customitemproperties.name.compareTo(customitemproperties1.name);
            }
        };
    }

    public static void updateIcons(TextureAtlas textureMap) {
        for (CustomItemProperties customitemproperties : CustomItems.getAllProperties()) {
            customitemproperties.updateIcons(textureMap);
        }
    }

    public static void refreshIcons(TextureAtlas textureMap) {
        for (CustomItemProperties customitemproperties : CustomItems.getAllProperties()) {
            customitemproperties.refreshIcons(textureMap);
        }
    }

    public static void loadModels(ModelBakery modelBakery) {
        for (CustomItemProperties customitemproperties : CustomItems.getAllProperties()) {
            customitemproperties.loadModels(modelBakery);
        }
    }

    public static void updateModels() {
        for (CustomItemProperties customitemproperties : CustomItems.getAllProperties()) {
            if (customitemproperties.type != 1) continue;
            TextureAtlas textureatlas = Config.getTextureMap();
            customitemproperties.updateModelTexture(textureatlas, itemModelGenerator);
            customitemproperties.updateModelsFull();
        }
    }

    private static List<CustomItemProperties> getAllProperties() {
        ArrayList<CustomItemProperties> list = new ArrayList<CustomItemProperties>();
        CustomItems.addAll(itemProperties, list);
        CustomItems.addAll(enchantmentProperties, list);
        return list;
    }

    private static void addAll(CustomItemProperties[][] cipsArr, List<CustomItemProperties> list) {
        if (cipsArr != null) {
            int i = 0;
            while (i < cipsArr.length) {
                CustomItemProperties[] acustomitemproperties = cipsArr[i];
                if (acustomitemproperties != null) {
                    int j = 0;
                    while (j < acustomitemproperties.length) {
                        CustomItemProperties customitemproperties = acustomitemproperties[j];
                        if (customitemproperties != null) {
                            list.add(customitemproperties);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private static Map<String, CustomItemProperties> makeAutoImageProperties(PackResources rp) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        map.putAll(CustomItems.makePotionImageProperties(rp, TYPE_POTION_NORMAL, Registry.ITEM.getKey(Items.POTION)));
        map.putAll(CustomItems.makePotionImageProperties(rp, TYPE_POTION_SPLASH, Registry.ITEM.getKey(Items.SPLASH_POTION)));
        map.putAll(CustomItems.makePotionImageProperties(rp, TYPE_POTION_LINGER, Registry.ITEM.getKey(Items.LINGERING_POTION)));
        return map;
    }

    private static Map<String, CustomItemProperties> makePotionImageProperties(PackResources rp, String type, ResourceLocation itemId) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        String s = String.valueOf(type) + "/";
        String[] astring = new String[]{"optifine/cit/potion/" + s, "optifine/cit/Potion/" + s};
        String[] astring1 = new String[]{".png"};
        String[] astring2 = ResUtils.collectFiles(rp, astring, astring1);
        int i = 0;
        while (i < astring2.length) {
            String s1 = astring2[i];
            String name = StrUtils.removePrefixSuffix(s1, astring, astring1);
            Properties properties = CustomItems.makePotionProperties(name, type, itemId, s1);
            if (properties != null) {
                String s3 = String.valueOf(StrUtils.removeSuffix(s1, astring1)) + ".properties";
                CustomItemProperties customitemproperties = new CustomItemProperties(properties, s3);
                map.put(s3, customitemproperties);
            }
            ++i;
        }
        return map;
    }

    private static Properties makePotionProperties(String name, String type, ResourceLocation itemId, String path) {
        if (StrUtils.endsWith(name, new String[]{"_n", "_s"})) {
            return null;
        }
        if (name.equals("empty") && type.equals(TYPE_POTION_NORMAL)) {
            itemId = Registry.ITEM.getKey(Items.GLASS_BOTTLE);
            PropertiesOrdered properties = new PropertiesOrdered();
            ((Properties)properties).put("type", "item");
            ((Properties)properties).put("items", itemId.toString());
            return properties;
        }
        int[] aint = (int[])CustomItems.getMapPotionIds().get(name);
        if (aint == null) {
            Config.warn("Potion not found for image: " + path);
            return null;
        }
        StringBuffer stringbuffer = new StringBuffer();
        int i = 0;
        while (i < aint.length) {
            int j = aint[i];
            if (type.equals(TYPE_POTION_SPLASH)) {
                j |= 0x4000;
            }
            if (i > 0) {
                stringbuffer.append(" ");
            }
            stringbuffer.append(j);
            ++i;
        }
        int k = 16447;
        if (name.equals("water") || name.equals("mundane")) {
            k |= 0x40;
        }
        PropertiesOrdered properties1 = new PropertiesOrdered();
        ((Properties)properties1).put("type", "item");
        ((Properties)properties1).put("items", itemId.toString());
        ((Properties)properties1).put("damage", stringbuffer.toString());
        ((Properties)properties1).put("damageMask", "" + k);
        if (type.equals(TYPE_POTION_SPLASH)) {
            ((Properties)properties1).put(KEY_TEXTURE_SPLASH, name);
        } else {
            ((Properties)properties1).put(KEY_TEXTURE_DRINKABLE, name);
        }
        return properties1;
    }

    private static Map getMapPotionIds() {
        if (mapPotionIds == null) {
            mapPotionIds = new LinkedHashMap();
            mapPotionIds.put("water", CustomItems.getPotionId(0, 0));
            mapPotionIds.put("awkward", CustomItems.getPotionId(0, 1));
            mapPotionIds.put("thick", CustomItems.getPotionId(0, 2));
            mapPotionIds.put("potent", CustomItems.getPotionId(0, 3));
            mapPotionIds.put("regeneration", CustomItems.getPotionIds(1));
            mapPotionIds.put("movespeed", CustomItems.getPotionIds(2));
            mapPotionIds.put("fireresistance", CustomItems.getPotionIds(3));
            mapPotionIds.put("poison", CustomItems.getPotionIds(4));
            mapPotionIds.put("heal", CustomItems.getPotionIds(5));
            mapPotionIds.put("nightvision", CustomItems.getPotionIds(6));
            mapPotionIds.put("clear", CustomItems.getPotionId(7, 0));
            mapPotionIds.put("bungling", CustomItems.getPotionId(7, 1));
            mapPotionIds.put("charming", CustomItems.getPotionId(7, 2));
            mapPotionIds.put("rank", CustomItems.getPotionId(7, 3));
            mapPotionIds.put("weakness", CustomItems.getPotionIds(8));
            mapPotionIds.put("damageboost", CustomItems.getPotionIds(9));
            mapPotionIds.put("moveslowdown", CustomItems.getPotionIds(10));
            mapPotionIds.put("leaping", CustomItems.getPotionIds(11));
            mapPotionIds.put("harm", CustomItems.getPotionIds(12));
            mapPotionIds.put("waterbreathing", CustomItems.getPotionIds(13));
            mapPotionIds.put("invisibility", CustomItems.getPotionIds(14));
            mapPotionIds.put("thin", CustomItems.getPotionId(15, 0));
            mapPotionIds.put("debonair", CustomItems.getPotionId(15, 1));
            mapPotionIds.put("sparkling", CustomItems.getPotionId(15, 2));
            mapPotionIds.put("stinky", CustomItems.getPotionId(15, 3));
            mapPotionIds.put("mundane", CustomItems.getPotionId(0, 4));
            mapPotionIds.put("speed", mapPotionIds.get("movespeed"));
            mapPotionIds.put("fire_resistance", mapPotionIds.get("fireresistance"));
            mapPotionIds.put("instant_health", mapPotionIds.get("heal"));
            mapPotionIds.put("night_vision", mapPotionIds.get("nightvision"));
            mapPotionIds.put("strength", mapPotionIds.get("damageboost"));
            mapPotionIds.put("slowness", mapPotionIds.get("moveslowdown"));
            mapPotionIds.put("instant_damage", mapPotionIds.get("harm"));
            mapPotionIds.put("water_breathing", mapPotionIds.get("waterbreathing"));
        }
        return mapPotionIds;
    }

    private static int[] getPotionIds(int baseId) {
        return new int[]{baseId, baseId + 16, baseId + 32, baseId + 48};
    }

    private static int[] getPotionId(int baseId, int subId) {
        return new int[]{baseId + subId * 16};
    }

    private static int getPotionNameDamage(String name) {
        String s = "effect." + name;
        for (ResourceLocation resourcelocation : Registry.MOB_EFFECT.keySet()) {
            MobEffect mobeffect;
            String s1;
            if (!Registry.MOB_EFFECT.containsKey(resourcelocation) || !s.equals(s1 = (mobeffect = Registry.MOB_EFFECT.get(resourcelocation)).getDescriptionId())) continue;
            return MobEffect.getId(mobeffect);
        }
        return -1;
    }

    private static List<List<CustomItemProperties>> makePropertyList(CustomItemProperties[][] propsArr) {
        ArrayList<List<CustomItemProperties>> list = new ArrayList<List<CustomItemProperties>>();
        if (propsArr != null) {
            int i = 0;
            while (i < propsArr.length) {
                CustomItemProperties[] acustomitemproperties = propsArr[i];
                ArrayList<CustomItemProperties> list1 = null;
                if (acustomitemproperties != null) {
                    list1 = new ArrayList<CustomItemProperties>(Arrays.asList(acustomitemproperties));
                }
                list.add(list1);
                ++i;
            }
        }
        return list;
    }

    private static CustomItemProperties[][] propertyListToArray(List list) {
        CustomItemProperties[][] acustomitemproperties = new CustomItemProperties[list.size()][];
        int i = 0;
        while (i < list.size()) {
            List lista = (List)list.get(i);
            if (lista != null) {
                CustomItemProperties[] acustomitemproperties1 = lista.toArray(new CustomItemProperties[lista.size()]);
                Arrays.sort(acustomitemproperties1, new CustomItemsComparator());
                acustomitemproperties[i] = acustomitemproperties1;
            }
            ++i;
        }
        return acustomitemproperties;
    }

    private static void addToItemList(CustomItemProperties cp, List<List<CustomItemProperties>> itemList) {
        if (cp.items != null) {
            int i = 0;
            while (i < cp.items.length) {
                int j = cp.items[i];
                if (j <= 0) {
                    Config.warn("Invalid item ID: " + j);
                } else {
                    CustomItems.addToList(cp, itemList, j);
                }
                ++i;
            }
        }
    }

    private static void addToEnchantmentList(CustomItemProperties cp, List<List<CustomItemProperties>> enchantmentList) {
        if (cp.type == 2 && cp.enchantmentIds != null) {
            int i = CustomItems.getMaxEnchantmentId() + 1;
            int j = 0;
            while (j < i) {
                if (Config.equalsOne(j, cp.enchantmentIds)) {
                    CustomItems.addToList(cp, enchantmentList, j);
                }
                ++j;
            }
        }
    }

    private static int getMaxEnchantmentId() {
        int i = 0;
        Enchantment enchantment;
        while ((enchantment = (Enchantment)Registry.ENCHANTMENT.byId(i)) != null) {
            ++i;
        }
        return i;
    }

    private static void addToList(CustomItemProperties cp, List<List<CustomItemProperties>> list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        List<CustomItemProperties> lista = list.get(id);
        if (lista == null) {
            lista = new ArrayList<CustomItemProperties>();
            list.set(id, lista);
        }
        lista.add(cp);
    }

    public static BakedModel getCustomItemModel(ItemStack itemStack, BakedModel model, ResourceLocation modelLocation, boolean fullModel) {
        if (!fullModel && model.isGui3d()) {
            return model;
        }
        if (itemProperties == null) {
            return model;
        }
        CustomItemProperties customitemproperties = CustomItems.getCustomItemProperties(itemStack, 1);
        if (customitemproperties == null) {
            return model;
        }
        BakedModel bakedmodel = customitemproperties.getBakedModel(modelLocation, fullModel);
        return bakedmodel != null ? bakedmodel : model;
    }

    public static ResourceLocation getCustomArmorTexture(ItemStack itemStack, EquipmentSlot slot, String overlay, ResourceLocation locArmor) {
        if (itemProperties == null) {
            return locArmor;
        }
        ResourceLocation resourcelocation = CustomItems.getCustomArmorLocation(itemStack, slot, overlay);
        return resourcelocation == null ? locArmor : resourcelocation;
    }

    private static ResourceLocation getCustomArmorLocation(ItemStack itemStack, EquipmentSlot slot, String overlay) {
        String s1;
        ResourceLocation resourcelocation;
        CustomItemProperties customitemproperties = CustomItems.getCustomItemProperties(itemStack, 3);
        if (customitemproperties == null) {
            return null;
        }
        if (customitemproperties.mapTextureLocations == null) {
            return customitemproperties.textureLocation;
        }
        Item item = itemStack.getItem();
        if (!(item instanceof ArmorItem)) {
            return null;
        }
        ArmorItem armoritem = (ArmorItem)item;
        String s = armoritem.getMaterial().getName();
        int i = slot == EquipmentSlot.LEGS ? 2 : 1;
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("texture.");
        stringbuffer.append(s);
        stringbuffer.append("_layer_");
        stringbuffer.append(i);
        if (overlay != null) {
            stringbuffer.append("_");
            stringbuffer.append(overlay);
        }
        return (resourcelocation = (ResourceLocation)customitemproperties.mapTextureLocations.get(s1 = stringbuffer.toString())) == null ? customitemproperties.textureLocation : resourcelocation;
    }

    public static ResourceLocation getCustomElytraTexture(ItemStack itemStack, ResourceLocation locElytra) {
        if (itemProperties == null) {
            return locElytra;
        }
        CustomItemProperties customitemproperties = CustomItems.getCustomItemProperties(itemStack, 4);
        if (customitemproperties == null) {
            return locElytra;
        }
        return customitemproperties.textureLocation == null ? locElytra : customitemproperties.textureLocation;
    }

    private static CustomItemProperties getCustomItemProperties(ItemStack itemStack, int type) {
        CustomItemProperties[] acustomitemproperties1;
        CustomItemProperties[][] acustomitemproperties = itemProperties;
        if (acustomitemproperties == null) {
            return null;
        }
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.getItem();
        int i = Item.getId(item);
        if (i >= 0 && i < acustomitemproperties.length && (acustomitemproperties1 = acustomitemproperties[i]) != null) {
            int j = 0;
            while (j < acustomitemproperties1.length) {
                CustomItemProperties customitemproperties = acustomitemproperties1[j];
                if (customitemproperties.type == type && CustomItems.matchesProperties(customitemproperties, itemStack, null)) {
                    return customitemproperties;
                }
                ++j;
            }
        }
        return null;
    }

    private static boolean matchesProperties(CustomItemProperties cip, ItemStack itemStack, int[][] enchantmentIdLevels) {
        Item item = itemStack.getItem();
        if (cip.damage != null) {
            int i = CustomItems.getItemStackDamage(itemStack);
            if (i < 0) {
                return false;
            }
            if (cip.damageMask != 0) {
                i &= cip.damageMask;
            }
            if (cip.damagePercent) {
                int j = item.getMaxDamage();
                i = (int)((double)(i * 100) / (double)j);
            }
            if (!cip.damage.isInRange(i)) {
                return false;
            }
        }
        if (cip.stackSize != null && !cip.stackSize.isInRange(itemStack.getCount())) {
            return false;
        }
        int[][] aint = enchantmentIdLevels;
        if (cip.enchantmentIds != null) {
            if (enchantmentIdLevels == null) {
                aint = CustomItems.getEnchantmentIdLevels(itemStack);
            }
            boolean flag = false;
            int k = 0;
            while (k < aint.length) {
                int l = aint[k][0];
                if (Config.equalsOne(l, cip.enchantmentIds)) {
                    flag = true;
                    break;
                }
                ++k;
            }
            if (!flag) {
                return false;
            }
        }
        if (cip.enchantmentLevels != null) {
            if (aint == null) {
                aint = CustomItems.getEnchantmentIdLevels(itemStack);
            }
            boolean flag1 = false;
            int i1 = 0;
            while (i1 < aint.length) {
                int k1 = aint[i1][1];
                if (cip.enchantmentLevels.isInRange(k1)) {
                    flag1 = true;
                    break;
                }
                ++i1;
            }
            if (!flag1) {
                return false;
            }
        }
        if (cip.nbtTagValues != null) {
            CompoundTag compoundtag = itemStack.getTag();
            int j1 = 0;
            while (j1 < cip.nbtTagValues.length) {
                NbtTagValue nbttagvalue = cip.nbtTagValues[j1];
                if (!nbttagvalue.matches(compoundtag)) {
                    return false;
                }
                ++j1;
            }
        }
        if (cip.hand != 0) {
            if (cip.hand == 1 && renderOffHand) {
                return false;
            }
            if (cip.hand == 2 && !renderOffHand) {
                return false;
            }
        }
        return true;
    }

    private static int getItemStackDamage(ItemStack itemStack) {
        Item item = itemStack.getItem();
        return item instanceof PotionItem ? CustomItems.getPotionDamage(itemStack) : itemStack.getDamageValue();
    }

    private static int getPotionDamage(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.getTag();
        if (compoundtag == null) {
            return 0;
        }
        String s = compoundtag.getString("Potion");
        if (s != null && !s.equals("")) {
            Integer integer = mapPotionDamages.get(s);
            if (integer == null) {
                return -1;
            }
            int i = integer;
            if (itemStack.getItem() == Items.SPLASH_POTION) {
                i |= 0x4000;
            }
            return i;
        }
        return 0;
    }

    private static Map<String, Integer> makeMapPotionDamages() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        CustomItems.addPotion("water", 0, false, map);
        CustomItems.addPotion("awkward", 16, false, map);
        CustomItems.addPotion("thick", 32, false, map);
        CustomItems.addPotion("mundane", 64, false, map);
        CustomItems.addPotion("regeneration", 1, true, map);
        CustomItems.addPotion("swiftness", 2, true, map);
        CustomItems.addPotion("fire_resistance", 3, true, map);
        CustomItems.addPotion("poison", 4, true, map);
        CustomItems.addPotion("healing", 5, true, map);
        CustomItems.addPotion("night_vision", 6, true, map);
        CustomItems.addPotion("weakness", 8, true, map);
        CustomItems.addPotion("strength", 9, true, map);
        CustomItems.addPotion("slowness", 10, true, map);
        CustomItems.addPotion("leaping", 11, true, map);
        CustomItems.addPotion("harming", 12, true, map);
        CustomItems.addPotion("water_breathing", 13, true, map);
        CustomItems.addPotion("invisibility", 14, true, map);
        return map;
    }

    private static void addPotion(String name, int value, boolean extended, Map<String, Integer> map) {
        if (extended) {
            value |= 0x2000;
        }
        map.put("minecraft:" + name, value);
        if (extended) {
            int i = value | 0x20;
            map.put("minecraft:strong_" + name, i);
            int j = value | 0x40;
            map.put("minecraft:long_" + name, j);
        }
    }

    private static int[][] getEnchantmentIdLevels(ItemStack itemStack) {
        ListTag listtag1;
        Item item = itemStack.getItem();
        if (item == Items.ENCHANTED_BOOK) {
            EnchantedBookItem enchantedbookitem = (EnchantedBookItem)Items.ENCHANTED_BOOK;
            listtag1 = EnchantedBookItem.getEnchantments(itemStack);
        } else {
            listtag1 = itemStack.getEnchantmentTags();
        }
        ListTag listtag = listtag1;
        if (listtag != null && listtag.size() > 0) {
            int[][] aint = new int[listtag.size()][2];
            int i = 0;
            while (i < listtag.size()) {
                CompoundTag compoundtag = listtag.getCompound(i);
                String s = compoundtag.getString("id");
                int j = compoundtag.getInt("lvl");
                Enchantment enchantment = EnchantmentUtils.getEnchantment(s);
                if (enchantment != null) {
                    int k;
                    aint[i][0] = k = Registry.ENCHANTMENT.getId(enchantment);
                    aint[i][1] = j;
                }
                ++i;
            }
            return aint;
        }
        return EMPTY_INT2_ARRAY;
    }

    public static boolean renderCustomEffect(ItemRenderer renderItem, ItemStack itemStack, BakedModel model) {
        CustomItemProperties[][] acustomitemproperties = enchantmentProperties;
        if (acustomitemproperties == null) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] aint = CustomItems.getEnchantmentIdLevels(itemStack);
        if (aint.length <= 0) {
            return false;
        }
        Object set = null;
        return false;
    }

    public static boolean renderCustomArmorEffect(LivingEntity entity, ItemStack itemStack, EntityModel model, float limbSwing, float prevLimbSwing, float partialTicks, float timeLimbSwing, float yaw, float pitch, float scale) {
        CustomItemProperties[][] acustomitemproperties = enchantmentProperties;
        if (acustomitemproperties == null) {
            return false;
        }
        if (Config.isShaders() && Shaders.isShadowPass) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] aint = CustomItems.getEnchantmentIdLevels(itemStack);
        if (aint.length <= 0) {
            return false;
        }
        Object set = null;
        return false;
    }

    public static boolean isUseGlint() {
        return useGlint;
    }

    public static void setRenderOffHand(boolean renderOffHand) {
        CustomItems.renderOffHand = renderOffHand;
    }
}

