/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.optifine.Config;
import net.optifine.render.RenderUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.TextureUtils;

public class EmissiveTextures {
    private static String suffixEmissive = null;
    private static String suffixEmissivePng = null;
    private static boolean active = false;
    private static boolean render = false;
    private static boolean hasEmissive = false;
    private static boolean renderEmissive = false;
    private static final String SUFFIX_PNG = ".png";
    private static final ResourceLocation LOCATION_TEXTURE_EMPTY = TextureUtils.LOCATION_TEXTURE_EMPTY;
    private static final ResourceLocation LOCATION_SPRITE_EMPTY = TextureUtils.LOCATION_SPRITE_EMPTY;
    private static TextureManager textureManager;
    private static int countRecursive;

    static {
        countRecursive = 0;
    }

    public static boolean isActive() {
        return active;
    }

    public static String getSuffixEmissive() {
        return suffixEmissive;
    }

    public static void beginRender() {
        if (render) {
            ++countRecursive;
        } else {
            render = true;
            hasEmissive = false;
        }
    }

    public static ResourceLocation getEmissiveTexture(ResourceLocation locationIn) {
        if (!render) {
            return locationIn;
        }
        AbstractTexture abstracttexture = textureManager.getTexture(locationIn);
        if (abstracttexture instanceof TextureAtlas) {
            return locationIn;
        }
        ResourceLocation resourcelocation = null;
        if (abstracttexture instanceof SimpleTexture) {
            resourcelocation = ((SimpleTexture)abstracttexture).locationEmissive;
        }
        if (!renderEmissive) {
            if (resourcelocation != null) {
                hasEmissive = true;
            }
            return locationIn;
        }
        if (resourcelocation == null) {
            resourcelocation = LOCATION_TEXTURE_EMPTY;
        }
        return resourcelocation;
    }

    public static TextureAtlasSprite getEmissiveSprite(TextureAtlasSprite sprite) {
        if (!render) {
            return sprite;
        }
        TextureAtlasSprite textureatlassprite = sprite.spriteEmissive;
        if (!renderEmissive) {
            if (textureatlassprite != null) {
                hasEmissive = true;
            }
            return sprite;
        }
        if (textureatlassprite == null) {
            textureatlassprite = sprite.atlas().getSprite(LOCATION_SPRITE_EMPTY);
        }
        return textureatlassprite;
    }

    public static BakedQuad getEmissiveQuad(BakedQuad quad) {
        if (!render) {
            return quad;
        }
        BakedQuad bakedquad = quad.getQuadEmissive();
        if (!renderEmissive) {
            if (bakedquad != null) {
                hasEmissive = true;
            }
            return quad;
        }
        return bakedquad;
    }

    public static boolean hasEmissive() {
        return countRecursive > 0 ? false : hasEmissive;
    }

    public static void beginRenderEmissive() {
        renderEmissive = true;
    }

    public static boolean isRenderEmissive() {
        return renderEmissive;
    }

    public static void endRenderEmissive() {
        RenderUtils.flushRenderBuffers();
        renderEmissive = false;
    }

    public static void endRender() {
        if (countRecursive > 0) {
            --countRecursive;
        } else {
            render = false;
            hasEmissive = false;
        }
    }

    public static void update() {
        textureManager = Minecraft.getInstance().getTextureManager();
        active = false;
        suffixEmissive = null;
        suffixEmissivePng = null;
        if (Config.isEmissiveTextures()) {
            try {
                String s = "optifine/emissive.properties";
                ResourceLocation resourcelocation = new ResourceLocation(s);
                InputStream inputstream = Config.getResourceStream(resourcelocation);
                if (inputstream == null) {
                    return;
                }
                EmissiveTextures.dbg("Loading " + s);
                PropertiesOrdered properties = new PropertiesOrdered();
                properties.load(inputstream);
                inputstream.close();
                suffixEmissive = properties.getProperty("suffix.emissive");
                if (suffixEmissive != null) {
                    suffixEmissivePng = String.valueOf(suffixEmissive) + SUFFIX_PNG;
                }
                active = suffixEmissive != null;
            }
            catch (FileNotFoundException filenotfoundexception) {
                return;
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
    }

    public static void updateIcons(TextureAtlas textureMap, Set<ResourceLocation> locations) {
        if (active) {
            for (ResourceLocation resourcelocation : locations) {
                EmissiveTextures.checkEmissive(textureMap, resourcelocation);
            }
        }
    }

    private static void checkEmissive(TextureAtlas textureMap, ResourceLocation locSprite) {
        ResourceLocation resourcelocation;
        ResourceLocation resourcelocation1;
        String s = EmissiveTextures.getSuffixEmissive();
        if (s != null && !locSprite.getPath().endsWith(s) && Config.hasResource(resourcelocation1 = textureMap.getResourceLocation(resourcelocation = new ResourceLocation(locSprite.getNamespace(), String.valueOf(locSprite.getPath()) + s)))) {
            TextureAtlasSprite textureatlassprite = textureMap.registerSprite(locSprite);
            TextureAtlasSprite textureatlassprite1 = textureMap.registerSprite(resourcelocation);
            textureatlassprite1.isSpriteEmissive = true;
            textureatlassprite.spriteEmissive = textureatlassprite1;
            textureMap.registerSprite(LOCATION_SPRITE_EMPTY);
        }
    }

    public static void refreshIcons(TextureAtlas textureMap) {
        for (TextureAtlasSprite textureatlassprite : textureMap.getRegisteredSprites()) {
            EmissiveTextures.refreshIcon(textureatlassprite, textureMap);
        }
    }

    private static void refreshIcon(TextureAtlasSprite sprite, TextureAtlas textureMap) {
        TextureAtlasSprite textureatlassprite1;
        TextureAtlasSprite textureatlassprite;
        if (sprite.spriteEmissive != null && (textureatlassprite = textureMap.getUploadedSprite(sprite.getName())) != null && (textureatlassprite1 = textureMap.getUploadedSprite(sprite.spriteEmissive.getName())) != null) {
            textureatlassprite1.isSpriteEmissive = true;
            textureatlassprite.spriteEmissive = textureatlassprite1;
        }
    }

    private static void dbg(String str) {
        Config.dbg("EmissiveTextures: " + str);
    }

    private static void warn(String str) {
        Config.warn("EmissiveTextures: " + str);
    }

    public static boolean isEmissive(ResourceLocation loc) {
        return suffixEmissivePng == null ? false : loc.getPath().endsWith(suffixEmissivePng);
    }

    public static void loadTexture(ResourceLocation loc, SimpleTexture tex) {
        if (loc != null && tex != null) {
            String s;
            tex.isEmissive = false;
            tex.locationEmissive = null;
            if (suffixEmissivePng != null && (s = loc.getPath()).endsWith(SUFFIX_PNG)) {
                if (s.endsWith(suffixEmissivePng)) {
                    tex.isEmissive = true;
                } else {
                    String s1 = String.valueOf(s.substring(0, s.length() - SUFFIX_PNG.length())) + suffixEmissivePng;
                    ResourceLocation resourcelocation = new ResourceLocation(loc.getNamespace(), s1);
                    if (Config.hasResource(resourcelocation)) {
                        tex.locationEmissive = resourcelocation;
                    }
                }
            }
        }
    }
}

