/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.optifine.Config;
import net.optifine.util.MemoryMonitor;

public class Lagometer {
    private static Minecraft mc;
    private static Options gameSettings;
    private static ProfilerFiller profiler;
    public static boolean active;
    public static TimerNano timerTick;
    public static TimerNano timerScheduledExecutables;
    public static TimerNano timerChunkUpload;
    public static TimerNano timerChunkUpdate;
    public static TimerNano timerVisibility;
    public static TimerNano timerTerrain;
    public static TimerNano timerServer;
    private static long[] timesFrame;
    private static long[] timesTick;
    private static long[] timesScheduledExecutables;
    private static long[] timesChunkUpload;
    private static long[] timesChunkUpdate;
    private static long[] timesVisibility;
    private static long[] timesTerrain;
    private static long[] timesServer;
    private static boolean[] gcs;
    private static int numRecordedFrameTimes;
    private static long prevFrameTimeNano;
    private static long renderTimeNano;

    static {
        active = false;
        timerTick = new TimerNano();
        timerScheduledExecutables = new TimerNano();
        timerChunkUpload = new TimerNano();
        timerChunkUpdate = new TimerNano();
        timerVisibility = new TimerNano();
        timerTerrain = new TimerNano();
        timerServer = new TimerNano();
        timesFrame = new long[512];
        timesTick = new long[512];
        timesScheduledExecutables = new long[512];
        timesChunkUpload = new long[512];
        timesChunkUpdate = new long[512];
        timesVisibility = new long[512];
        timesTerrain = new long[512];
        timesServer = new long[512];
        gcs = new boolean[512];
        numRecordedFrameTimes = 0;
        prevFrameTimeNano = -1L;
        renderTimeNano = 0L;
    }

    public static void updateLagometer() {
        if (mc == null) {
            mc = Minecraft.getInstance();
            gameSettings = Lagometer.mc.options;
            profiler = mc.getProfiler();
        }
        if (Lagometer.gameSettings.renderDebug && (Lagometer.gameSettings.ofLagometer || Lagometer.gameSettings.renderFpsChart)) {
            active = true;
            long timeNowNano = System.nanoTime();
            if (prevFrameTimeNano == -1L) {
                prevFrameTimeNano = timeNowNano;
            } else {
                int j = numRecordedFrameTimes & timesFrame.length - 1;
                ++numRecordedFrameTimes;
                boolean flag = MemoryMonitor.isGcEvent();
                Lagometer.timesFrame[j] = timeNowNano - prevFrameTimeNano - renderTimeNano;
                Lagometer.timesTick[j] = Lagometer.timerTick.timeNano;
                Lagometer.timesScheduledExecutables[j] = Lagometer.timerScheduledExecutables.timeNano;
                Lagometer.timesChunkUpload[j] = Lagometer.timerChunkUpload.timeNano;
                Lagometer.timesChunkUpdate[j] = Lagometer.timerChunkUpdate.timeNano;
                Lagometer.timesVisibility[j] = Lagometer.timerVisibility.timeNano;
                Lagometer.timesTerrain[j] = Lagometer.timerTerrain.timeNano;
                Lagometer.timesServer[j] = Lagometer.timerServer.timeNano;
                Lagometer.gcs[j] = flag;
                timerTick.reset();
                timerScheduledExecutables.reset();
                timerVisibility.reset();
                timerChunkUpdate.reset();
                timerChunkUpload.reset();
                timerTerrain.reset();
                timerServer.reset();
                prevFrameTimeNano = System.nanoTime();
            }
        } else {
            active = false;
            prevFrameTimeNano = -1L;
        }
    }

    public static void showLagometer(PoseStack matrixStackIn, int scaleFactor) {
        if (gameSettings != null && (Lagometer.gameSettings.ofLagometer || Lagometer.gameSettings.renderFpsChart)) {
            long i = System.nanoTime();
            GlStateManager.clear(256);
            RenderSystem.backupProjectionMatrix();
            int j = mc.getWindow().getWidth();
            int k = mc.getWindow().getHeight();
            Matrix4f matrix4f = Matrix4f.orthographic(j, -k, 1000.0f, 3000.0f);
            RenderSystem.setProjectionMatrix(matrix4f);
            matrixStackIn.pushPose();
            GlStateManager._disableTexture();
            GlStateManager._depthMask(false);
            GlStateManager._disableCull();
            RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
            RenderSystem.lineWidth(1.0f);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = tesselator.getBuilder();
            bufferbuilder.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
            int l = 0;
            while (l < timesFrame.length) {
                int i1 = (l - numRecordedFrameTimes & timesFrame.length - 1) * 100 / timesFrame.length;
                i1 += 155;
                float f = k;
                long j1 = 0L;
                if (gcs[l]) {
                    Lagometer.renderTime(l, timesFrame[l], i1, i1 / 2, 0, f, bufferbuilder);
                } else {
                    Lagometer.renderTime(l, timesFrame[l], i1, i1, i1, f, bufferbuilder);
                    f -= (float)Lagometer.renderTime(l, timesServer[l], i1 / 2, i1 / 2, i1 / 2, f, bufferbuilder);
                    f -= (float)Lagometer.renderTime(l, timesTerrain[l], 0, i1, 0, f, bufferbuilder);
                    f -= (float)Lagometer.renderTime(l, timesVisibility[l], i1, i1, 0, f, bufferbuilder);
                    f -= (float)Lagometer.renderTime(l, timesChunkUpdate[l], i1, 0, 0, f, bufferbuilder);
                    f -= (float)Lagometer.renderTime(l, timesChunkUpload[l], i1, 0, i1, f, bufferbuilder);
                    f -= (float)Lagometer.renderTime(l, timesScheduledExecutables[l], 0, 0, i1, f, bufferbuilder);
                    float f2 = f - (float)Lagometer.renderTime(l, timesTick[l], 0, i1, i1, f, bufferbuilder);
                }
                ++l;
            }
            Lagometer.renderTimeDivider(0, timesFrame.length, 33333333L, 196, 196, 196, k, bufferbuilder);
            Lagometer.renderTimeDivider(0, timesFrame.length, 16666666L, 196, 196, 196, k, bufferbuilder);
            tesselator.end();
            GlStateManager._enableCull();
            GlStateManager._depthMask(true);
            GlStateManager._enableTexture();
            int i3 = k - 80;
            int j3 = k - 160;
            String s = Config.isShowFrameTime() ? "33" : "30";
            String s1 = Config.isShowFrameTime() ? "17" : "60";
            Lagometer.mc.font.draw(matrixStackIn, s, 2.0f, (float)(j3 + 1), -8947849);
            Lagometer.mc.font.draw(matrixStackIn, s, 1.0f, (float)j3, -3881788);
            Lagometer.mc.font.draw(matrixStackIn, s1, 2.0f, (float)(i3 + 1), -8947849);
            Lagometer.mc.font.draw(matrixStackIn, s1, 1.0f, (float)i3, -3881788);
            RenderSystem.restoreProjectionMatrix();
            matrixStackIn.popPose();
            float f1 = 1.0f - (float)((double)(System.currentTimeMillis() - MemoryMonitor.getStartTimeMs()) / 1000.0);
            f1 = Config.limit(f1, 0.0f, 1.0f);
            int k1 = (int)Mth.lerp(f1, 180.0f, 255.0f);
            int l1 = (int)Mth.lerp(f1, 110.0f, 155.0f);
            int i2 = (int)Mth.lerp(f1, 15.0f, 20.0f);
            int j2 = k1 << 16 | l1 << 8 | i2;
            int k2 = 512 / scaleFactor + 2;
            int l2 = k / scaleFactor - 8;
            Gui gui = Lagometer.mc.gui;
            Gui.fill(matrixStackIn, k2 - 1, l2 - 1, k2 + 50, l2 + 10, -1605349296);
            Lagometer.mc.font.draw(matrixStackIn, " " + MemoryMonitor.getGcRateMb() + " MB/s", (float)k2, (float)l2, j2);
            renderTimeNano = System.nanoTime() - i;
        }
    }

    private static long renderTime(int frameNum, long time, int r, int g, int b, float baseHeight, BufferBuilder tessellator) {
        long i = time / 200000L;
        if (i < 3L) {
            return 0L;
        }
        tessellator.vertex((float)frameNum + 0.5f, baseHeight - (float)i + 0.5f, 0.0).color(r, g, b, 255).normal(0.0f, 1.0f, 0.0f).endVertex();
        tessellator.vertex((float)frameNum + 0.5f, baseHeight + 0.5f, 0.0).color(r, g, b, 255).normal(0.0f, 1.0f, 0.0f).endVertex();
        return i;
    }

    private static long renderTimeDivider(int frameStart, int frameEnd, long time, int r, int g, int b, float baseHeight, BufferBuilder tessellator) {
        long i = time / 200000L;
        if (i < 3L) {
            return 0L;
        }
        tessellator.vertex((float)frameStart + 0.5f, baseHeight - (float)i + 0.5f, 0.0).color(r, g, b, 255).normal(1.0f, 0.0f, 0.0f).endVertex();
        tessellator.vertex((float)frameEnd + 0.5f, baseHeight - (float)i + 0.5f, 0.0).color(r, g, b, 255).normal(1.0f, 0.0f, 0.0f).endVertex();
        return i;
    }

    public static boolean isActive() {
        return active;
    }

    public static class TimerNano {
        public long timeStartNano = 0L;
        public long timeNano = 0L;

        public void start() {
            if (active && this.timeStartNano == 0L) {
                this.timeStartNano = System.nanoTime();
            }
        }

        public void end() {
            if (active && this.timeStartNano != 0L) {
                this.timeNano += System.nanoTime() - this.timeStartNano;
                this.timeStartNano = 0L;
            }
        }

        private void reset() {
            this.timeNano = 0L;
            this.timeStartNano = 0L;
        }
    }
}

