/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.optifine.Config;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class Lang {
    private static final Splitter splitter = Splitter.on((char)'=').limit(2);
    private static final Pattern pattern = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");

    public static void resourcesReloaded() {
        HashMap map = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        String s = "optifine/lang/";
        String s1 = "en_us";
        String s2 = ".lang";
        list.add(String.valueOf(s) + s1 + s2);
        if (!Config.getGameSettings().languageCode.equals(s1)) {
            list.add(String.valueOf(s) + Config.getGameSettings().languageCode + s2);
        }
        String[] astring = list.toArray(new String[list.size()]);
        Lang.loadResources(Config.getDefaultResourcePack(), astring, map);
        PackResources[] apackresources = Config.getResourcePacks();
        int i = 0;
        while (i < apackresources.length) {
            PackResources packresources = apackresources[i];
            Lang.loadResources(packresources, astring, map);
            ++i;
        }
    }

    private static void loadResources(PackResources rp, String[] files, Map localeProperties) {
        try {
            int i = 0;
            while (i < files.length) {
                InputStream inputstream;
                String s = files[i];
                ResourceLocation resourcelocation = new ResourceLocation(s);
                if (rp.hasResource(PackType.CLIENT_RESOURCES, resourcelocation) && (inputstream = rp.getResource(PackType.CLIENT_RESOURCES, resourcelocation)) != null) {
                    Lang.loadLocaleData(inputstream, localeProperties);
                }
                ++i;
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public static void loadLocaleData(InputStream is, Map localeProperties) throws IOException {
        Iterator iterator = IOUtils.readLines((InputStream)is, (Charset)Charsets.UTF_8).iterator();
        is.close();
        while (iterator.hasNext()) {
            String[] astring;
            String s = (String)iterator.next();
            if (s.isEmpty() || s.charAt(0) == '#' || (astring = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)s), String.class)) == null || astring.length != 2) continue;
            String s1 = astring[0];
            String s2 = pattern.matcher(astring[1]).replaceAll("%$1s");
            localeProperties.put(s1, s2);
        }
    }

    public static void loadResources(ResourceManager resourceManager, String langCode, Map<String, String> map) {
        try {
            String s = "optifine/lang/" + langCode + ".lang";
            ResourceLocation resourcelocation = new ResourceLocation(s);
            Resource resource = resourceManager.getResource(resourcelocation);
            InputStream inputstream = resource.getInputStream();
            Lang.loadLocaleData(inputstream, map);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String get(String key) {
        return I18n.a(key, new Object[0]);
    }

    public static TranslatableComponent getComponent(String key) {
        return new TranslatableComponent(key);
    }

    public static String get(String key, String def) {
        String s = I18n.a(key, new Object[0]);
        return s != null && !s.equals(key) ? s : def;
    }

    public static String getOn() {
        return I18n.a("options.on", new Object[0]);
    }

    public static String getOff() {
        return I18n.a("options.off", new Object[0]);
    }

    public static String getFast() {
        return I18n.a("options.graphics.fast", new Object[0]);
    }

    public static String getFancy() {
        return I18n.a("options.graphics.fancy", new Object[0]);
    }

    public static String getDefault() {
        return I18n.a("generator.default", new Object[0]);
    }
}

