/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import net.minecraft.client.multiplayer.ClientLevel;
import net.optifine.Config;
import net.optifine.CustomColormap;

public class LightMap {
    private CustomColormap lightMapRgb = null;
    private float[][] sunRgbs = new float[16][3];
    private float[][] torchRgbs = new float[16][3];

    public LightMap(CustomColormap lightMapRgb) {
        this.lightMapRgb = lightMapRgb;
    }

    public CustomColormap getColormap() {
        return this.lightMapRgb;
    }

    public boolean updateLightmap(ClientLevel world, float torchFlickerX, int[] lmColors, boolean nightvision) {
        if (this.lightMapRgb == null) {
            return false;
        }
        int i = this.lightMapRgb.getHeight();
        if (nightvision && i < 64) {
            return false;
        }
        int j = this.lightMapRgb.getWidth();
        if (j < 16) {
            LightMap.warn("Invalid lightmap width: " + j);
            this.lightMapRgb = null;
            return false;
        }
        int k = 0;
        if (nightvision) {
            k = j * 16 * 2;
        }
        float f = 1.1666666f * (world.getSkyDarken(1.0f) - 0.2f);
        if (world.getSkyFlashTime() > 0) {
            f = 1.0f;
        }
        f = Config.limitTo1(f);
        float f1 = f * (float)(j - 1);
        float f2 = Config.limitTo1(torchFlickerX + 0.5f) * (float)(j - 1);
        float f3 = Config.limitTo1((float)Config.getGameSettings().gamma);
        boolean flag = f3 > 1.0E-4f;
        float[][] afloat = this.lightMapRgb.getColorsRgb();
        this.getLightMapColumn(afloat, f1, k, j, this.sunRgbs);
        this.getLightMapColumn(afloat, f2, k + 16 * j, j, this.torchRgbs);
        float[] afloat1 = new float[3];
        int l = 0;
        while (l < 16) {
            int i1 = 0;
            while (i1 < 16) {
                int j1 = 0;
                while (j1 < 3) {
                    float f4 = Config.limitTo1(this.sunRgbs[l][j1] + this.torchRgbs[i1][j1]);
                    if (flag) {
                        float f5 = 1.0f - f4;
                        f5 = 1.0f - f5 * f5 * f5 * f5;
                        f4 = f3 * f5 + (1.0f - f3) * f4;
                    }
                    afloat1[j1] = f4;
                    ++j1;
                }
                int k1 = (int)(afloat1[0] * 255.0f);
                int l1 = (int)(afloat1[1] * 255.0f);
                int i2 = (int)(afloat1[2] * 255.0f);
                lmColors[l * 16 + i1] = 0xFF000000 | i2 << 16 | l1 << 8 | k1;
                ++i1;
            }
            ++l;
        }
        return true;
    }

    private void getLightMapColumn(float[][] origMap, float x, int offset, int width, float[][] colRgb) {
        int j;
        int i = (int)Math.floor(x);
        if (i == (j = (int)Math.ceil(x))) {
            int i1 = 0;
            while (i1 < 16) {
                float[] afloat3 = origMap[offset + i1 * width + i];
                float[] afloat4 = colRgb[i1];
                int j1 = 0;
                while (j1 < 3) {
                    afloat4[j1] = afloat3[j1];
                    ++j1;
                }
                ++i1;
            }
        } else {
            float f = 1.0f - (x - (float)i);
            float f1 = 1.0f - ((float)j - x);
            int k = 0;
            while (k < 16) {
                float[] afloat = origMap[offset + k * width + i];
                float[] afloat1 = origMap[offset + k * width + j];
                float[] afloat2 = colRgb[k];
                int l = 0;
                while (l < 3) {
                    afloat2[l] = afloat[l] * f + afloat1[l] * f1;
                    ++l;
                }
                ++k;
            }
        }
    }

    private static void dbg(String str) {
        Config.dbg("CustomColors: " + str);
    }

    private static void warn(String str) {
        Config.warn("CustomColors: " + str);
    }
}

