/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean logDetail = System.getProperty("log.detail", "false").equals("true");

    public static void detail(String s) {
        if (logDetail) {
            LOGGER.info("[OptiFine] " + s);
        }
    }

    public static void dbg(String s) {
        LOGGER.info("[OptiFine] " + s);
    }

    public static void warn(String s) {
        LOGGER.warn("[OptiFine] " + s);
    }

    public static void warn(String s, Throwable t) {
        Log.limitStackTrace(t);
        LOGGER.warn("[OptiFine] " + s, t);
    }

    public static void error(String s) {
        LOGGER.error("[OptiFine] " + s);
    }

    public static void error(String s, Throwable t) {
        Log.limitStackTrace(t);
        LOGGER.error("[OptiFine] " + s, t);
    }

    public static void log(String s) {
        Log.dbg(s);
    }

    private static void limitStackTrace(Throwable t) {
        StackTraceElement[] astacktraceelement = t.getStackTrace();
        if (astacktraceelement != null && astacktraceelement.length > 35) {
            ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>(Arrays.asList(astacktraceelement));
            ArrayList list1 = new ArrayList();
            list1.addAll(list.subList(0, 30));
            list1.add(new StackTraceElement("..", "", null, 0));
            list1.addAll(list.subList(list.size() - 5, list.size()));
            StackTraceElement[] astacktraceelement1 = list1.toArray(new StackTraceElement[list1.size()]);
            t.setStackTrace(astacktraceelement1);
        }
    }
}

