/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

public class RandomEntities {
    private static Map<String, RandomEntityProperties> mapProperties = new HashMap<String, RandomEntityProperties>();
    private static boolean active = false;
    private static EntityRenderDispatcher entityRenderDispatcher;
    private static RandomEntity randomEntity;
    private static BlockEntityRenderDispatcher tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_OPTIFINE_MOB = "optifine/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, Horse.class, String[].class, 0);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, Horse.class, String[].class, 1);
    }

    public static void entityLoaded(Entity entity, Level world) {
        if (world != null) {
            SynchedEntityData synchedentitydata = entity.getEntityData();
            synchedentitydata.spawnPosition = entity.blockPosition();
            synchedentitydata.spawnBiome = world.getBiome(synchedentitydata.spawnPosition).value();
            if (entity instanceof ShoulderRidingEntity) {
                ShoulderRidingEntity shoulderridingentity = (ShoulderRidingEntity)entity;
                RandomEntities.checkEntityShoulder(shoulderridingentity, false);
            }
        }
    }

    public static void entityUnloaded(Entity entity, Level world) {
        if (entity instanceof ShoulderRidingEntity) {
            ShoulderRidingEntity shoulderridingentity = (ShoulderRidingEntity)entity;
            RandomEntities.checkEntityShoulder(shoulderridingentity, true);
        }
    }

    private static void checkEntityShoulder(ShoulderRidingEntity entity, boolean attach) {
        LivingEntity livingentity = entity.getOwner();
        if (livingentity == null) {
            livingentity = Config.getMinecraft().player;
        }
        if (livingentity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)livingentity;
            UUID uuid = entity.getUUID();
            if (attach) {
                CompoundTag compoundtag1;
                CompoundTag compoundtag = abstractclientplayer.getShoulderEntityLeft();
                if (compoundtag != null && compoundtag.contains("UUID") && Config.equals(compoundtag.getUUID("UUID"), uuid)) {
                    abstractclientplayer.entityShoulderLeft = entity;
                }
                if ((compoundtag1 = abstractclientplayer.getShoulderEntityRight()) != null && compoundtag1.contains("UUID") && Config.equals(compoundtag1.getUUID("UUID"), uuid)) {
                    abstractclientplayer.entityShoulderRight = entity;
                }
            } else {
                SynchedEntityData synchedentitydata = entity.getEntityData();
                if (abstractclientplayer.entityShoulderLeft != null && Config.equals(abstractclientplayer.entityShoulderLeft.getUUID(), uuid)) {
                    SynchedEntityData synchedentitydata1 = abstractclientplayer.entityShoulderLeft.getEntityData();
                    synchedentitydata.spawnPosition = synchedentitydata1.spawnPosition;
                    synchedentitydata.spawnBiome = synchedentitydata1.spawnBiome;
                    abstractclientplayer.entityShoulderLeft = null;
                }
                if (abstractclientplayer.entityShoulderRight != null && Config.equals(abstractclientplayer.entityShoulderRight.getUUID(), uuid)) {
                    SynchedEntityData synchedentitydata2 = abstractclientplayer.entityShoulderRight.getEntityData();
                    synchedentitydata.spawnPosition = synchedentitydata2.spawnPosition;
                    synchedentitydata.spawnBiome = synchedentitydata2.spawnBiome;
                    abstractclientplayer.entityShoulderRight = null;
                }
            }
        }
    }

    public static void worldChanged(Level oldWorld, Level newWorld) {
        if (newWorld instanceof ClientLevel) {
            ClientLevel clientlevel = (ClientLevel)newWorld;
            for (Entity entity : clientlevel.entitiesForRendering()) {
                RandomEntities.entityLoaded(entity, newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    public static ResourceLocation getTextureLocation(ResourceLocation loc) {
        ResourceLocation name;
        if (!active) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            IRandomEntity irandomentity = RandomEntities.getRandomEntityRendered();
            if (irandomentity != null) {
                String s = loc.getPath();
                if (s.startsWith(PREFIX_DYNAMIC_TEXTURE_HORSE)) {
                    s = RandomEntities.getHorseTexturePath(s, PREFIX_DYNAMIC_TEXTURE_HORSE.length());
                }
                if (!s.startsWith(PREFIX_TEXTURES_ENTITY) && !s.startsWith(PREFIX_TEXTURES_PAINTING)) {
                    ResourceLocation resourceLocation = loc;
                    return resourceLocation;
                }
                RandomEntityProperties randomentityproperties = mapProperties.get(s);
                if (randomentityproperties == null) {
                    ResourceLocation resourceLocation = loc;
                    return resourceLocation;
                }
                ResourceLocation resourceLocation = randomentityproperties.getTextureLocation(loc, irandomentity);
                return resourceLocation;
            }
            name = loc;
        }
        finally {
            working = false;
        }
        return name;
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES != null && HORSE_TEXTURES_ABBR != null) {
            int i = 0;
            while (i < HORSE_TEXTURES_ABBR.length) {
                String s = HORSE_TEXTURES_ABBR[i];
                if (path.startsWith(s, pos)) {
                    return HORSE_TEXTURES[i];
                }
                ++i;
            }
            return path;
        }
        return path;
    }

    public static IRandomEntity getRandomEntityRendered() {
        if (entityRenderDispatcher.getRenderedEntity() != null) {
            randomEntity.setEntity(entityRenderDispatcher.getRenderedEntity());
            return randomEntity;
        }
        BlockEntityRenderDispatcher blockentityrenderdispatcher = tileEntityRendererDispatcher;
        if (BlockEntityRenderDispatcher.tileEntityRendered != null) {
            blockentityrenderdispatcher = tileEntityRendererDispatcher;
            BlockEntity blockentity = BlockEntityRenderDispatcher.tileEntityRendered;
            if (blockentity.getLevel() != null) {
                randomTileEntity.setTileEntity(blockentity);
                return randomTileEntity;
            }
        }
        return null;
    }

    private static RandomEntityProperties makeProperties(ResourceLocation loc, boolean optifine) {
        RandomEntityProperties randomentityproperties;
        String s = loc.getPath();
        ResourceLocation resourcelocation = RandomEntities.getLocationProperties(loc, optifine);
        if (resourcelocation != null && (randomentityproperties = RandomEntities.parseProperties(resourcelocation, loc)) != null) {
            return randomentityproperties;
        }
        ResourceLocation[] aresourcelocation = RandomEntities.getLocationsVariants(loc, optifine);
        return aresourcelocation == null ? null : new RandomEntityProperties(s, aresourcelocation);
    }

    private static RandomEntityProperties parseProperties(ResourceLocation propLoc, ResourceLocation resLoc) {
        InputStream inputstream;
        String s;
        block4: {
            s = propLoc.getPath();
            RandomEntities.dbg(String.valueOf(resLoc.getPath()) + ", properties: " + s);
            inputstream = Config.getResourceStream(propLoc);
            if (inputstream != null) break block4;
            RandomEntities.warn("Properties not found: " + s);
            return null;
        }
        try {
            PropertiesOrdered properties = new PropertiesOrdered();
            properties.load(inputstream);
            inputstream.close();
            RandomEntityProperties randomentityproperties = new RandomEntityProperties(properties, s, resLoc);
            return !randomentityproperties.isValid(s) ? null : randomentityproperties;
        }
        catch (FileNotFoundException filenotfoundexception) {
            RandomEntities.warn("File not found: " + resLoc.getPath());
            return null;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            return null;
        }
    }

    private static ResourceLocation getLocationProperties(ResourceLocation loc, boolean optifine) {
        String s1;
        String s2;
        String s3;
        ResourceLocation resourcelocation = RandomEntities.getLocationRandom(loc, optifine);
        if (resourcelocation == null) {
            return null;
        }
        String s = resourcelocation.getNamespace();
        ResourceLocation resourcelocation1 = new ResourceLocation(s, s3 = String.valueOf(s2 = StrUtils.removeSuffix(s1 = resourcelocation.getPath(), SUFFIX_PNG)) + SUFFIX_PROPERTIES);
        if (Config.hasResource(resourcelocation1)) {
            return resourcelocation1;
        }
        String s4 = RandomEntities.getParentTexturePath(s2);
        if (s4 == null) {
            return null;
        }
        ResourceLocation resourcelocation2 = new ResourceLocation(s, String.valueOf(s4) + SUFFIX_PROPERTIES);
        return Config.hasResource(resourcelocation2) ? resourcelocation2 : null;
    }

    protected static ResourceLocation getLocationRandom(ResourceLocation loc, boolean optifine) {
        String s = loc.getNamespace();
        String s1 = loc.getPath();
        String s2 = PREFIX_TEXTURES;
        String s3 = PREFIX_OPTIFINE_RANDOM;
        if (optifine) {
            s2 = PREFIX_TEXTURES_ENTITY;
            s3 = PREFIX_OPTIFINE_MOB;
        }
        if (!s1.startsWith(s2)) {
            return null;
        }
        String s4 = StrUtils.replacePrefix(s1, s2, s3);
        return new ResourceLocation(s, s4);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith(PREFIX_OPTIFINE_RANDOM)) {
            return StrUtils.replacePrefix(pathRandom, PREFIX_OPTIFINE_RANDOM, PREFIX_TEXTURES);
        }
        return pathRandom.startsWith(PREFIX_OPTIFINE_MOB) ? StrUtils.replacePrefix(pathRandom, PREFIX_OPTIFINE_MOB, PREFIX_TEXTURES_ENTITY) : null;
    }

    protected static ResourceLocation getLocationIndexed(ResourceLocation loc, int index) {
        if (loc == null) {
            return null;
        }
        String s = loc.getPath();
        int i = s.lastIndexOf(46);
        if (i < 0) {
            return null;
        }
        String s1 = s.substring(0, i);
        String s2 = s.substring(i);
        String s3 = String.valueOf(s1) + index + s2;
        return new ResourceLocation(loc.getNamespace(), s3);
    }

    private static String getParentTexturePath(String path) {
        int i = 0;
        while (i < DEPENDANT_SUFFIXES.length) {
            String s = DEPENDANT_SUFFIXES[i];
            if (path.endsWith(s)) {
                return StrUtils.removeSuffix(path, s);
            }
            ++i;
        }
        return null;
    }

    private static ResourceLocation[] getLocationsVariants(ResourceLocation loc, boolean optifine) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.add(loc);
        ResourceLocation resourcelocation = RandomEntities.getLocationRandom(loc, optifine);
        if (resourcelocation == null) {
            return null;
        }
        int i = 1;
        while (i < list.size() + 10) {
            int j = i + 1;
            ResourceLocation resourcelocation1 = RandomEntities.getLocationIndexed(resourcelocation, j);
            if (Config.hasResource(resourcelocation1)) {
                list.add(resourcelocation1);
            }
            ++i;
        }
        if (list.size() <= 1) {
            return null;
        }
        ResourceLocation[] aresourcelocation = list.toArray(new ResourceLocation[list.size()]);
        RandomEntities.dbg(String.valueOf(loc.getPath()) + ", variants: " + aresourcelocation.length);
        return aresourcelocation;
    }

    public static void update() {
        entityRenderDispatcher = Config.getEntityRenderDispatcher();
        tileEntityRendererDispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
        mapProperties.clear();
        active = false;
        if (Config.isRandomEntities()) {
            RandomEntities.initialize();
        }
    }

    private static void initialize() {
        String[] astring = new String[]{PREFIX_OPTIFINE_RANDOM, PREFIX_OPTIFINE_MOB};
        String[] astring1 = new String[]{SUFFIX_PNG, SUFFIX_PROPERTIES};
        String[] astring2 = ResUtils.collectFiles(astring, astring1);
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < astring2.length) {
            String s = astring2[i];
            s = StrUtils.removeSuffix(s, astring1);
            s = StrUtils.trimTrailing(s, "0123456789");
            String s1 = RandomEntities.getPathBase(s = String.valueOf(s) + SUFFIX_PNG);
            if (!set.contains(s1)) {
                RandomEntityProperties randomentityproperties;
                set.add(s1);
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                if (Config.hasResource(resourcelocation) && (randomentityproperties = mapProperties.get(s1)) == null) {
                    randomentityproperties = RandomEntities.makeProperties(resourcelocation, false);
                    if (randomentityproperties == null) {
                        randomentityproperties = RandomEntities.makeProperties(resourcelocation, true);
                    }
                    if (randomentityproperties != null) {
                        mapProperties.put(s1, randomentityproperties);
                    }
                }
            }
            ++i;
        }
        active = !mapProperties.isEmpty();
    }

    public static void dbg(String str) {
        Config.dbg("RandomEntities: " + str);
    }

    public static void warn(String str) {
        Config.warn("RandomEntities: " + str);
    }
}

