/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.optifine.IRandomEntity;

public class RandomEntity
implements IRandomEntity {
    private Entity entity;

    @Override
    public int getId() {
        UUID uuid = this.entity.getUUID();
        long i = uuid.getLeastSignificantBits();
        return (int)(i & Integer.MAX_VALUE);
    }

    @Override
    public BlockPos getSpawnPosition() {
        return this.entity.getEntityData().spawnPosition;
    }

    @Override
    public Biome getSpawnBiome() {
        return this.entity.getEntityData().spawnBiome;
    }

    @Override
    public String getName() {
        return this.entity.hasCustomName() ? this.entity.getCustomName().getString() : null;
    }

    @Override
    public int getHealth() {
        if (!(this.entity instanceof LivingEntity)) {
            return 0;
        }
        LivingEntity livingentity = (LivingEntity)this.entity;
        return (int)livingentity.getHealth();
    }

    @Override
    public int getMaxHealth() {
        if (!(this.entity instanceof LivingEntity)) {
            return 0;
        }
        LivingEntity livingentity = (LivingEntity)this.entity;
        return (int)livingentity.getMaxHealth();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }
}

