/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.Properties;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.DyeColor;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntities;
import net.optifine.RandomEntity;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;
import net.optifine.config.Weather;
import net.optifine.util.ArrayUtils;
import net.optifine.util.MathUtils;

public class RandomEntityRule {
    private String pathProps = null;
    private ResourceLocation baseResLoc = null;
    private int index;
    private int[] textures = null;
    private ResourceLocation[] resourceLocations = null;
    private int[] weights = null;
    private BiomeId[] biomes = null;
    private RangeListInt heights = null;
    private RangeListInt healthRange = null;
    private boolean healthPercent = false;
    private NbtTagValue nbtName = null;
    public int[] sumWeights = null;
    public int sumAllWeights = 1;
    private MatchProfession[] professions = null;
    private DyeColor[] colors = null;
    private Boolean baby = null;
    private RangeListInt moonPhases = null;
    private RangeListInt dayTimes = null;
    private Weather[] weatherList = null;
    private RangeListInt sizes = null;

    public RandomEntityRule(Properties props, String pathProps, ResourceLocation baseResLoc, int index, String valTextures, ConnectedParser cp) {
        String s;
        this.pathProps = pathProps;
        this.baseResLoc = baseResLoc;
        this.index = index;
        this.textures = cp.parseIntList(valTextures);
        this.weights = cp.parseIntList(props.getProperty("weights." + index));
        this.biomes = cp.parseBiomes(props.getProperty("biomes." + index));
        this.heights = cp.parseRangeListIntNeg(props.getProperty("heights." + index));
        if (this.heights == null) {
            this.heights = this.parseMinMaxHeight(props, index);
        }
        if ((s = props.getProperty("health." + index)) != null) {
            this.healthPercent = s.contains("%");
            s = s.replace("%", "");
            this.healthRange = cp.parseRangeListInt(s);
        }
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name." + index));
        this.professions = cp.parseProfessions(props.getProperty("professions." + index));
        this.colors = cp.parseDyeColors(props.getProperty("colors." + index), "color", ConnectedParser.DYE_COLORS_INVALID);
        if (this.colors == null) {
            this.colors = cp.parseDyeColors(props.getProperty("collarColors." + index), "collar color", ConnectedParser.DYE_COLORS_INVALID);
        }
        this.baby = cp.parseBooleanObject(props.getProperty("baby." + index));
        this.moonPhases = cp.parseRangeListInt(props.getProperty("moonPhase." + index));
        this.dayTimes = cp.parseRangeListInt(props.getProperty("dayTime." + index));
        this.weatherList = cp.parseWeather(props.getProperty("weather." + index), "weather." + index, null);
        this.sizes = cp.parseRangeListInt(props.getProperty("sizes." + index));
    }

    private RangeListInt parseMinMaxHeight(Properties props, int index) {
        String s = props.getProperty("minHeight." + index);
        String s1 = props.getProperty("maxHeight." + index);
        if (s == null && s1 == null) {
            return null;
        }
        int i = 0;
        if (s != null && (i = Config.parseInt(s, -1)) < 0) {
            Config.warn("Invalid minHeight: " + s);
            return null;
        }
        int j = 256;
        if (s1 != null && (j = Config.parseInt(s1, -1)) < 0) {
            Config.warn("Invalid maxHeight: " + s1);
            return null;
        }
        if (j < 0) {
            Config.warn("Invalid minHeight, maxHeight: " + s + ", " + s1);
            return null;
        }
        RangeListInt rangelistint = new RangeListInt();
        rangelistint.addRange(new RangeInt(i, j));
        return rangelistint;
    }

    public boolean isValid(String path) {
        if (this.textures != null && this.textures.length != 0) {
            if (this.resourceLocations != null) {
                return true;
            }
            this.resourceLocations = new ResourceLocation[this.textures.length];
            boolean flag = this.pathProps.startsWith("optifine/mob/");
            ResourceLocation resourcelocation = RandomEntities.getLocationRandom(this.baseResLoc, flag);
            if (resourcelocation == null) {
                Config.warn("Invalid path: " + this.baseResLoc.getPath());
                return false;
            }
            int i = 0;
            while (i < this.resourceLocations.length) {
                int j = this.textures[i];
                if (j <= 1) {
                    this.resourceLocations[i] = this.baseResLoc;
                } else {
                    ResourceLocation resourcelocation1 = RandomEntities.getLocationIndexed(resourcelocation, j);
                    if (resourcelocation1 == null) {
                        Config.warn("Invalid path: " + this.baseResLoc.getPath());
                        return false;
                    }
                    if (!Config.hasResource(resourcelocation1)) {
                        Config.warn("Texture not found: " + resourcelocation1.getPath());
                        return false;
                    }
                    this.resourceLocations[i] = resourcelocation1;
                }
                ++i;
            }
            if (this.weights != null) {
                if (this.weights.length > this.resourceLocations.length) {
                    Config.warn("More weights defined than skins, trimming weights: " + path);
                    int[] aint = new int[this.resourceLocations.length];
                    System.arraycopy(this.weights, 0, aint, 0, aint.length);
                    this.weights = aint;
                }
                if (this.weights.length < this.resourceLocations.length) {
                    Config.warn("Less weights defined than skins, expanding weights: " + path);
                    int[] aint1 = new int[this.resourceLocations.length];
                    System.arraycopy(this.weights, 0, aint1, 0, this.weights.length);
                    int l = MathUtils.getAverage(this.weights);
                    int j1 = this.weights.length;
                    while (j1 < aint1.length) {
                        aint1[j1] = l;
                        ++j1;
                    }
                    this.weights = aint1;
                }
                this.sumWeights = new int[this.weights.length];
                int k = 0;
                int i1 = 0;
                while (i1 < this.weights.length) {
                    if (this.weights[i1] < 0) {
                        Config.warn("Invalid weight: " + this.weights[i1]);
                        return false;
                    }
                    this.sumWeights[i1] = k += this.weights[i1];
                    ++i1;
                }
                this.sumAllWeights = k;
                if (this.sumAllWeights <= 0) {
                    Config.warn("Invalid sum of all weights: " + k);
                    this.sumAllWeights = 1;
                }
            }
            if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
                Config.warn("Invalid professions or careers: " + path);
                return false;
            }
            if (this.colors == ConnectedParser.DYE_COLORS_INVALID) {
                Config.warn("Invalid colors: " + path);
                return false;
            }
            return true;
        }
        Config.warn("Invalid skins for rule: " + this.index);
        return false;
    }

    public boolean matches(IRandomEntity randomEntity) {
        RandomEntity randomentity3;
        Entity entity3;
        int j1;
        Weather weather;
        ClientLevel level2;
        int i1;
        ClientLevel level1;
        int l;
        ClientLevel level;
        LivingEntity livingentity;
        RandomEntity randomentity2;
        Entity entity2;
        RandomEntity randomentity1;
        Entity entity1;
        DyeColor dyecolor;
        int j;
        Villager villager;
        VillagerData villagerdata;
        VillagerProfession villagerprofession;
        RandomEntity randomentity;
        Entity entity;
        String s;
        BlockPos blockpos;
        if (this.biomes != null && !Matches.biome(randomEntity.getSpawnBiome(), this.biomes)) {
            return false;
        }
        if (this.heights != null && (blockpos = randomEntity.getSpawnPosition()) != null && !this.heights.isInRange(blockpos.getY())) {
            return false;
        }
        if (this.healthRange != null) {
            int i;
            int k = randomEntity.getHealth();
            if (this.healthPercent && (i = randomEntity.getMaxHealth()) > 0) {
                k = (int)((double)(k * 100) / (double)i);
            }
            if (!this.healthRange.isInRange(k)) {
                return false;
            }
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(s = randomEntity.getName())) {
            return false;
        }
        if (this.professions != null && randomEntity instanceof RandomEntity && (entity = (randomentity = (RandomEntity)randomEntity).getEntity()) instanceof Villager && !MatchProfession.matchesOne(villagerprofession = (villagerdata = (villager = (Villager)entity).getVillagerData()).getProfession(), j = villagerdata.getLevel(), this.professions)) {
            return false;
        }
        if (this.colors != null && randomEntity instanceof RandomEntity && (dyecolor = this.getEntityColor(entity1 = (randomentity1 = (RandomEntity)randomEntity).getEntity())) != null && !Config.equalsOne(dyecolor, this.colors)) {
            return false;
        }
        if (this.baby != null && randomEntity instanceof RandomEntity && (entity2 = (randomentity2 = (RandomEntity)randomEntity).getEntity()) instanceof LivingEntity && (livingentity = (LivingEntity)entity2).isBaby() != this.baby.booleanValue()) {
            return false;
        }
        if (this.moonPhases != null && (level = Config.getMinecraft().level) != null && !this.moonPhases.isInRange(l = level.getMoonPhase())) {
            return false;
        }
        if (this.dayTimes != null && (level1 = Config.getMinecraft().level) != null && !this.dayTimes.isInRange(i1 = (int)level1.getDayTime())) {
            return false;
        }
        if (this.weatherList != null && (level2 = Config.getMinecraft().level) != null && !ArrayUtils.contains((Object[])this.weatherList, (Object)(weather = Weather.getWeather(level2, 0.0f)))) {
            return false;
        }
        return this.sizes == null || !(randomEntity instanceof RandomEntity) || (j1 = this.getEntitySize(entity3 = (randomentity3 = (RandomEntity)randomEntity).getEntity())) < 0 || this.sizes.isInRange(j1);
    }

    private DyeColor getEntityColor(Entity entity) {
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            return !wolf.isTame() ? null : wolf.getCollarColor();
        }
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            return !cat.isTame() ? null : cat.getCollarColor();
        }
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            return sheep.getColor();
        }
        if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            return llama.getSwag();
        }
        return null;
    }

    private int getEntitySize(Entity entity) {
        if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            return slime.getSize() - 1;
        }
        if (entity instanceof Phantom) {
            Phantom phantom = (Phantom)entity;
            return phantom.getPhantomSize();
        }
        return -1;
    }

    public ResourceLocation getTextureLocation(ResourceLocation loc, int randomId) {
        if (this.resourceLocations != null && this.resourceLocations.length != 0) {
            int i = 0;
            if (this.weights == null) {
                i = randomId % this.resourceLocations.length;
            } else {
                int j = randomId % this.sumAllWeights;
                int k = 0;
                while (k < this.sumWeights.length) {
                    if (this.sumWeights[k] > j) {
                        i = k;
                        break;
                    }
                    ++k;
                }
            }
            return this.resourceLocations[i];
        }
        return loc;
    }
}

