/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import net.minecraft.client.Option;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.optifine.Config;
import net.optifine.Lang;

public class FloatOptions {
    public static Component getTextComponent(Option option, double val) {
        if (option == Option.RENDER_DISTANCE) {
            return option.genericValueLabel(new TranslatableComponent("options.chunks", (int)val));
        }
        if (option == Option.MIPMAP_LEVELS) {
            if (val >= 4.0) {
                return option.genericValueLabel(new TranslatableComponent("of.general.max"));
            }
            return val == 0.0 ? CommonComponents.optionStatus(option.getCaption(), false) : option.genericValueLabel((int)val);
        }
        if (option == Option.BIOME_BLEND_RADIUS) {
            int i = (int)val * 2 + 1;
            return option.genericValueLabel(new TranslatableComponent("options.biomeBlendRadius." + i));
        }
        String s = FloatOptions.getText(option, val);
        return s != null ? new TextComponent(s) : null;
    }

    public static String getText(Option option, double val) {
        String s = String.valueOf(I18n.a(option.getResourceKey(), new Object[0])) + ": ";
        if (option == Option.AO_LEVEL) {
            return val == 0.0 ? String.valueOf(s) + I18n.a("options.off", new Object[0]) : String.valueOf(s) + (int)(val * 100.0) + "%";
        }
        if (option == Option.MIPMAP_TYPE) {
            int k = (int)val;
            switch (k) {
                case 0: {
                    return String.valueOf(s) + Lang.get("of.options.mipmap.nearest");
                }
                case 1: {
                    return String.valueOf(s) + Lang.get("of.options.mipmap.linear");
                }
                case 2: {
                    return String.valueOf(s) + Lang.get("of.options.mipmap.bilinear");
                }
                case 3: {
                    return String.valueOf(s) + Lang.get("of.options.mipmap.trilinear");
                }
            }
            return String.valueOf(s) + "of.options.mipmap.nearest";
        }
        if (option == Option.AA_LEVEL) {
            int j = (int)val;
            String s1 = "";
            if (j != Config.getAntialiasingLevel()) {
                s1 = " (" + Lang.get("of.general.restart") + ")";
            }
            return j == 0 ? String.valueOf(s) + Lang.getOff() + s1 : String.valueOf(s) + j + s1;
        }
        if (option == Option.AF_LEVEL) {
            int i = (int)val;
            return i == 1 ? String.valueOf(s) + Lang.getOff() : String.valueOf(s) + i;
        }
        return null;
    }

    public static boolean supportAdjusting(ProgressOption option) {
        Component component = FloatOptions.getTextComponent(option, 0.0);
        return component != null;
    }
}

