/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import net.minecraft.world.level.block.state.BlockState;
import net.optifine.Config;
import net.optifine.config.Matches;

public class MatchBlock {
    private int blockId = -1;
    private int[] metadatas = null;

    public MatchBlock(int blockId) {
        this.blockId = blockId;
    }

    public MatchBlock(int blockId, int metadata) {
        this.blockId = blockId;
        if (metadata >= 0) {
            this.metadatas = new int[]{metadata};
        }
    }

    public MatchBlock(int blockId, int[] metadatas) {
        this.blockId = blockId;
        this.metadatas = metadatas;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public int[] getMetadatas() {
        return this.metadatas;
    }

    public boolean matches(BlockState blockState) {
        if (blockState.getBlockId() != this.blockId) {
            return false;
        }
        return Matches.metadata(blockState.getMetadata(), this.metadatas);
    }

    public boolean matches(int id, int metadata) {
        if (id != this.blockId) {
            return false;
        }
        return Matches.metadata(metadata, this.metadatas);
    }

    public void addMetadata(int metadata) {
        if (this.metadatas != null && metadata >= 0) {
            int i = 0;
            while (i < this.metadatas.length) {
                if (this.metadatas[i] == metadata) {
                    return;
                }
                ++i;
            }
            this.metadatas = Config.addIntToArray(this.metadatas, metadata);
        }
    }

    public void addMetadatas(int[] mds) {
        int i = 0;
        while (i < mds.length) {
            int j = mds[i];
            this.addMetadata(j);
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(this.blockId) + ":" + Config.arrayToString(this.metadatas);
    }
}

