/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.util.Arrays;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.optifine.Config;
import net.optifine.util.StrUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class NbtTagValue {
    private String[] parents = null;
    private String name = null;
    private boolean negative = false;
    private int type = 0;
    private String value = null;
    private int valueFormat = 0;
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PATTERN = 1;
    private static final int TYPE_IPATTERN = 2;
    private static final int TYPE_REGEX = 3;
    private static final int TYPE_IREGEX = 4;
    private static final String PREFIX_PATTERN = "pattern:";
    private static final String PREFIX_IPATTERN = "ipattern:";
    private static final String PREFIX_REGEX = "regex:";
    private static final String PREFIX_IREGEX = "iregex:";
    private static final int FORMAT_DEFAULT = 0;
    private static final int FORMAT_HEX_COLOR = 1;
    private static final String PREFIX_HEX_COLOR = "#";
    private static final Pattern PATTERN_HEX_COLOR = Pattern.compile("^#[0-9a-f]{6}+$");

    public NbtTagValue(String tag, String value) {
        String[] astring = Config.tokenize(tag, ".");
        this.parents = Arrays.copyOfRange(astring, 0, astring.length - 1);
        this.name = astring[astring.length - 1];
        if (value.startsWith("!")) {
            this.negative = true;
            value = value.substring(1);
        }
        if (value.startsWith(PREFIX_PATTERN)) {
            this.type = 1;
            value = value.substring(PREFIX_PATTERN.length());
        } else if (value.startsWith(PREFIX_IPATTERN)) {
            this.type = 2;
            value = value.substring(PREFIX_IPATTERN.length()).toLowerCase();
        } else if (value.startsWith(PREFIX_REGEX)) {
            this.type = 3;
            value = value.substring(PREFIX_REGEX.length());
        } else if (value.startsWith(PREFIX_IREGEX)) {
            this.type = 4;
            value = value.substring(PREFIX_IREGEX.length()).toLowerCase();
        } else {
            this.type = 0;
        }
        value = StringEscapeUtils.unescapeJava((String)value);
        if (this.type == 0 && PATTERN_HEX_COLOR.matcher(value).matches()) {
            this.valueFormat = 1;
        }
        this.value = value;
    }

    public boolean matches(CompoundTag nbt) {
        if (this.negative) {
            return !this.matchesCompound(nbt);
        }
        return this.matchesCompound(nbt);
    }

    public boolean matchesCompound(CompoundTag nbt) {
        if (nbt == null) {
            return false;
        }
        Tag tag = nbt;
        int i = 0;
        while (i < this.parents.length) {
            String s = this.parents[i];
            if ((tag = NbtTagValue.getChildTag(tag, s)) == null) {
                return false;
            }
            ++i;
        }
        if (this.name.equals("*")) {
            return this.matchesAnyChild(tag);
        }
        Tag tag1 = NbtTagValue.getChildTag(tag, this.name);
        if (tag1 == null) {
            return false;
        }
        return this.matchesBase(tag1);
    }

    private boolean matchesAnyChild(Tag tagBase) {
        if (tagBase instanceof CompoundTag) {
            CompoundTag compoundtag = (CompoundTag)tagBase;
            for (String s : compoundtag.getAllKeys()) {
                Tag tag = compoundtag.get(s);
                if (!this.matchesBase(tag)) continue;
                return true;
            }
        }
        if (tagBase instanceof ListTag) {
            ListTag listtag = (ListTag)tagBase;
            int i = listtag.size();
            int j = 0;
            while (j < i) {
                Tag tag1 = listtag.get(j);
                if (this.matchesBase(tag1)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private static Tag getChildTag(Tag tagBase, String tag) {
        if (tagBase instanceof CompoundTag) {
            CompoundTag compoundtag = (CompoundTag)tagBase;
            return compoundtag.get(tag);
        }
        if (tagBase instanceof ListTag) {
            ListTag listtag = (ListTag)tagBase;
            if (tag.equals("count")) {
                return IntTag.valueOf(listtag.size());
            }
            int i = Config.parseInt(tag, -1);
            return i >= 0 && i < listtag.size() ? listtag.get(i) : null;
        }
        return null;
    }

    public boolean matchesBase(Tag nbtBase) {
        if (nbtBase == null) {
            return false;
        }
        String s = NbtTagValue.getNbtString(nbtBase, this.valueFormat);
        return this.matchesValue(s);
    }

    public boolean matchesValue(String nbtValue) {
        if (nbtValue == null) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return nbtValue.equals(this.value);
            }
            case 1: {
                return this.matchesPattern(nbtValue, this.value);
            }
            case 2: {
                return this.matchesPattern(nbtValue.toLowerCase(), this.value);
            }
            case 3: {
                return this.matchesRegex(nbtValue, this.value);
            }
            case 4: {
                return this.matchesRegex(nbtValue.toLowerCase(), this.value);
            }
        }
        throw new IllegalArgumentException("Unknown NbtTagValue type: " + this.type);
    }

    private boolean matchesPattern(String str, String pattern) {
        return StrUtils.equalsMask(str, pattern, '*', '?');
    }

    private boolean matchesRegex(String str, String regex) {
        return str.matches(regex);
    }

    private static String getNbtString(Tag nbtBase, int format) {
        if (nbtBase == null) {
            return null;
        }
        if (!(nbtBase instanceof StringTag)) {
            if (nbtBase instanceof IntTag) {
                IntTag inttag = (IntTag)nbtBase;
                return format == 1 ? PREFIX_HEX_COLOR + StrUtils.fillLeft(Integer.toHexString(inttag.getAsInt()), 6, '0') : Integer.toString(inttag.getAsInt());
            }
            if (nbtBase instanceof ByteTag) {
                ByteTag bytetag = (ByteTag)nbtBase;
                return Byte.toString(bytetag.getAsByte());
            }
            if (nbtBase instanceof ShortTag) {
                ShortTag shorttag = (ShortTag)nbtBase;
                return Short.toString(shorttag.getAsShort());
            }
            if (nbtBase instanceof LongTag) {
                LongTag longtag = (LongTag)nbtBase;
                return Long.toString(longtag.getAsLong());
            }
            if (nbtBase instanceof FloatTag) {
                FloatTag floattag = (FloatTag)nbtBase;
                return Float.toString(floattag.getAsFloat());
            }
            if (nbtBase instanceof DoubleTag) {
                DoubleTag doubletag = (DoubleTag)nbtBase;
                return Double.toString(doubletag.getAsDouble());
            }
            return nbtBase.toString();
        }
        StringTag stringtag = (StringTag)nbtBase;
        String s = stringtag.getAsString();
        if (s.startsWith("{") && s.endsWith("}")) {
            s = NbtTagValue.getMergedJsonText(s);
        } else if (s.startsWith("[{") && s.endsWith("}]")) {
            s = NbtTagValue.getMergedJsonText(s);
        }
        return s;
    }

    private static String getMergedJsonText(String text) {
        StringBuilder stringbuilder = new StringBuilder();
        String s = "\"text\":\"";
        int i = -1;
        while ((i = text.indexOf(s, i + 1)) >= 0) {
            String s1 = NbtTagValue.parseString(text, i + s.length());
            if (s1 == null) continue;
            stringbuilder.append(s1);
        }
        return stringbuilder.toString();
    }

    private static String parseString(String text, int pos) {
        StringBuilder stringbuilder = new StringBuilder();
        boolean flag = false;
        int i = pos;
        while (i < text.length()) {
            char c0 = text.charAt(i);
            if (flag) {
                if (c0 == 'b') {
                    stringbuilder.append('\b');
                } else if (c0 == 'f') {
                    stringbuilder.append('\f');
                } else if (c0 == 'n') {
                    stringbuilder.append('\n');
                } else if (c0 == 'r') {
                    stringbuilder.append('\r');
                } else if (c0 == 't') {
                    stringbuilder.append('\t');
                } else {
                    stringbuilder.append(c0);
                }
                flag = false;
            } else if (c0 == '\\') {
                flag = true;
            } else {
                if (c0 == '\"') break;
                stringbuilder.append(c0);
            }
            ++i;
        }
        return stringbuilder.toString();
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        int i = 0;
        while (i < this.parents.length) {
            String s = this.parents[i];
            if (i > 0) {
                stringbuffer.append(".");
            }
            stringbuffer.append(s);
            ++i;
        }
        if (stringbuffer.length() > 0) {
            stringbuffer.append(".");
        }
        stringbuffer.append(this.name);
        stringbuffer.append(" = ");
        stringbuffer.append(this.value);
        return stringbuffer.toString();
    }
}

