/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.ThrownTridentRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.Config;
import net.optifine.Log;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.util.Either;
import net.optifine.util.StrUtils;

public class CustomEntityModels {
    private static boolean active = false;
    private static Map<EntityType, EntityRenderer> originalEntityRenderMap = null;
    private static Map<BlockEntityType, BlockEntityRenderer> originalTileEntityRenderMap = null;
    private static Map<SkullBlock.Type, SkullModelBase> originalSkullModelMap = null;
    private static List<BlockEntityType> customTileEntityTypes = new ArrayList<BlockEntityType>();
    private static BookModel customBookModel;
    private static boolean debugModels;

    static {
        debugModels = Boolean.getBoolean("cem.debug.models");
    }

    public static void update() {
        Map<EntityType, EntityRenderer> map = CustomEntityModels.getEntityRenderMap();
        Map<BlockEntityType, BlockEntityRenderer> map1 = CustomEntityModels.getTileEntityRenderMap();
        Map<SkullBlock.Type, SkullModelBase> map2 = CustomEntityModels.getSkullModelMap();
        if (map == null) {
            Config.warn("Entity render map not found, custom entity models are DISABLED.");
        } else if (map1 == null) {
            Config.warn("Tile entity render map not found, custom entity models are DISABLED.");
        } else {
            active = false;
            map.clear();
            map1.clear();
            map2.clear();
            customTileEntityTypes.clear();
            map.putAll(originalEntityRenderMap);
            map1.putAll(originalTileEntityRenderMap);
            map2.putAll(originalSkullModelMap);
            BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = Minecraft.getInstance().getItemRenderer().getBlockEntityRenderer();
            blockentitywithoutlevelrenderer.tridentModel = new TridentModel(ModelAdapter.bakeModelLayer(ModelLayers.TRIDENT));
            customBookModel = null;
            BlockEntityRenderer.CACHED_TYPES.clear();
            if (Config.isCustomEntityModels()) {
                ResourceLocation[] aresourcelocation = CustomEntityModels.getModelLocations();
                int i = 0;
                while (i < aresourcelocation.length) {
                    ResourceLocation resourcelocation = aresourcelocation[i];
                    Config.dbg("CustomEntityModel: " + resourcelocation.getPath());
                    IEntityRenderer ientityrenderer = CustomEntityModels.parseEntityRender(resourcelocation);
                    if (ientityrenderer != null) {
                        Either<EntityType, BlockEntityType> either = ientityrenderer.getType();
                        if (ientityrenderer instanceof EntityRenderer) {
                            ThrownTridentRenderer throwntridentrenderer;
                            TridentModel tridentmodel;
                            map.put(either.getLeft().get(), (EntityRenderer)ientityrenderer);
                            if (ientityrenderer instanceof ThrownTridentRenderer && (tridentmodel = (TridentModel)Reflector.getFieldValue(throwntridentrenderer = (ThrownTridentRenderer)ientityrenderer, Reflector.RenderTrident_modelTrident)) != null) {
                                blockentitywithoutlevelrenderer.tridentModel = tridentmodel;
                            }
                        } else if (ientityrenderer instanceof BlockEntityRenderer) {
                            map1.put(either.getRight().get(), (BlockEntityRenderer)ientityrenderer);
                            if (ientityrenderer instanceof EnchantTableRenderer) {
                                EnchantTableRenderer enchanttablerenderer = (EnchantTableRenderer)ientityrenderer;
                                BookModel bookmodel = (BookModel)Reflector.getFieldValue(enchanttablerenderer, Reflector.TileEntityEnchantmentTableRenderer_modelBook);
                                CustomEntityModels.setEnchantmentScreenBookModel(bookmodel);
                            }
                            customTileEntityTypes.add(either.getRight().get());
                        } else {
                            Config.warn("Unknown renderer type: " + ientityrenderer.getClass().getName());
                        }
                        active = true;
                    }
                    ++i;
                }
            }
        }
    }

    private static void setEnchantmentScreenBookModel(BookModel bookModel) {
        customBookModel = bookModel;
    }

    private static Map<EntityType, EntityRenderer> getEntityRenderMap() {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        Map<EntityType, EntityRenderer> map = entityrenderdispatcher.getEntityRenderMap();
        if (map == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap<EntityType, EntityRenderer>(map);
        }
        return map;
    }

    private static Map<BlockEntityType, BlockEntityRenderer> getTileEntityRenderMap() {
        BlockEntityRenderDispatcher blockentityrenderdispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
        Map map = blockentityrenderdispatcher.getBlockEntityRenderMap();
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap<BlockEntityType, BlockEntityRenderer>(map);
        }
        return map;
    }

    private static Map<SkullBlock.Type, SkullModelBase> getSkullModelMap() {
        Map<SkullBlock.Type, SkullModelBase> map = SkullBlockRenderer.models;
        if (map == null) {
            Config.warn("Field not found: SkullBlockRenderer.MODELS");
            map = new HashMap<SkullBlock.Type, SkullModelBase>();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap<SkullBlock.Type, SkullModelBase>(map);
        }
        return map;
    }

    private static ResourceLocation[] getModelLocations() {
        String s = "optifine/cem/";
        String s1 = ".jem";
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        String[] astring = CustomModelRegistry.getModelNames();
        int i = 0;
        while (i < astring.length) {
            String s2 = astring[i];
            String s3 = String.valueOf(s) + s2 + s1;
            ResourceLocation resourcelocation = new ResourceLocation(s3);
            if (Config.hasResource(resourcelocation) || debugModels) {
                list.add(resourcelocation);
            }
            ++i;
        }
        return list.toArray(new ResourceLocation[list.size()]);
    }

    private static IEntityRenderer parseEntityRender(ResourceLocation location) {
        try {
            if (debugModels) {
                return CustomEntityModels.makeDebugEntityRenderer(location);
            }
            JsonObject jsonobject = CustomEntityModelParser.loadJson(location);
            return CustomEntityModels.parseEntityRender(jsonobject, location.getPath());
        }
        catch (IOException ioexception) {
            Config.error(String.valueOf(ioexception.getClass().getName()) + ": " + ioexception.getMessage());
            return null;
        }
        catch (JsonParseException jsonparseexception) {
            Config.error(String.valueOf(((Object)((Object)jsonparseexception)).getClass().getName()) + ": " + jsonparseexception.getMessage());
            return null;
        }
        catch (Exception exception) {
            Log.warn("Error loading CEM: " + location, exception);
            return null;
        }
    }

    private static IEntityRenderer makeDebugEntityRenderer(ResourceLocation loc) {
        String s = loc.getPath();
        String s1 = StrUtils.removePrefix(s, "optifine/cem/");
        String s2 = StrUtils.removeSuffix(s1, ".jem");
        ModelAdapter modeladapter = CustomModelRegistry.getModelAdapter(s2);
        Model model = modeladapter.makeModel();
        DyeColor[] adyecolor = DyeColor.values();
        int i = Math.abs(loc.hashCode()) % 256;
        String[] astring = modeladapter.getModelRendererNames();
        int j = 0;
        while (j < astring.length) {
            String s3 = astring[j];
            ModelPart modelpart = modeladapter.getModelRenderer(model, s3);
            if (modelpart != null) {
                DyeColor dyecolor = adyecolor[(j + i) % adyecolor.length];
                ResourceLocation resourcelocation = new ResourceLocation("textures/block/" + dyecolor.getSerializedName() + "_stained_glass.png");
                modelpart.setTextureLocation(resourcelocation);
                Config.dbg("  " + s3 + ": " + dyecolor.getSerializedName());
            }
            ++j;
        }
        IEntityRenderer ientityrenderer = modeladapter.makeEntityRender(model, modeladapter.getShadowSize());
        if (ientityrenderer == null) {
            return null;
        }
        ientityrenderer.setType(modeladapter.getType());
        return ientityrenderer;
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path) {
        CustomEntityRenderer customentityrenderer = CustomEntityModelParser.parseEntityRender(obj, path);
        String s = customentityrenderer.getName();
        ModelAdapter modeladapter = CustomModelRegistry.getModelAdapter(s);
        CustomEntityModels.checkNull(modeladapter, "Entity not found: " + s);
        Either<EntityType, BlockEntityType> either = modeladapter.getType();
        CustomEntityModels.checkNull(either, "Entity type not found: " + s);
        IEntityRenderer ientityrenderer = CustomEntityModels.makeEntityRender(modeladapter, customentityrenderer);
        if (ientityrenderer == null) {
            return null;
        }
        ientityrenderer.setType(either);
        return ientityrenderer;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer) {
        Model model;
        ResourceLocation resourcelocation = cer.getTextureLocation();
        CustomModelRenderer[] acustommodelrenderer = cer.getCustomModelRenderers();
        float f = cer.getShadowSize();
        if (f < 0.0f) {
            f = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver modelresolver = new ModelResolver(modelAdapter, model, acustommodelrenderer);
        if (!CustomEntityModels.modifyModel(modelAdapter, model, acustommodelrenderer, modelresolver)) {
            return null;
        }
        IEntityRenderer ientityrenderer = modelAdapter.makeEntityRender(model, f);
        if (ientityrenderer == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (resourcelocation != null) {
            CustomEntityModels.setTextureLocation(modelAdapter, model, ientityrenderer, resourcelocation);
        }
        return ientityrenderer;
    }

    private static void setTextureLocation(ModelAdapter modelAdapter, Model model, IEntityRenderer er, ResourceLocation textureLocation) {
        if (!modelAdapter.setTextureLocation(er, textureLocation)) {
            if (er instanceof LivingEntityRenderer) {
                er.setLocationTextureCustom(textureLocation);
            } else {
                CustomEntityModels.setTextureTopModelRenderers(modelAdapter, model, textureLocation);
            }
        }
    }

    public static void setTextureTopModelRenderers(ModelAdapter modelAdapter, Model model, ResourceLocation textureLocation) {
        String[] astring = modelAdapter.getModelRendererNames();
        int i = 0;
        while (i < astring.length) {
            String s = astring[i];
            ModelPart modelpart = modelAdapter.getModelRenderer(model, s);
            if (modelpart != null && modelpart.getTextureLocation() == null) {
                modelpart.setTextureLocation(textureLocation);
            }
            ++i;
        }
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, Model model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        int i = 0;
        while (i < modelRenderers.length) {
            CustomModelRenderer custommodelrenderer = modelRenderers[i];
            if (!CustomEntityModels.modifyModel(modelAdapter, model, custommodelrenderer, mr)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, Model model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String s = customModelRenderer.getModelPart();
        ModelPart modelpart = modelAdapter.getModelRenderer(model, s);
        if (modelpart == null) {
            Config.warn("Model part not found: " + s + ", model: " + model);
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (modelpart.cubes != null) {
                modelpart.cubes.clear();
            }
            if (modelpart.spriteList != null) {
                modelpart.spriteList.clear();
            }
            if (modelpart.children != null) {
                ModelPart[] amodelpart = modelAdapter.getModelRenderers(model);
                Set set = Collections.newSetFromMap(new IdentityHashMap());
                set.addAll(Arrays.asList(amodelpart));
                for (String s1 : new HashSet<String>(modelpart.children.keySet())) {
                    ModelPart modelpart1 = modelpart.children.get(s1);
                    if (set.contains(modelpart1)) continue;
                    modelpart.children.remove(s1);
                }
            }
        }
        String s2 = modelpart.getUniqueChildModelName("CEM-" + s);
        modelpart.addChildModel(s2, customModelRenderer.getModelRenderer());
        ModelUpdater modelupdater = customModelRenderer.getModelUpdater();
        if (modelupdater != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(modelpart);
            if (!modelupdater.initialize(modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(modelupdater);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isCustomModel(BlockState blockStateIn) {
        int i = 0;
        while (i < customTileEntityTypes.size()) {
            BlockEntityType blockentitytype = customTileEntityTypes.get(i);
            if (blockentitytype.isValid(blockStateIn)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void onRenderScreen(Screen screen) {
        if (customBookModel != null && screen instanceof EnchantmentScreen) {
            EnchantmentScreen enchantmentscreen = (EnchantmentScreen)screen;
            Reflector.GuiEnchantment_bookModel.setValue(enchantmentscreen, customBookModel);
        }
    }
}

