/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.optifine.Config;
import net.optifine.entity.model.BannerModel;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterBanner
extends ModelAdapter {
    public ModelAdapterBanner() {
        super(BlockEntityType.BANNER, "banner", 0.0f);
    }

    @Override
    public Model makeModel() {
        return new BannerModel();
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof BannerModel)) {
            return null;
        }
        BannerModel bannermodel = (BannerModel)model;
        if (modelPart.equals("slate")) {
            return bannermodel.bannerSlate;
        }
        if (modelPart.equals("stand")) {
            return bannermodel.bannerStand;
        }
        return modelPart.equals("top") ? bannermodel.bannerTop : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"slate", "stand", "top"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model model, float shadowSize) {
        BlockEntityRenderDispatcher blockentityrenderdispatcher = Config.getMinecraft().getBlockEntityRenderDispatcher();
        BlockEntityRenderer blockentityrenderer = blockentityrenderdispatcher.getRenderer(BlockEntityType.BANNER);
        if (!(blockentityrenderer instanceof BannerRenderer)) {
            return null;
        }
        if (blockentityrenderer.getType() == null) {
            blockentityrenderer = new BannerRenderer(blockentityrenderdispatcher.getContext());
        }
        if (!(model instanceof BannerModel)) {
            Config.warn("Not a banner model: " + model);
            return null;
        }
        BannerModel bannermodel = (BannerModel)model;
        return bannermodel.updateRenderer(blockentityrenderer);
    }
}

