/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BatModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BatRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterBat
extends ModelAdapter {
    public ModelAdapterBat() {
        super(EntityType.BAT, "bat", 0.25f);
    }

    @Override
    public Model makeModel() {
        return new BatModel(ModelAdapterBat.bakeModelLayer(ModelLayers.BAT));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof BatModel)) {
            return null;
        }
        BatModel batmodel = (BatModel)model;
        if (modelPart.equals("head")) {
            return batmodel.root().getChildModelDeep("head");
        }
        if (modelPart.equals("body")) {
            return batmodel.root().getChildModelDeep("body");
        }
        if (modelPart.equals("right_wing")) {
            return batmodel.root().getChildModelDeep("right_wing");
        }
        if (modelPart.equals("left_wing")) {
            return batmodel.root().getChildModelDeep("left_wing");
        }
        if (modelPart.equals("outer_right_wing")) {
            return batmodel.root().getChildModelDeep("right_wing_tip");
        }
        return modelPart.equals("outer_left_wing") ? batmodel.root().getChildModelDeep("left_wing_tip") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"head", "body", "right_wing", "left_wing", "outer_right_wing", "outer_left_wing"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        BatRenderer batrenderer = new BatRenderer(entityrenderdispatcher.getContext());
        batrenderer.model = (BatModel)modelBase;
        batrenderer.shadowRadius = shadowSize;
        return batrenderer;
    }
}

