/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.blockentity.BedRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.optifine.Config;
import net.optifine.entity.model.BedModel;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterBed
extends ModelAdapter {
    public ModelAdapterBed() {
        super(BlockEntityType.BED, "bed", 0.0f);
    }

    @Override
    public Model makeModel() {
        return new BedModel();
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof BedModel)) {
            return null;
        }
        BedModel bedmodel = (BedModel)model;
        if (modelPart.equals("head")) {
            return bedmodel.headPiece;
        }
        if (modelPart.equals("foot")) {
            return bedmodel.footPiece;
        }
        ModelPart[] amodelpart = bedmodel.legs;
        if (amodelpart != null) {
            if (modelPart.equals("leg1")) {
                return amodelpart[0];
            }
            if (modelPart.equals("leg2")) {
                return amodelpart[1];
            }
            if (modelPart.equals("leg3")) {
                return amodelpart[2];
            }
            if (modelPart.equals("leg4")) {
                return amodelpart[3];
            }
        }
        return null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"head", "foot", "leg1", "leg2", "leg3", "leg4"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        BlockEntityRenderDispatcher blockentityrenderdispatcher = Config.getMinecraft().getBlockEntityRenderDispatcher();
        BlockEntityRenderer blockentityrenderer = blockentityrenderdispatcher.getRenderer(BlockEntityType.BED);
        if (!(blockentityrenderer instanceof BedRenderer)) {
            return null;
        }
        if (blockentityrenderer.getType() == null) {
            blockentityrenderer = new BedRenderer(blockentityrenderdispatcher.getContext());
        }
        if (!(modelBase instanceof BedModel)) {
            Config.warn("Not a BedModel: " + modelBase);
            return null;
        }
        BedModel bedmodel = (BedModel)modelBase;
        return bedmodel.updateRenderer(blockentityrenderer);
    }
}

